/*
 * Decompiled with CFR 0.152.
 */
package com.wafflecopter.multicontactpicker;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.wafflecopter.multicontactpicker.RxContacts.Contact;
import com.wafflecopter.multicontactpicker.RxContacts.PhoneNumber;
import java.util.ArrayList;
import java.util.List;

public class ContactResult
implements Parcelable {
    private String mContactID;
    private String mDisplayName;
    private boolean mStarred;
    private Uri mPhoto;
    private Uri mThumbnail;
    private List<String> mEmails = new ArrayList<String>();
    private List<PhoneNumber> mPhoneNumbers = new ArrayList<PhoneNumber>();
    public static final Parcelable.Creator<ContactResult> CREATOR = new Parcelable.Creator<ContactResult>(){

        public ContactResult createFromParcel(Parcel in) {
            return new ContactResult(in);
        }

        public ContactResult[] newArray(int size) {
            return new ContactResult[size];
        }
    };

    public String getContactID() {
        return this.mContactID;
    }

    public void setContactID(String mContactID) {
        this.mContactID = mContactID;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean isStarred() {
        return this.mStarred;
    }

    public Uri getPhoto() {
        return this.mPhoto;
    }

    public Uri getThumbnail() {
        return this.mThumbnail;
    }

    public List<String> getEmails() {
        return this.mEmails;
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.mPhoneNumbers;
    }

    public ContactResult(Contact contact) {
        this.mContactID = String.valueOf(contact.getId());
        this.mDisplayName = contact.getDisplayName();
        this.mStarred = contact.isStarred();
        this.mPhoto = contact.getPhoto();
        this.mThumbnail = contact.getThumbnail();
        this.mEmails.clear();
        this.mEmails.addAll(contact.getEmails());
        this.mPhoneNumbers.clear();
        this.mPhoneNumbers.addAll(contact.getPhoneNumbers());
    }

    protected ContactResult(Parcel in) {
        this.mContactID = in.readString();
        this.mDisplayName = in.readString();
        this.mStarred = in.readByte() != 0;
        this.mPhoto = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.mThumbnail = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.mEmails = in.createStringArrayList();
        in.readTypedList(this.mPhoneNumbers, PhoneNumber.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mContactID);
        dest.writeString(this.mDisplayName);
        dest.writeByte(this.mStarred ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.mPhoto, flags);
        dest.writeParcelable((Parcelable)this.mThumbnail, flags);
        dest.writeStringList(this.mEmails);
        dest.writeTypedList(this.mPhoneNumbers);
    }
}

