/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android.handler.filelog;

import java.io.File;
import java.lang.reflect.Field;
import java.util.logging.FileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileHandlerExpose {
    private static final Logger LOG = LoggerFactory.getLogger((String)FileHandlerExpose.class.getSimpleName());
    private static Field fileNameField;
    private static Field filesField;

    FileHandlerExpose() {
    }

    public synchronized String getCurrentFileName(FileHandler fileHandler) {
        Field fileNameField;
        if (fileHandler == null) {
            throw new IllegalArgumentException("fileHandler must not be null");
        }
        Field filesField = this.getFilesField(fileHandler);
        if (filesField != null) {
            try {
                File[] files = (File[])filesField.get(fileHandler);
                return files != null && files.length >= 1 ? files[0].getAbsolutePath() : null;
            }
            catch (IllegalAccessException e) {
                LOG.warn("Cant read 'files' field value from {}", (Object)fileHandler, (Object)e);
            }
        }
        if ((fileNameField = this.getFileNameField(fileHandler)) != null) {
            try {
                return (String)fileNameField.get(fileHandler);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Cant read 'fileName' field value from {}", (Object)fileHandler, (Object)e);
            }
        }
        return null;
    }

    private Field getFileNameField(FileHandler fileHandler) {
        if (fileNameField == null) {
            fileNameField = this.getFileHandlerField(fileHandler, "fileName");
        }
        return fileNameField;
    }

    private Field getFilesField(FileHandler fileHandler) {
        if (filesField == null) {
            filesField = this.getFileHandlerField(fileHandler, "files");
        }
        return filesField;
    }

    private Field getFileHandlerField(FileHandler fileHandler, String fieldName) {
        Field field = null;
        try {
            field = fileHandler.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LOG.warn("Could not find field '{}' inside class {}", (Object)fieldName, fileHandler.getClass());
        }
        return field;
    }
}

