/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import java.util.logging.Level;

public enum LogLevel {
    TRACE(Level.FINEST, 2),
    DEBUG(Level.FINE, 3),
    INFO(Level.INFO, 4),
    WARNING(Level.WARNING, 5),
    ERROR(Level.SEVERE, 6);

    private final Level utilLogLevel;
    private final int androidLogLevel;

    private LogLevel(Level utilLogLevel, int androidLogLevel) {
        this.utilLogLevel = utilLogLevel;
        this.androidLogLevel = androidLogLevel;
    }

    public static LogLevel valueOf(Level utilLogLevel) {
        for (LogLevel level : LogLevel.values()) {
            if (level.utilLogLevel != utilLogLevel) continue;
            return level;
        }
        return TRACE;
    }

    public boolean isSmallerOrEqualTo(Level level) {
        return this.utilLogLevel.intValue() <= level.intValue();
    }

    public int getAndroidLevel() {
        return this.androidLogLevel;
    }

    public Level getUtilLogLevel() {
        return this.utilLogLevel;
    }
}

