/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.text.TextUtils;
import pl.brightinventions.slf4android.ConstLoggerValueSupplier;
import pl.brightinventions.slf4android.ListLogRecordFormatter;
import pl.brightinventions.slf4android.LogRecordFormatter;
import pl.brightinventions.slf4android.LoggerPattern;
import pl.brightinventions.slf4android.LoggerPatternConfiguration;

public class HandlerFormatterCompiler {
    private final LoggerPatternConfiguration configuration;

    public HandlerFormatterCompiler(LoggerPatternConfiguration configuration) {
        this.configuration = configuration;
    }

    public LogRecordFormatter compile(String formatterPattern) {
        ListLogRecordFormatter formatter = new ListLogRecordFormatter();
        while (!TextUtils.isEmpty((CharSequence)formatterPattern)) {
            int firstPatternIndex = Integer.MAX_VALUE;
            LoggerPattern firstPattern = null;
            for (LoggerPattern loggerPattern : this.configuration.getPatterns()) {
                String pattern = loggerPattern.getPattern();
                int patternIndex = formatterPattern.indexOf(pattern);
                if (patternIndex == -1 || patternIndex >= firstPatternIndex) continue;
                firstPatternIndex = patternIndex;
                firstPattern = loggerPattern;
            }
            if (firstPattern != null) {
                if (firstPatternIndex > 0) {
                    formatter.add(new ConstLoggerValueSupplier(formatterPattern.substring(0, firstPatternIndex)));
                }
                formatter.add(firstPattern);
                formatterPattern = formatterPattern.substring(firstPatternIndex + firstPattern.getPattern().length());
                continue;
            }
            formatter.add(new ConstLoggerValueSupplier(formatterPattern));
            formatterPattern = null;
        }
        return formatter;
    }
}

