/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.controls;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.ui.animation.BottomViewHideShowAnimation;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.ui.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.ui.widget.controls.DefaultVideoControls;
import com.devbrackets.android.exomedia.util.LongExtensionsKt;
import com.devbrackets.android.exomedia.util.ResourceExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 f2\u00020\u0001:\u0005efghiB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0014J\b\u0010A\u001a\u00020>H\u0016J\u0012\u0010B\u001a\u00020>2\b\u0010C\u001a\u0004\u0018\u00010\u001dH\u0004J\u0012\u0010D\u001a\u00020>2\b\u0010C\u001a\u0004\u0018\u00010\u001dH\u0004J\b\u0010E\u001a\u00020>H\u0014J\b\u0010F\u001a\u00020>H\u0004J\b\u0010G\u001a\u00020>H\u0004J\u0010\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020JH\u0004J\b\u0010K\u001a\u00020>H\u0004J\b\u0010L\u001a\u00020>H\u0014J\b\u0010M\u001a\u00020>H\u0014J\u0010\u0010N\u001a\u00020>2\u0006\u0010O\u001a\u00020JH\u0016J\u0010\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020@H\u0016J\u0010\u0010R\u001a\u00020>2\u0006\u0010S\u001a\u00020@H\u0016J\u0010\u0010T\u001a\u00020>2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020>2\u0006\u0010X\u001a\u00020JH\u0016J\u0010\u0010Y\u001a\u00020>2\u0006\u0010Q\u001a\u00020@H\u0016J\u0010\u0010Z\u001a\u00020>2\u0006\u0010S\u001a\u00020@H\u0016J\u0010\u0010[\u001a\u00020>2\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010\\\u001a\u00020>2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010]\u001a\u00020>2\u0006\u0010^\u001a\u00020@H\u0016J\b\u0010_\u001a\u00020>H\u0004J\b\u0010`\u001a\u00020>H\u0014J\u0010\u0010`\u001a\u00020>2\u0006\u0010a\u001a\u00020\tH\u0014J&\u0010b\u001a\u00020>2\b\b\u0001\u0010X\u001a\u00020J2\b\b\u0001\u0010O\u001a\u00020J2\b\b\u0001\u0010c\u001a\u00020\tH\u0016J\b\u0010d\u001a\u00020>H\u0014R\u001e\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u00010#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010%\"\u0004\b3\u0010'R\u001a\u00104\u001a\u000205X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\u0014X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0016\"\u0004\b<\u0010\u0018\u00a8\u0006j"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "buttonFocusChangeListener", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$ButtonFocusChangeListener;", "getButtonFocusChangeListener", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$ButtonFocusChangeListener;", "setButtonFocusChangeListener", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$ButtonFocusChangeListener;)V", "controlsContainer", "Landroid/view/ViewGroup;", "getControlsContainer", "()Landroid/view/ViewGroup;", "setControlsContainer", "(Landroid/view/ViewGroup;)V", "controlsParent", "getControlsParent", "setControlsParent", "currentFocus", "Landroid/view/View;", "getCurrentFocus", "()Landroid/view/View;", "setCurrentFocus", "(Landroid/view/View;)V", "fastForwardButton", "Landroid/widget/ImageButton;", "getFastForwardButton", "()Landroid/widget/ImageButton;", "setFastForwardButton", "(Landroid/widget/ImageButton;)V", "layoutResource", "getLayoutResource", "()I", "progressBar", "Landroid/widget/ProgressBar;", "getProgressBar", "()Landroid/widget/ProgressBar;", "setProgressBar", "(Landroid/widget/ProgressBar;)V", "rewindButton", "getRewindButton", "setRewindButton", "rippleIndicator", "Landroid/widget/ImageView;", "getRippleIndicator", "()Landroid/widget/ImageView;", "setRippleIndicator", "(Landroid/widget/ImageView;)V", "textContainer", "getTextContainer", "setTextContainer", "animateVisibility", "", "toVisible", "", "finishLoading", "focusNext", "view", "focusPrevious", "onAttachedToWindow", "onFastForwardClick", "onRewindClick", "performSeek", "seekToTime", "", "registerForInput", "registerListeners", "retrieveViews", "setDuration", "duration", "setFastForwardButtonEnabled", "enabled", "setFastForwardButtonRemoved", "removed", "setFastForwardDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setPosition", "position", "setRewindButtonEnabled", "setRewindButtonRemoved", "setRewindDrawable", "setup", "showLoading", "initialLoad", "showTemporary", "updateButtonDrawables", "tintList", "updateProgress", "bufferPercent", "updateTextContainerVisibility", "ButtonFocusChangeListener", "Companion", "LeanbackInternalListener", "RemoteKeyListener", "RippleTranslateAnimation", "library_release"})
@TargetApi(value=21)
public final class VideoControlsLeanback
extends DefaultVideoControls {
    protected ViewGroup controlsContainer;
    protected ViewGroup textContainer;
    protected ProgressBar progressBar;
    protected ImageView rippleIndicator;
    protected ViewGroup controlsParent;
    @Nullable
    private ImageButton fastForwardButton;
    @Nullable
    private ImageButton rewindButton;
    @Nullable
    private View currentFocus;
    @NotNull
    private ButtonFocusChangeListener buttonFocusChangeListener;
    private static final int FAST_FORWARD_REWIND_AMOUNT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected final ViewGroup getControlsContainer() {
        ViewGroup viewGroup = this.controlsContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlsContainer");
        }
        return viewGroup;
    }

    protected final void setControlsContainer(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.controlsContainer = viewGroup;
    }

    @NotNull
    protected final ViewGroup getTextContainer() {
        ViewGroup viewGroup = this.textContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
        }
        return viewGroup;
    }

    protected final void setTextContainer(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.textContainer = viewGroup;
    }

    @NotNull
    protected final ProgressBar getProgressBar() {
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        return progressBar;
    }

    protected final void setProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"<set-?>");
        this.progressBar = progressBar;
    }

    @NotNull
    protected final ImageView getRippleIndicator() {
        ImageView imageView = this.rippleIndicator;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rippleIndicator");
        }
        return imageView;
    }

    protected final void setRippleIndicator(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
        this.rippleIndicator = imageView;
    }

    @NotNull
    protected final ViewGroup getControlsParent() {
        ViewGroup viewGroup = this.controlsParent;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlsParent");
        }
        return viewGroup;
    }

    protected final void setControlsParent(@NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"<set-?>");
        this.controlsParent = viewGroup;
    }

    @Nullable
    protected final ImageButton getFastForwardButton() {
        return this.fastForwardButton;
    }

    protected final void setFastForwardButton(@Nullable ImageButton imageButton) {
        this.fastForwardButton = imageButton;
    }

    @Nullable
    protected final ImageButton getRewindButton() {
        return this.rewindButton;
    }

    protected final void setRewindButton(@Nullable ImageButton imageButton) {
        this.rewindButton = imageButton;
    }

    @Nullable
    protected final View getCurrentFocus() {
        return this.currentFocus;
    }

    protected final void setCurrentFocus(@Nullable View view) {
        this.currentFocus = view;
    }

    @NotNull
    protected final ButtonFocusChangeListener getButtonFocusChangeListener() {
        return this.buttonFocusChangeListener;
    }

    protected final void setButtonFocusChangeListener(@NotNull ButtonFocusChangeListener buttonFocusChangeListener) {
        Intrinsics.checkNotNullParameter((Object)buttonFocusChangeListener, (String)"<set-?>");
        this.buttonFocusChangeListener = buttonFocusChangeListener;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_default_controls_leanback;
    }

    @Override
    protected void setup(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.setup(context);
        this.setInternalListener(new LeanbackInternalListener());
        this.registerForInput();
        this.setFocusable(true);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getPlayPauseButton().requestFocus();
        this.currentFocus = (View)this.getPlayPauseButton();
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        View view = this.findViewById(R.id.exomedia_controls_interactive_container);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.exomed\u2026ls_interactive_container)");
        this.controlsContainer = (ViewGroup)view;
        View view2 = this.findViewById(R.id.exomedia_controls_text_container);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.exomed\u2026_controls_text_container)");
        this.textContainer = (ViewGroup)view2;
        View view3 = this.findViewById(R.id.exomedia_controls_video_progress);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.exomed\u2026_controls_video_progress)");
        this.progressBar = (ProgressBar)view3;
        View view4 = this.findViewById(R.id.exomedia_controls_leanback_ripple);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.exomed\u2026controls_leanback_ripple)");
        this.rippleIndicator = (ImageView)view4;
        View view5 = this.findViewById(R.id.exomedia_controls_parent);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.exomedia_controls_parent)");
        this.controlsParent = (ViewGroup)view5;
        this.fastForwardButton = (ImageButton)this.findViewById(R.id.exomedia_controls_fast_forward_btn);
        this.rewindButton = (ImageButton)this.findViewById(R.id.exomedia_controls_rewind_btn);
    }

    @Override
    public void setPosition(long position) {
        this.getCurrentTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(position));
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        progressBar.setProgress((int)position);
    }

    @Override
    public void setDuration(long duration) {
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        if (duration != (long)progressBar.getMax()) {
            this.getEndTimeTextView().setText((CharSequence)LongExtensionsKt.millisToFormattedTimeString(duration));
            ProgressBar progressBar2 = this.progressBar;
            if (progressBar2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            }
            progressBar2.setMax((int)duration);
        }
    }

    @Override
    public void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        ProgressBar progressBar2 = this.progressBar;
        if (progressBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        progressBar.setSecondaryProgress((int)((float)progressBar2.getMax() * ((float)bufferPercent / (float)100)));
        ProgressBar progressBar3 = this.progressBar;
        if (progressBar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        progressBar3.setProgress((int)position);
        this.updateCurrentTime(position);
    }

    @Override
    public void setRewindDrawable(@NotNull Drawable drawable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            ImageButton imageButton = this.rewindButton;
            if (imageButton == null) break block0;
            imageButton.setImageDrawable(drawable);
        }
    }

    @Override
    public void setFastForwardDrawable(@NotNull Drawable drawable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            ImageButton imageButton = this.fastForwardButton;
            if (imageButton == null) break block0;
            imageButton.setImageDrawable(drawable);
        }
    }

    @Override
    public void setRewindButtonEnabled(boolean enabled) {
        block0: {
            ImageButton imageButton = this.rewindButton;
            if (imageButton == null) break block0;
            ImageButton imageButton2 = imageButton;
            boolean bl = false;
            boolean bl2 = false;
            ImageButton it = imageButton2;
            boolean bl3 = false;
            it.setEnabled(enabled);
            this.getEnabledViews().put(R.id.exomedia_controls_rewind_btn, enabled);
        }
    }

    @Override
    public void setFastForwardButtonEnabled(boolean enabled) {
        block0: {
            ImageButton imageButton = this.fastForwardButton;
            if (imageButton == null) break block0;
            ImageButton imageButton2 = imageButton;
            boolean bl = false;
            boolean bl2 = false;
            ImageButton it = imageButton2;
            boolean bl3 = false;
            it.setEnabled(enabled);
            this.getEnabledViews().put(R.id.exomedia_controls_fast_forward_btn, enabled);
        }
    }

    @Override
    public void setRewindButtonRemoved(boolean removed) {
        block0: {
            ImageButton imageButton = this.rewindButton;
            if (imageButton == null) break block0;
            imageButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    public void setFastForwardButtonRemoved(boolean removed) {
        block0: {
            ImageButton imageButton = this.fastForwardButton;
            if (imageButton == null) break block0;
            imageButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        ImageButton imageButton = this.rewindButton;
        if (imageButton != null) {
            imageButton.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ VideoControlsLeanback this$0;

                public final void onClick(View it) {
                    this.this$0.onRewindClick();
                }
                {
                    this.this$0 = videoControlsLeanback;
                }
            });
        }
        ImageButton imageButton2 = this.fastForwardButton;
        if (imageButton2 != null) {
            imageButton2.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ VideoControlsLeanback this$0;

                public final void onClick(View it) {
                    this.this$0.onFastForwardClick();
                }
                {
                    this.this$0 = videoControlsLeanback;
                }
            });
        }
        this.getPreviousButton().setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        ImageButton imageButton3 = this.rewindButton;
        if (imageButton3 != null) {
            imageButton3.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        }
        this.getPlayPauseButton().setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        ImageButton imageButton4 = this.fastForwardButton;
        if (imageButton4 != null) {
            imageButton4.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        }
        this.getNextButton().setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
    }

    @Override
    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.exomedia_default_controls_leanback_button_selector);
    }

    @Override
    protected void updateButtonDrawables(int tintList) {
        block1: {
            super.updateButtonDrawables(tintList);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Drawable rewindDrawable = ResourceExtensionsKt.tintListCompat(context, R.drawable.exomedia_ic_rewind_white, tintList);
            ImageButton imageButton = this.rewindButton;
            if (imageButton != null) {
                imageButton.setImageDrawable(rewindDrawable);
            }
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            Drawable fastForwardDrawable = ResourceExtensionsKt.tintListCompat(context2, R.drawable.exomedia_ic_fast_forward_white, tintList);
            ImageButton imageButton2 = this.fastForwardButton;
            if (imageButton2 == null) break block1;
            imageButton2.setImageDrawable(fastForwardDrawable);
        }
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible() == toVisible) {
            return;
        }
        if (!this.isLoading()) {
            ViewGroup viewGroup = this.controlsParent;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"controlsParent");
            }
            ViewGroup viewGroup2 = this.controlsParent;
            if (viewGroup2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"controlsParent");
            }
            viewGroup.startAnimation((Animation)new BottomViewHideShowAnimation((View)viewGroup2, toVisible, DefaultVideoControls.Companion.getCONTROL_VISIBILITY_ANIMATION_LENGTH()));
        }
        this.setVisible(toVisible);
        this.onVisibilityChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void updateTextContainerVisibility() {
        if (!this.isVisible()) {
            return;
        }
        boolean emptyText = this.isTextContainerEmpty();
        if (this.getHideEmptyTextContainer() && emptyText) {
            ViewGroup viewGroup = this.textContainer;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
            }
            if (viewGroup.getVisibility() == 0) {
                ViewGroup viewGroup2 = this.textContainer;
                if (viewGroup2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
                }
                viewGroup2.clearAnimation();
                ViewGroup viewGroup3 = this.textContainer;
                if (viewGroup3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
                }
                ViewGroup viewGroup4 = this.textContainer;
                if (viewGroup4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
                }
                viewGroup3.startAnimation((Animation)new BottomViewHideShowAnimation((View)viewGroup4, false, DefaultVideoControls.Companion.getCONTROL_VISIBILITY_ANIMATION_LENGTH()));
                return;
            }
        }
        if (this.getHideEmptyTextContainer()) {
            if (emptyText) return;
        }
        ViewGroup viewGroup = this.textContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
        }
        if (viewGroup.getVisibility() == 0) return;
        ViewGroup viewGroup5 = this.textContainer;
        if (viewGroup5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
        }
        viewGroup5.clearAnimation();
        ViewGroup viewGroup6 = this.textContainer;
        if (viewGroup6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
        }
        ViewGroup viewGroup7 = this.textContainer;
        if (viewGroup7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textContainer");
        }
        viewGroup6.startAnimation((Animation)new BottomViewHideShowAnimation((View)viewGroup7, true, DefaultVideoControls.Companion.getCONTROL_VISIBILITY_ANIMATION_LENGTH()));
    }

    @Override
    public void showLoading(boolean initialLoad) {
        if (this.isLoading()) {
            return;
        }
        this.setLoading(true);
        ViewGroup viewGroup = this.controlsContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlsContainer");
        }
        viewGroup.setVisibility(8);
        ImageView imageView = this.rippleIndicator;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rippleIndicator");
        }
        imageView.setVisibility(8);
        this.getLoadingProgressBar().setVisibility(0);
        this.show();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void finishLoading() {
        if (!this.isLoading()) {
            return;
        }
        this.setLoading(false);
        v0 = this.controlsContainer;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"controlsContainer");
        }
        v0.setVisibility(0);
        v1 = this.rippleIndicator;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rippleIndicator");
        }
        v1.setVisibility(0);
        this.getLoadingProgressBar().setVisibility(8);
        if (this.getVideoView() == null) ** GOTO lbl-1000
        v2 = this.getVideoView();
        Intrinsics.checkNotNull((Object)v2);
        if (v2.isPlaying()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        this.updatePlaybackState(v3);
    }

    protected final void onRewindClick() {
        block3: {
            block2: {
                if (this.getButtonsListener() == null) break block2;
                VideoControlsButtonListener videoControlsButtonListener = this.getButtonsListener();
                Intrinsics.checkNotNull((Object)videoControlsButtonListener);
                if (videoControlsButtonListener.onRewindClicked()) break block3;
            }
            this.getInternalListener().onRewindClicked();
        }
    }

    protected final void onFastForwardClick() {
        block3: {
            block2: {
                if (this.getButtonsListener() == null) break block2;
                VideoControlsButtonListener videoControlsButtonListener = this.getButtonsListener();
                Intrinsics.checkNotNull((Object)videoControlsButtonListener);
                if (videoControlsButtonListener.onFastForwardClicked()) break block3;
            }
            this.getInternalListener().onFastForwardClicked();
        }
    }

    protected final void performSeek(long seekToTime) {
        block3: {
            block2: {
                if (this.getSeekListener() == null) break block2;
                VideoControlsSeekListener videoControlsSeekListener = this.getSeekListener();
                Intrinsics.checkNotNull((Object)videoControlsSeekListener);
                if (videoControlsSeekListener.onSeekEnded(seekToTime)) break block3;
            }
            this.show();
            this.getInternalListener().onSeekEnded(seekToTime);
        }
    }

    protected final void showTemporary() {
        this.show();
        VideoView videoView = this.getVideoView();
        if (videoView != null) {
            if (videoView.isPlaying()) {
                this.hideDelayed();
            }
        }
    }

    protected final void registerForInput() {
        block1: {
            RemoteKeyListener remoteKeyListener = new RemoteKeyListener();
            this.setOnKeyListener(remoteKeyListener);
            this.getPlayPauseButton().setOnKeyListener((View.OnKeyListener)remoteKeyListener);
            this.getPreviousButton().setOnKeyListener((View.OnKeyListener)remoteKeyListener);
            this.getNextButton().setOnKeyListener((View.OnKeyListener)remoteKeyListener);
            ImageButton imageButton = this.rewindButton;
            if (imageButton != null) {
                imageButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
            }
            ImageButton imageButton2 = this.fastForwardButton;
            if (imageButton2 == null) break block1;
            imageButton2.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        }
    }

    protected final void focusNext(@Nullable View view) {
        View nextView;
        if (view == null) {
            return;
        }
        int nextId = view.getNextFocusRightId();
        if (nextId == -1) {
            return;
        }
        View view2 = nextView = this.findViewById(nextId);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"nextView");
        if (view2.getVisibility() != 0) {
            this.focusNext(nextView);
            return;
        }
        nextView.requestFocus();
        this.currentFocus = nextView;
        this.buttonFocusChangeListener.onFocusChange(nextView, true);
    }

    protected final void focusPrevious(@Nullable View view) {
        View previousView;
        if (view == null) {
            return;
        }
        int previousId = view.getNextFocusLeftId();
        if (previousId == -1) {
            return;
        }
        View view2 = previousView = this.findViewById(previousId);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"previousView");
        if (view2.getVisibility() != 0) {
            this.focusPrevious(previousView);
            return;
        }
        previousView.requestFocus();
        this.currentFocus = previousView;
        this.buttonFocusChangeListener.onFocusChange(previousView, true);
    }

    public VideoControlsLeanback(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.buttonFocusChangeListener = new ButtonFocusChangeListener();
    }

    public VideoControlsLeanback(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.buttonFocusChangeListener = new ButtonFocusChangeListener();
    }

    public VideoControlsLeanback(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.buttonFocusChangeListener = new ButtonFocusChangeListener();
    }

    public VideoControlsLeanback(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.buttonFocusChangeListener = new ButtonFocusChangeListener();
    }

    static {
        Companion = new Companion(null);
        FAST_FORWARD_REWIND_AMOUNT = 10000;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$ButtonFocusChangeListener;", "Landroid/view/View$OnFocusChangeListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback;)V", "getHorizontalDelta", "", "selectedView", "Landroid/view/View;", "onFocusChange", "", "view", "hasFocus", "", "library_release"})
    protected final class ButtonFocusChangeListener
    implements View.OnFocusChangeListener {
        public void onFocusChange(@NotNull View view, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (!hasFocus) {
                return;
            }
            int xDelta = this.getHorizontalDelta(view);
            VideoControlsLeanback.this.getRippleIndicator().startAnimation((Animation)new RippleTranslateAnimation(xDelta));
        }

        protected final int getHorizontalDelta(@NotNull View selectedView) {
            Intrinsics.checkNotNullParameter((Object)selectedView, (String)"selectedView");
            int[] position = new int[2];
            selectedView.getLocationOnScreen(position);
            int viewX = position[0];
            VideoControlsLeanback.this.getRippleIndicator().getLocationOnScreen(position);
            int newRippleX = viewX - (VideoControlsLeanback.this.getRippleIndicator().getWidth() - selectedView.getWidth()) / 2;
            return newRippleX - position[0];
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$RemoteKeyListener;", "Landroid/view/View$OnKeyListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback;)V", "onKey", "", "view", "Landroid/view/View;", "keyCode", "", "event", "Landroid/view/KeyEvent;", "library_release"})
    protected final class RemoteKeyListener
    implements View.OnKeyListener {
        public boolean onKey(@NotNull View view, int keyCode, @NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getAction() != 0) {
                return false;
            }
            switch (keyCode) {
                case 4: {
                    if (VideoControlsLeanback.this.isVisible() && VideoControlsLeanback.this.getCanViewHide() && !VideoControlsLeanback.this.isLoading()) {
                        VideoControlsLeanback.this.hide();
                        return true;
                    }
                    if (VideoControlsLeanback.this.getControlsParent().getAnimation() == null) break;
                    return true;
                }
                case 19: {
                    VideoControlsLeanback.this.showTemporary();
                    return true;
                }
                case 20: {
                    VideoControlsLeanback.this.hide();
                    return true;
                }
                case 21: {
                    VideoControlsLeanback.this.showTemporary();
                    VideoControlsLeanback.this.focusPrevious(VideoControlsLeanback.this.getCurrentFocus());
                    return true;
                }
                case 22: {
                    VideoControlsLeanback.this.showTemporary();
                    VideoControlsLeanback.this.focusNext(VideoControlsLeanback.this.getCurrentFocus());
                    return true;
                }
                case 23: {
                    VideoControlsLeanback.this.showTemporary();
                    View view2 = VideoControlsLeanback.this.getCurrentFocus();
                    if (view2 != null) {
                        view2.callOnClick();
                    }
                    return true;
                }
                case 85: {
                    VideoControlsLeanback.this.onPlayPauseClick();
                    return true;
                }
                case 126: {
                    if (VideoControlsLeanback.this.getVideoView() == null) break;
                    VideoView videoView = VideoControlsLeanback.this.getVideoView();
                    Intrinsics.checkNotNull((Object)((Object)videoView));
                    if (videoView.isPlaying()) break;
                    VideoView videoView2 = VideoControlsLeanback.this.getVideoView();
                    if (videoView2 != null) {
                        videoView2.start();
                    }
                    return true;
                }
                case 127: {
                    if (VideoControlsLeanback.this.getVideoView() == null) break;
                    VideoView videoView = VideoControlsLeanback.this.getVideoView();
                    Intrinsics.checkNotNull((Object)((Object)videoView));
                    if (!videoView.isPlaying()) break;
                    VideoView videoView3 = VideoControlsLeanback.this.getVideoView();
                    if (videoView3 != null) {
                        VideoView.pause$default(videoView3, false, 1, null);
                    }
                    return true;
                }
                case 87: {
                    VideoControlsLeanback.this.onNextClick();
                    return true;
                }
                case 88: {
                    VideoControlsLeanback.this.onPreviousClick();
                    return true;
                }
                case 89: {
                    VideoControlsLeanback.this.onRewindClick();
                    return true;
                }
                case 90: {
                    VideoControlsLeanback.this.onFastForwardClick();
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$RippleTranslateAnimation;", "Landroid/view/animation/TranslateAnimation;", "Landroid/view/animation/Animation$AnimationListener;", "xDelta", "", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback;I)V", "getXDelta", "()I", "setXDelta", "(I)V", "onAnimationEnd", "", "animation", "Landroid/view/animation/Animation;", "onAnimationRepeat", "onAnimationStart", "library_release"})
    protected final class RippleTranslateAnimation
    extends TranslateAnimation
    implements Animation.AnimationListener {
        private int xDelta;

        public void onAnimationStart(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        }

        public void onAnimationEnd(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            VideoControlsLeanback.this.getRippleIndicator().setX(VideoControlsLeanback.this.getRippleIndicator().getX() + (float)this.xDelta);
            VideoControlsLeanback.this.getRippleIndicator().clearAnimation();
        }

        public void onAnimationRepeat(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        }

        protected final int getXDelta() {
            return this.xDelta;
        }

        protected final void setXDelta(int n) {
            this.xDelta = n;
        }

        public RippleTranslateAnimation(int xDelta) {
            super(0.0f, (float)xDelta, 0.0f, 0.0f);
            this.xDelta = xDelta;
            this.setDuration(250L);
            this.setAnimationListener(this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$LeanbackInternalListener;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls$InternalListener;", "Lcom/devbrackets/android/exomedia/ui/widget/controls/DefaultVideoControls;", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback;)V", "onFastForwardClicked", "", "onRewindClicked", "library_release"})
    protected final class LeanbackInternalListener
    extends DefaultVideoControls.InternalListener {
        @Override
        public boolean onFastForwardClicked() {
            boolean bl;
            VideoView videoView = VideoControlsLeanback.this.getVideoView();
            if (videoView != null) {
                VideoView videoView2 = videoView;
                boolean bl2 = false;
                boolean bl3 = false;
                VideoView it = videoView2;
                boolean bl4 = false;
                long newPosition = it.getCurrentPosition() + (long)Companion.getFAST_FORWARD_REWIND_AMOUNT();
                if (newPosition > (long)VideoControlsLeanback.this.getProgressBar().getMax()) {
                    newPosition = VideoControlsLeanback.this.getProgressBar().getMax();
                }
                VideoControlsLeanback.this.performSeek(newPosition);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean onRewindClicked() {
            boolean bl;
            VideoView videoView = VideoControlsLeanback.this.getVideoView();
            if (videoView != null) {
                VideoView videoView2 = videoView;
                boolean bl2 = false;
                boolean bl3 = false;
                VideoView it = videoView2;
                boolean bl4 = false;
                long newPosition = it.getCurrentPosition() - (long)Companion.getFAST_FORWARD_REWIND_AMOUNT();
                if (newPosition < 0L) {
                    newPosition = 0L;
                }
                VideoControlsLeanback.this.performSeek(newPosition);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public LeanbackInternalListener() {
            super(VideoControlsLeanback.this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControlsLeanback$Companion;", "", "()V", "FAST_FORWARD_REWIND_AMOUNT", "", "getFAST_FORWARD_REWIND_AMOUNT", "()I", "library_release"})
    public static final class Companion {
        protected final int getFAST_FORWARD_REWIND_AMOUNT() {
            return FAST_FORWARD_REWIND_AMOUNT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

