/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.video.ExoVideoPlayer;
import com.devbrackets.android.exomedia.core.video.VideoPlayerApi;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.core.video.surface.VideoSurface;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.listener.OnVideoSizeChangedListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributeParser;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributes;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControls;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControlsLeanback;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControlsMobile;
import com.devbrackets.android.exomedia.util.ContextExtensionsKt;
import com.devbrackets.android.exomedia.util.FallbackManager;
import com.devbrackets.android.exomedia.util.StopWatch;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001:\u0006\u00d7\u0001\u00d8\u0001\u00d9\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u001bJ\u0007\u0010\u0087\u0001\u001a\u00020qJ\u0019\u0010\u0088\u0001\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\u001b2\u0007\u0010\u0089\u0001\u001a\u00020\tJ\u001c\u0010\u008a\u0001\u001a\u00030\u0085\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0004J\u0010\u0010\u008d\u0001\u001a\u00020-2\u0007\u0010\u0086\u0001\u001a\u00020\u001bJ\n\u0010\u008e\u0001\u001a\u00030\u0085\u0001H\u0014J\n\u0010\u008f\u0001\u001a\u00030\u0085\u0001H\u0004J\u0010\u0010\u0090\u0001\u001a\u00030\u0085\u00012\u0006\u0010*\u001a\u00020'J\u0010\u0010M\u001a\u00030\u0085\u00012\u0007\u0010\u0091\u0001\u001a\u00020-J\u0015\u0010\u0092\u0001\u001a\u00030\u0085\u00012\t\b\u0002\u0010\u0093\u0001\u001a\u00020-H\u0007J\u0014\u0010\u0094\u0001\u001a\u00030\u0085\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0004J\b\u0010\u0095\u0001\u001a\u00030\u0085\u0001J\b\u0010\u0096\u0001\u001a\u00030\u0085\u0001J\u0007\u0010\u0097\u0001\u001a\u00020-J\b\u0010\u0098\u0001\u001a\u00030\u0085\u0001J\u0011\u0010\u0099\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u009a\u0001\u001a\u00020'J\u0014\u0010\u009b\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u0001J\u0014\u0010\u009e\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009f\u0001J\u0014\u0010\u00a0\u0001\u001a\u00030\u0085\u00012\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a2\u0001J\u0014\u0010\u00a3\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00a4\u0001J\u0011\u0010\u00a5\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00a6\u0001\u001a\u00020-J\u0014\u0010\u00a7\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00a8\u0001J\u0014\u0010\u00a9\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00aa\u0001J\u0014\u0010\u00ab\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00ac\u0001J\u0014\u0010\u00ad\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00ae\u0001J\u0014\u0010\u00af\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00b0\u0001J\u0016\u0010\u00b1\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00b2\u0001H\u0016J\u0014\u0010\u00b3\u0001\u001a\u00030\u0085\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u00b4\u0001J\u0011\u0010\u00b5\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00b6\u0001\u001a\u00020-J\u0010\u0010\u00b7\u0001\u001a\u00020-2\u0007\u0010\u00b8\u0001\u001a\u00020QJ\u0012\u0010\u00b9\u0001\u001a\u00030\u0085\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0014\u0010\u00b9\u0001\u001a\u00030\u0085\u00012\n\u0010\u00ba\u0001\u001a\u0005\u0018\u00010\u00bb\u0001J\u0013\u0010\u00b9\u0001\u001a\u00030\u0085\u00012\t\u0010\u00bc\u0001\u001a\u0004\u0018\u00010vJ\u0013\u0010\u00b9\u0001\u001a\u00030\u0085\u00012\t\b\u0001\u0010\u00bd\u0001\u001a\u00020\tJ\u001a\u0010\u00be\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u001b2\u0007\u0010\u00bf\u0001\u001a\u00020-J\u0011\u0010\u00c0\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00c1\u0001\u001a\u00020\tJ\u0012\u0010\u00c2\u0001\u001a\u00030\u0085\u00012\b\u0010\u00c3\u0001\u001a\u00030\u00c4\u0001J#\u0010\u00c5\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00c6\u0001\u001a\u00020\u001b2\u0007\u0010\u0089\u0001\u001a\u00020\t2\u0007\u0010\u00c7\u0001\u001a\u00020\tJ\u0012\u0010\u00c8\u0001\u001a\u00030\u0085\u00012\b\u0010\u00c9\u0001\u001a\u00030\u00ca\u0001J\u0013\u0010\u00cb\u0001\u001a\u00030\u0085\u00012\t\b\u0001\u0010\u00cc\u0001\u001a\u00020\tJ\u0013\u0010\u00cd\u0001\u001a\u00030\u0085\u00012\t\u0010\u00bc\u0001\u001a\u0004\u0018\u00010vJ\u001f\u0010\u00cd\u0001\u001a\u00030\u0085\u00012\t\u0010\u00bc\u0001\u001a\u0004\u0018\u00010v2\n\u0010\u00ce\u0001\u001a\u0005\u0018\u00010\u00cf\u0001J\u001c\u0010\u00d0\u0001\u001a\u00030\u0085\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0004J\b\u0010\u00d1\u0001\u001a\u00030\u0085\u0001J\b\u0010\u00d2\u0001\u001a\u00030\u0085\u0001J\b\u0010\u00d3\u0001\u001a\u00030\u0085\u0001J\u0013\u0010\u00d3\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u00d4\u0001\u001a\u00020-H\u0004J\b\u0010\u00d5\u0001\u001a\u00030\u0085\u0001J\u0007\u0010\u00d6\u0001\u001a\u00020-R\u001e\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001f\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R$\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00103\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b3\u00100R\u001b\u00104\u001a\u0002058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b6\u00107R\u001a\u0010:\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00100\"\u0004\b<\u00102R\u001e\u0010=\u001a\u00060>R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010)\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020HX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u00100\"\u0004\bO\u00102R\u0011\u0010P\u001a\u00020Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020UX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010)\"\u0004\b\\\u0010FR\u001d\u0010]\u001a\u0004\u0018\u00010^8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\ba\u00109\u001a\u0004\b_\u0010`R\u001a\u0010b\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u00100\"\u0004\bd\u00102R\u001b\u0010e\u001a\u00020f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u00109\u001a\u0004\bg\u0010hR(\u0010k\u001a\u0004\u0018\u00010j2\b\u0010,\u001a\u0004\u0018\u00010j@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u001b\u0010p\u001a\u00020q8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u00109\u001a\u0004\br\u0010sR(\u0010w\u001a\u0004\u0018\u00010v2\b\u0010u\u001a\u0004\u0018\u00010v@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R$\u0010|\u001a\u00020Q2\u0006\u0010,\u001a\u00020Q8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b}\u0010S\"\u0004\b~\u0010\u007fR\u0017\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00018F\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\u00a8\u0006\u00da\u0001"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "audioFocusHelper", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "getAudioFocusHelper", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "setAudioFocusHelper", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;)V", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "()Landroid/media/AudioManager;", "setAudioManager", "(Landroid/media/AudioManager;)V", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Lcom/google/android/exoplayer2/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bitmap", "Landroid/graphics/Bitmap;", "getBitmap", "()Landroid/graphics/Bitmap;", "bufferPercentage", "getBufferPercentage", "()I", "currentPosition", "", "getCurrentPosition", "()J", "duration", "getDuration", "value", "", "handleAudioFocus", "getHandleAudioFocus", "()Z", "setHandleAudioFocus", "(Z)V", "isPlaying", "listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getListenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "listenerMux$delegate", "Lkotlin/Lazy;", "matchOverridePositionSpeed", "getMatchOverridePositionSpeed", "setMatchOverridePositionSpeed", "muxNotifier", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "getMuxNotifier", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "setMuxNotifier", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;)V", "overriddenDuration", "getOverriddenDuration", "setOverriddenDuration", "(J)V", "overriddenPositionStopWatch", "Lcom/devbrackets/android/exomedia/util/StopWatch;", "getOverriddenPositionStopWatch", "()Lcom/devbrackets/android/exomedia/util/StopWatch;", "setOverriddenPositionStopWatch", "(Lcom/devbrackets/android/exomedia/util/StopWatch;)V", "overridePosition", "getOverridePosition", "setOverridePosition", "playbackSpeed", "", "getPlaybackSpeed", "()F", "playerConfig", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "setPlayerConfig", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "positionOffset", "getPositionOffset", "setPositionOffset", "previewImageView", "Landroid/widget/ImageView;", "getPreviewImageView", "()Landroid/widget/ImageView;", "previewImageView$delegate", "releaseOnDetachFromWindow", "getReleaseOnDetachFromWindow", "setReleaseOnDetachFromWindow", "surface", "Landroid/view/View;", "getSurface", "()Landroid/view/View;", "surface$delegate", "Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "videoControls", "getVideoControls", "()Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;", "setVideoControls", "(Lcom/devbrackets/android/exomedia/ui/widget/controls/VideoControls;)V", "videoPlayer", "Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "getVideoPlayer", "()Lcom/devbrackets/android/exomedia/core/video/VideoPlayerApi;", "videoPlayer$delegate", "<set-?>", "Landroid/net/Uri;", "videoUri", "getVideoUri", "()Landroid/net/Uri;", "setVideoUri", "(Landroid/net/Uri;)V", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getApiImplementation", "getSelectedTrackIndex", "groupIndex", "initView", "attributes", "Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributes;", "isRendererEnabled", "onDetachedFromWindow", "onPlaybackEnded", "overrideDuration", "override", "pause", "transientFocusLoss", "postInit", "release", "reset", "restart", "restartOverridePosition", "seekTo", "milliSeconds", "setAnalyticsListener", "listener", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "setCaptionListener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setDrmSessionManagerProvider", "drmSessionManagerProvider", "Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "setId3MetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setMeasureBasedOnAspectRatioEnabled", "measureBasedOnAspectRatioEnabled", "setOnBufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "setOnCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnCompletionListener;", "setOnErrorListener", "Lcom/devbrackets/android/exomedia/listener/OnErrorListener;", "setOnPreparedListener", "Lcom/devbrackets/android/exomedia/listener/OnPreparedListener;", "setOnSeekCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnSeekCompletionListener;", "setOnTouchListener", "Landroid/view/View$OnTouchListener;", "setOnVideoSizedChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "setOverridePositionMatchesPlaybackSpeed", "match", "setPlaybackSpeed", "speed", "setPreviewImage", "drawable", "Landroid/graphics/drawable/Drawable;", "uri", "resourceId", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setScaleType", "scaleType", "Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "setTrack", "trackType", "trackIndex", "setVideoPath", "path", "", "setVideoRotation", "rotation", "setVideoURI", "mediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "setup", "showControls", "start", "stopPlayback", "clearSurface", "suspend", "trackSelectionAvailable", "AudioFocusHelper", "MuxNotifier", "TouchListener", "library_release"})
public class VideoView
extends RelativeLayout {
    @Nullable
    private final Lazy previewImageView$delegate;
    @NotNull
    private final Lazy surface$delegate;
    @NotNull
    private final Lazy videoPlayer$delegate;
    @Nullable
    private Uri videoUri;
    @Nullable
    private AudioManager audioManager;
    @NotNull
    private AudioFocusHelper audioFocusHelper;
    private long positionOffset;
    private long overriddenDuration;
    private boolean overridePosition;
    private boolean matchOverridePositionSpeed;
    @NotNull
    private StopWatch overriddenPositionStopWatch;
    @NotNull
    private MuxNotifier muxNotifier;
    @NotNull
    private final Lazy listenerMux$delegate;
    protected PlayerConfig playerConfig;
    private boolean releaseOnDetachFromWindow;
    private boolean handleAudioFocus;
    @Nullable
    private VideoControls videoControls;

    @Nullable
    public final ImageView getPreviewImageView() {
        Lazy lazy = this.previewImageView$delegate;
        VideoView videoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ImageView)lazy.getValue();
    }

    @NotNull
    protected final View getSurface() {
        Lazy lazy = this.surface$delegate;
        VideoView videoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (View)lazy.getValue();
    }

    @NotNull
    protected final VideoPlayerApi getVideoPlayer() {
        Lazy lazy = this.videoPlayer$delegate;
        VideoView videoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (VideoPlayerApi)lazy.getValue();
    }

    @Nullable
    public final Uri getVideoUri() {
        return this.videoUri;
    }

    protected final void setVideoUri(@Nullable Uri uri) {
        this.videoUri = uri;
    }

    @Nullable
    protected final AudioManager getAudioManager() {
        return this.audioManager;
    }

    protected final void setAudioManager(@Nullable AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    @NotNull
    protected final AudioFocusHelper getAudioFocusHelper() {
        return this.audioFocusHelper;
    }

    protected final void setAudioFocusHelper(@NotNull AudioFocusHelper audioFocusHelper) {
        Intrinsics.checkNotNullParameter((Object)audioFocusHelper, (String)"<set-?>");
        this.audioFocusHelper = audioFocusHelper;
    }

    public final long getPositionOffset() {
        return this.positionOffset;
    }

    public final void setPositionOffset(long l) {
        this.positionOffset = l;
    }

    protected final long getOverriddenDuration() {
        return this.overriddenDuration;
    }

    protected final void setOverriddenDuration(long l) {
        this.overriddenDuration = l;
    }

    protected final boolean getOverridePosition() {
        return this.overridePosition;
    }

    protected final void setOverridePosition(boolean bl) {
        this.overridePosition = bl;
    }

    protected final boolean getMatchOverridePositionSpeed() {
        return this.matchOverridePositionSpeed;
    }

    protected final void setMatchOverridePositionSpeed(boolean bl) {
        this.matchOverridePositionSpeed = bl;
    }

    @NotNull
    protected final StopWatch getOverriddenPositionStopWatch() {
        return this.overriddenPositionStopWatch;
    }

    protected final void setOverriddenPositionStopWatch(@NotNull StopWatch stopWatch) {
        Intrinsics.checkNotNullParameter((Object)stopWatch, (String)"<set-?>");
        this.overriddenPositionStopWatch = stopWatch;
    }

    @NotNull
    protected final MuxNotifier getMuxNotifier() {
        return this.muxNotifier;
    }

    protected final void setMuxNotifier(@NotNull MuxNotifier muxNotifier) {
        Intrinsics.checkNotNullParameter((Object)muxNotifier, (String)"<set-?>");
        this.muxNotifier = muxNotifier;
    }

    @NotNull
    protected final ListenerMux getListenerMux() {
        Lazy lazy = this.listenerMux$delegate;
        VideoView videoView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ListenerMux)lazy.getValue();
    }

    @NotNull
    protected final PlayerConfig getPlayerConfig() {
        PlayerConfig playerConfig = this.playerConfig;
        if (playerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playerConfig");
        }
        return playerConfig;
    }

    protected final void setPlayerConfig(@NotNull PlayerConfig playerConfig) {
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"<set-?>");
        this.playerConfig = playerConfig;
    }

    public final boolean getReleaseOnDetachFromWindow() {
        return this.releaseOnDetachFromWindow;
    }

    public final void setReleaseOnDetachFromWindow(boolean bl) {
        this.releaseOnDetachFromWindow = bl;
    }

    public final boolean getHandleAudioFocus() {
        return this.handleAudioFocus;
    }

    public final void setHandleAudioFocus(boolean value) {
        this.audioFocusHelper.abandonFocus();
        this.handleAudioFocus = value;
    }

    @Nullable
    public final VideoControls getVideoControls() {
        return this.videoControls;
    }

    public final void setVideoControls(@Nullable VideoControls value) {
        TouchListener touchListener;
        if (Intrinsics.areEqual((Object)this.videoControls, (Object)value) ^ true) {
            VideoControls videoControls = this.videoControls;
            if (videoControls != null) {
                videoControls.onDetachedFromView(this);
            }
        }
        VideoControls videoControls = this.videoControls = value;
        if (videoControls != null) {
            videoControls.onAttachedToView(this);
        }
        VideoView videoView = this;
        VideoControls videoControls2 = this.videoControls;
        if (videoControls2 != null) {
            VideoControls videoControls3 = videoControls2;
            boolean bl = false;
            boolean bl2 = false;
            VideoControls videoControls4 = videoControls3;
            VideoView videoView2 = videoView;
            boolean bl3 = false;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            TouchListener touchListener2 = new TouchListener(context);
            videoView = videoView2;
            touchListener = touchListener2;
        } else {
            touchListener = null;
        }
        videoView.setOnTouchListener(touchListener);
    }

    public final float getVolume() {
        return this.getVideoPlayer().getVolume();
    }

    public final void setVolume(float value) {
        this.getVideoPlayer().setVolume(value);
    }

    public final boolean isPlaying() {
        return this.getVideoPlayer().isPlaying();
    }

    public final long getDuration() {
        return this.overriddenDuration >= 0L ? this.overriddenDuration : this.getVideoPlayer().getDuration();
    }

    public final long getCurrentPosition() {
        return this.overridePosition ? this.positionOffset + this.overriddenPositionStopWatch.getTime() : this.positionOffset + this.getVideoPlayer().getCurrentPosition();
    }

    public final int getBufferPercentage() {
        return this.getVideoPlayer().getBufferedPercent();
    }

    @Nullable
    public final WindowInfo getWindowInfo() {
        return this.getVideoPlayer().getWindowInfo();
    }

    public final float getPlaybackSpeed() {
        return this.getVideoPlayer().getPlaybackSpeed();
    }

    @Nullable
    public final Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.getVideoPlayer().getAvailableTracks();
    }

    @Nullable
    public final Bitmap getBitmap() {
        VideoPlayerApi videoPlayerApi = this.getVideoPlayer();
        if (!(videoPlayerApi instanceof TextureView)) {
            videoPlayerApi = null;
        }
        TextureView textureView = (TextureView)videoPlayerApi;
        return textureView != null ? textureView.getBitmap() : null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode() && this.releaseOnDetachFromWindow) {
            this.release();
        }
    }

    public void setOnTouchListener(@Nullable View.OnTouchListener listener) {
        this.getSurface().setOnTouchListener(listener);
        super.setOnTouchListener(listener);
    }

    public final void release() {
        VideoControls videoControls = this.videoControls;
        if (videoControls != null) {
            videoControls.onDetachedFromView(this);
        }
        this.setVideoControls(null);
        this.stopPlayback();
        this.overriddenPositionStopWatch.stop();
        this.getVideoPlayer().release();
    }

    public final void setPreviewImage(@Nullable Drawable drawable2) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageDrawable(drawable2);
        }
    }

    public final void setPreviewImage(@DrawableRes int resourceId) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageResource(resourceId);
        }
    }

    public final void setPreviewImage(@Nullable Bitmap bitmap) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageBitmap(bitmap);
        }
    }

    public final void setPreviewImage(@Nullable Uri uri) {
        block0: {
            ImageView imageView = this.getPreviewImageView();
            if (imageView == null) break block0;
            imageView.setImageURI(uri);
        }
    }

    public final void showControls() {
        block2: {
            VideoControls videoControls = this.videoControls;
            if (videoControls != null) {
                videoControls.show();
            }
            if (!this.isPlaying()) break block2;
            VideoControls videoControls2 = this.videoControls;
            if (videoControls2 != null) {
                videoControls2.hide(true);
            }
        }
    }

    public final void setVideoURI(@Nullable Uri uri) {
        block0: {
            this.videoUri = uri;
            AudioPlayerApi.DefaultImpls.setMedia$default(this.getVideoPlayer(), uri, null, 2, null);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block0;
            videoControls.showLoading(true);
        }
    }

    public final void setVideoURI(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        block0: {
            this.videoUri = uri;
            this.getVideoPlayer().setMedia(uri, mediaSource);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block0;
            videoControls.showLoading(true);
        }
    }

    public final void setVideoPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.setVideoURI(Uri.parse((String)path));
    }

    public final void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.getVideoPlayer().setDrmSessionManagerProvider(drmSessionManagerProvider);
    }

    public final void reset() {
        this.stopPlayback();
        this.setVideoURI(null);
    }

    public final void seekTo(long milliSeconds) {
        VideoControls videoControls = this.videoControls;
        if (videoControls != null) {
            videoControls.showLoading(false);
        }
        this.getVideoPlayer().seekTo(milliSeconds);
    }

    public final void start() {
        block1: {
            if (!this.audioFocusHelper.requestFocus()) {
                return;
            }
            this.getVideoPlayer().start();
            this.setKeepScreenOn(true);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block1;
            videoControls.updatePlaybackState(true);
        }
    }

    @JvmOverloads
    public final void pause(boolean transientFocusLoss) {
        block1: {
            if (!transientFocusLoss) {
                this.audioFocusHelper.abandonFocus();
            }
            this.getVideoPlayer().pause();
            this.setKeepScreenOn(false);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block1;
            videoControls.updatePlaybackState(false);
        }
    }

    public static /* synthetic */ void pause$default(VideoView videoView, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pause");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        videoView.pause(bl);
    }

    @JvmOverloads
    public final void pause() {
        VideoView.pause$default(this, false, 1, null);
    }

    public final void stopPlayback() {
        this.stopPlayback(true);
    }

    public final boolean restart() {
        if (this.videoUri == null) {
            return false;
        }
        if (this.getVideoPlayer().restart()) {
            VideoControls videoControls = this.videoControls;
            if (videoControls != null) {
                videoControls.showLoading(true);
            }
            return true;
        }
        return false;
    }

    public final void suspend() {
        block0: {
            this.audioFocusHelper.abandonFocus();
            this.getVideoPlayer().release();
            this.setKeepScreenOn(false);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block0;
            videoControls.updatePlaybackState(false);
        }
    }

    public final void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public final void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public final void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public final void setOverridePositionMatchesPlaybackSpeed(boolean match) {
        if (match != this.matchOverridePositionSpeed) {
            this.matchOverridePositionSpeed = match;
            if (match) {
                this.overriddenPositionStopWatch.setSpeedMultiplier(this.getPlaybackSpeed());
            } else {
                this.overriddenPositionStopWatch.setSpeedMultiplier(1.0f);
            }
        }
    }

    public final void setRepeatMode(int repeatMode) {
        this.getVideoPlayer().setRepeatMode(repeatMode);
    }

    public final boolean setPlaybackSpeed(float speed) {
        boolean wasSet = this.getVideoPlayer().setPlaybackSpeed(speed);
        if (wasSet && this.matchOverridePositionSpeed) {
            this.overriddenPositionStopWatch.setSpeedMultiplier(speed);
        }
        return wasSet;
    }

    public final void setCaptionListener(@Nullable CaptionListener listener) {
        this.getVideoPlayer().setCaptionListener(listener);
    }

    public final boolean trackSelectionAvailable() {
        return this.getVideoPlayer().trackSelectionAvailable();
    }

    public final void setTrack(@NotNull RendererType trackType, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)trackType), (String)"trackType");
        this.getVideoPlayer().setSelectedTrack(trackType, groupIndex, trackIndex);
    }

    public final int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getVideoPlayer().getSelectedTrackIndex(type, groupIndex);
    }

    public final void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getVideoPlayer().clearSelectedTracks(type);
    }

    public final void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getVideoPlayer().setRendererEnabled(type, enabled);
    }

    public final boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.getVideoPlayer().isRendererEnabled(type);
    }

    public final void setScaleType(@NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        View view = this.getSurface();
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
        }
        ((VideoSurface)view).setScaleType(scaleType);
    }

    public final void setMeasureBasedOnAspectRatioEnabled(boolean measureBasedOnAspectRatioEnabled) {
        View view = this.getSurface();
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
        }
        ((VideoSurface)view).setMeasureBasedOnAspectRatioEnabled(measureBasedOnAspectRatioEnabled);
    }

    public final void setVideoRotation(@IntRange(from=0L, to=359L) int rotation) {
        View view = this.getSurface();
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
        }
        ((VideoSurface)view).setVideoRotation(rotation, true);
    }

    public final void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.getListenerMux().setOnPreparedListener(listener);
    }

    public final void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.getListenerMux().setOnCompletionListener(listener);
    }

    public final void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.getListenerMux().setOnBufferUpdateListener(listener);
    }

    public final void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.getListenerMux().setOnSeekCompletionListener(listener);
    }

    public final void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.getListenerMux().setOnErrorListener(listener);
    }

    public final void setId3MetadataListener(@Nullable MetadataListener listener) {
        this.getListenerMux().setMetadataListener(listener);
    }

    public final void setAnalyticsListener(@Nullable AnalyticsListener listener) {
        this.getListenerMux().setAnalyticsListener(listener);
    }

    public final void setOnVideoSizedChangedListener(@Nullable OnVideoSizeChangedListener listener) {
        this.muxNotifier.setVideoSizeChangedListener(listener);
    }

    protected final void setup(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isInEditMode()) {
            return;
        }
        VideoViewAttributes attributes = new VideoViewAttributeParser().parse(context, attrs);
        Object object = context.getApplicationContext().getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        this.playerConfig = attributes.getPlayerConfigProvider().getConfig(context);
        this.initView(context, attributes);
        this.postInit(attributes);
    }

    protected final void initView(@NotNull Context context, @NotNull VideoViewAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        View.inflate((Context)context, (int)R.layout.exomedia_video_view_layout, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.video_view_surface_stub);
        boolean bl = false;
        boolean bl2 = false;
        ViewStub $this$apply = (ViewStub)view;
        boolean bl3 = false;
        $this$apply.setLayoutResource(attributes.getUseTextureViewBacking() ? R.layout.exomedia_resizing_texture_view : R.layout.exomedia_resizing_surface_view);
        $this$apply.inflate();
        this.getVideoPlayer().setListenerMux(this.getListenerMux());
    }

    protected final void postInit(@NotNull VideoViewAttributes attributes) {
        block4: {
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            if (attributes.getUseDefaultControls()) {
                VideoControls videoControls;
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                if (ContextExtensionsKt.isDeviceTV(context)) {
                    Context context2 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                    videoControls = new VideoControlsLeanback(context2);
                } else {
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                    videoControls = new VideoControlsMobile(context3);
                }
                this.setVideoControls(videoControls);
            }
            ScaleType scaleType = attributes.getScaleType();
            if (scaleType != null) {
                object = scaleType;
                bl2 = false;
                bl = false;
                ScaleType it = object;
                boolean bl3 = false;
                this.setScaleType(it);
            }
            Boolean bl4 = attributes.getMeasureBasedOnAspectRatio();
            if (bl4 == null) break block4;
            object = bl4;
            bl2 = false;
            bl = false;
            boolean it = (Boolean)object;
            boolean bl5 = false;
            this.setMeasureBasedOnAspectRatioEnabled(it);
        }
    }

    @NotNull
    public final VideoPlayerApi getApiImplementation() {
        VideoPlayerApi videoPlayerApi;
        if (!(this.getSurface() instanceof VideoSurface)) {
            throw (Throwable)new IllegalArgumentException("Provided surface must extend ClearableSurface");
        }
        View view = this.getSurface();
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
        }
        VideoSurface videoSurface = (VideoSurface)view;
        PlayerConfig playerConfig = this.playerConfig;
        if (playerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playerConfig");
        }
        if (playerConfig.getFallbackManager().useFallback()) {
            PlayerConfig playerConfig2 = this.playerConfig;
            if (playerConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerConfig");
            }
            FallbackManager fallbackManager = playerConfig2.getFallbackManager();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            videoPlayerApi = fallbackManager.getFallbackVideoPlayer(context, videoSurface);
        } else {
            PlayerConfig playerConfig3 = this.playerConfig;
            if (playerConfig3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playerConfig");
            }
            videoPlayerApi = new ExoVideoPlayer(playerConfig3, videoSurface);
        }
        return videoPlayerApi;
    }

    protected final void onPlaybackEnded() {
        this.stopPlayback(false);
    }

    protected final void stopPlayback(boolean clearSurface) {
        block0: {
            this.audioFocusHelper.abandonFocus();
            this.getVideoPlayer().stop(clearSurface);
            this.setKeepScreenOn(false);
            VideoControls videoControls = this.videoControls;
            if (videoControls == null) break block0;
            videoControls.updatePlaybackState(false);
        }
    }

    public VideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageView>(this){
            final /* synthetic */ VideoView this$0;

            public final ImageView invoke() {
                return (ImageView)this.this$0.findViewById(R.id.exomedia_video_preview_image);
            }
            {
                this.this$0 = videoView;
                super(0);
            }
        }));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ VideoView this$0;

            public final View invoke() {
                return this.this$0.findViewById(R.id.exomedia_surface_view);
            }
            {
                this.this$0 = videoView;
                super(0);
            }
        }));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoPlayerApi>(this){
            final /* synthetic */ VideoView this$0;

            @NotNull
            public final VideoPlayerApi invoke() {
                return this.this$0.getApiImplementation();
            }
            {
                this.this$0 = videoView;
                super(0);
            }
        }));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ListenerMux>(this){
            final /* synthetic */ VideoView this$0;

            @NotNull
            public final ListenerMux invoke() {
                return new ListenerMux(this.this$0.getMuxNotifier());
            }
            {
                this.this$0 = videoView;
                super(0);
            }
        }));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, null);
    }

    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    @TargetApi(value=11)
    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public VideoView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.previewImageView$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.surface$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.videoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.audioFocusHelper = new AudioFocusHelper();
        this.overriddenDuration = -1L;
        this.matchOverridePositionSpeed = true;
        this.overriddenPositionStopWatch = new StopWatch(false, 1, null);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.releaseOnDetachFromWindow = true;
        this.handleAudioFocus = true;
        this.setup(context, attrs);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0010J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u0006\u0010\u001c\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView$AudioFocusHelper;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "currentFocus", "", "getCurrentFocus", "()I", "setCurrentFocus", "(I)V", "lastFocusRequest", "Landroid/media/AudioFocusRequest;", "getLastFocusRequest", "()Landroid/media/AudioFocusRequest;", "setLastFocusRequest", "(Landroid/media/AudioFocusRequest;)V", "pausedForLoss", "", "getPausedForLoss", "()Z", "setPausedForLoss", "(Z)V", "startRequested", "getStartRequested", "setStartRequested", "abandonFocus", "onAudioFocusChange", "", "focusChange", "requestFocus", "library_release"})
    protected final class AudioFocusHelper
    implements AudioManager.OnAudioFocusChangeListener {
        private boolean startRequested;
        private boolean pausedForLoss;
        private int currentFocus;
        @TargetApi(value=26)
        @Nullable
        private AudioFocusRequest lastFocusRequest;

        protected final boolean getStartRequested() {
            return this.startRequested;
        }

        protected final void setStartRequested(boolean bl) {
            this.startRequested = bl;
        }

        protected final boolean getPausedForLoss() {
            return this.pausedForLoss;
        }

        protected final void setPausedForLoss(boolean bl) {
            this.pausedForLoss = bl;
        }

        protected final int getCurrentFocus() {
            return this.currentFocus;
        }

        protected final void setCurrentFocus(int n) {
            this.currentFocus = n;
        }

        @Nullable
        protected final AudioFocusRequest getLastFocusRequest() {
            return this.lastFocusRequest;
        }

        protected final void setLastFocusRequest(@Nullable AudioFocusRequest audioFocusRequest) {
            this.lastFocusRequest = audioFocusRequest;
        }

        public void onAudioFocusChange(int focusChange) {
            if (!VideoView.this.getHandleAudioFocus() || this.currentFocus == focusChange) {
                return;
            }
            this.currentFocus = focusChange;
            switch (focusChange) {
                case 1: 
                case 2: {
                    if (!this.startRequested && !this.pausedForLoss) break;
                    VideoView.this.start();
                    this.startRequested = false;
                    this.pausedForLoss = false;
                    break;
                }
                case -1: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.pause$default(VideoView.this, false, 1, null);
                    break;
                }
                case -3: 
                case -2: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.this.pause(true);
                    break;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean requestFocus() {
            if (!VideoView.this.getHandleAudioFocus() || this.currentFocus == 1) {
                return true;
            }
            if (VideoView.this.getAudioManager() == null) {
                return false;
            }
            int status = 0;
            if (Build.VERSION.SDK_INT >= 26) {
                void it;
                AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).build();
                AudioFocusRequest audioFocusRequest = new AudioFocusRequest.Builder(1).setAudioAttributes(attributes).build();
                boolean bl = false;
                boolean bl2 = false;
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                AudioFocusHelper audioFocusHelper = this;
                boolean bl3 = false;
                AudioManager audioManager = VideoView.this.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.requestAudioFocus((AudioFocusRequest)it);
                Unit unit = Unit.INSTANCE;
                audioFocusHelper.lastFocusRequest = audioFocusRequest;
            } else {
                AudioManager audioManager = VideoView.this.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
            }
            if (1 == status) {
                this.currentFocus = 1;
                return true;
            }
            this.startRequested = true;
            return false;
        }

        public final boolean abandonFocus() {
            if (!VideoView.this.getHandleAudioFocus()) {
                return true;
            }
            if (VideoView.this.getAudioManager() == null) {
                return false;
            }
            this.startRequested = false;
            int status = 0;
            if (Build.VERSION.SDK_INT >= 26) {
                int n;
                AudioFocusRequest audioFocusRequest = this.lastFocusRequest;
                if (audioFocusRequest != null) {
                    AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                    boolean bl = false;
                    boolean bl2 = false;
                    AudioFocusRequest request = audioFocusRequest2;
                    boolean bl3 = false;
                    AudioManager audioManager = VideoView.this.getAudioManager();
                    Intrinsics.checkNotNull((Object)audioManager);
                    int n2 = audioManager.abandonAudioFocusRequest(request);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int it = n2;
                    boolean bl6 = false;
                    if (1 == it) {
                        this.lastFocusRequest = null;
                    }
                    n = n2;
                } else {
                    n = 1;
                }
                status = n;
            } else {
                AudioManager audioManager = VideoView.this.getAudioManager();
                Intrinsics.checkNotNull((Object)audioManager);
                status = audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            }
            return 1 == status;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J(\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView$MuxNotifier;", "Lcom/devbrackets/android/exomedia/core/ListenerMux$Notifier;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;)V", "videoSizeChangedListener", "Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "getVideoSizeChangedListener", "()Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;", "setVideoSizeChangedListener", "(Lcom/devbrackets/android/exomedia/listener/OnVideoSizeChangedListener;)V", "onExoPlayerError", "", "exoMediaPlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMediaPlaybackEnded", "onPrepared", "onPreviewImageStateChanged", "toVisible", "", "onSeekComplete", "onVideoSizeChanged", "width", "", "height", "unAppliedRotationDegrees", "pixelWidthHeightRatio", "", "shouldNotifyCompletion", "endLeeway", "", "library_release"})
    protected final class MuxNotifier
    extends ListenerMux.Notifier {
        @Nullable
        private OnVideoSizeChangedListener videoSizeChangedListener;

        @Nullable
        public final OnVideoSizeChangedListener getVideoSizeChangedListener() {
            return this.videoSizeChangedListener;
        }

        public final void setVideoSizeChangedListener(@Nullable OnVideoSizeChangedListener onVideoSizeChangedListener) {
            this.videoSizeChangedListener = onVideoSizeChangedListener;
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            long position = VideoView.this.getCurrentPosition();
            long duration = VideoView.this.getDuration();
            return position > 0L && duration > 0L && position + endLeeway >= duration;
        }

        @Override
        public void onExoPlayerError(@NotNull ExoMediaPlayer exoMediaPlayer, @Nullable Exception e) {
            Intrinsics.checkNotNullParameter((Object)exoMediaPlayer, (String)"exoMediaPlayer");
            VideoView.this.stopPlayback();
            exoMediaPlayer.forcePrepare();
        }

        @Override
        public void onMediaPlaybackEnded() {
            VideoView.this.setKeepScreenOn(false);
            VideoView.this.onPlaybackEnded();
        }

        @Override
        public void onSeekComplete() {
            block0: {
                VideoControls videoControls = VideoView.this.getVideoControls();
                if (videoControls == null) break block0;
                videoControls.finishLoading();
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
            block2: {
                View view = VideoView.this.getSurface();
                if (view == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
                }
                ((VideoSurface)view).setVideoRotation(unAppliedRotationDegrees, false);
                View view2 = VideoView.this.getSurface();
                if (view2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.devbrackets.android.exomedia.core.video.surface.VideoSurface");
                }
                ((VideoSurface)view2).onVideoSizeChanged(width, height, pixelWidthHeightRatio);
                OnVideoSizeChangedListener onVideoSizeChangedListener = this.videoSizeChangedListener;
                if (onVideoSizeChangedListener == null) break block2;
                onVideoSizeChangedListener.onVideoSizeChanged(width, height, pixelWidthHeightRatio);
            }
        }

        @Override
        public void onPrepared() {
            block1: {
                VideoControls videoControls = VideoView.this.getVideoControls();
                if (videoControls != null) {
                    videoControls.setDuration(VideoView.this.getDuration());
                }
                VideoControls videoControls2 = VideoView.this.getVideoControls();
                if (videoControls2 == null) break block1;
                videoControls2.finishLoading();
            }
        }

        @Override
        public void onPreviewImageStateChanged(boolean toVisible) {
            block0: {
                ImageView imageView = VideoView.this.getPreviewImageView();
                if (imageView == null) break block0;
                imageView.setVisibility(toVisible ? 0 : 8);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/VideoView$TouchListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "Landroid/view/View$OnTouchListener;", "context", "Landroid/content/Context;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;Landroid/content/Context;)V", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "gestureDetector$delegate", "Lkotlin/Lazy;", "onSingleTapConfirmed", "", "event", "Landroid/view/MotionEvent;", "onTouch", "view", "Landroid/view/View;", "library_release"})
    protected final class TouchListener
    extends GestureDetector.SimpleOnGestureListener
    implements View.OnTouchListener {
        @NotNull
        private final Lazy gestureDetector$delegate;

        @NotNull
        protected final GestureDetector getGestureDetector() {
            Lazy lazy = this.gestureDetector$delegate;
            TouchListener touchListener = this;
            Object var3_3 = null;
            boolean bl = false;
            return (GestureDetector)lazy.getValue();
        }

        public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getGestureDetector().onTouchEvent(event);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean onSingleTapConfirmed(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VideoControls videoControls = VideoView.this.getVideoControls();
            if (videoControls != null) {
                if (videoControls.isVisible()) {
                    VideoControls videoControls2 = VideoView.this.getVideoControls();
                    if (videoControls2 == null) return true;
                    videoControls2.hide(false);
                    return true;
                }
            }
            VideoView.this.showControls();
            return true;
        }

        public TouchListener(Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.gestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(this, context){
                final /* synthetic */ TouchListener this$0;
                final /* synthetic */ Context $context;

                @NotNull
                public final GestureDetector invoke() {
                    return new GestureDetector(this.$context, (GestureDetector.OnGestureListener)this.this$0);
                }
                {
                    this.this$0 = touchListener;
                    this.$context = context;
                    super(0);
                }
            }));
        }
    }
}

