/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp.config;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.devbrackets.android.exomedia.core.renderer.RenderProvider;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.renderer.audio.AudioRenderProvider;
import com.devbrackets.android.exomedia.core.renderer.audio.DefaultAudioRenderListener;
import com.devbrackets.android.exomedia.core.renderer.caption.CaptionRenderProvider;
import com.devbrackets.android.exomedia.core.renderer.caption.DefaultCaptionRenderListener;
import com.devbrackets.android.exomedia.core.renderer.metadata.DefaultMetadataRenderListener;
import com.devbrackets.android.exomedia.core.renderer.metadata.MetadataRenderProvider;
import com.devbrackets.android.exomedia.core.renderer.video.DefaultVideoRenderListener;
import com.devbrackets.android.exomedia.core.renderer.video.VideoRenderProvider;
import com.devbrackets.android.exomedia.core.source.MediaSourceProvider;
import com.devbrackets.android.exomedia.core.source.data.DataSourceFactoryProvider;
import com.devbrackets.android.exomedia.core.source.data.DefaultDataSourceFactoryProvider;
import com.devbrackets.android.exomedia.nmp.CorePlayerListeners;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.UserAgentProvider;
import com.devbrackets.android.exomedia.nmp.manager.WakeManager;
import com.devbrackets.android.exomedia.nmp.manager.track.TrackManager;
import com.devbrackets.android.exomedia.util.FallbackManager;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Clock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0012J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0014J\u001a\u0010,\u001a\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001cJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfigBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "analyticsCollector", "Lcom/google/android/exoplayer2/analytics/AnalyticsCollector;", "bandwidthMeter", "Lcom/google/android/exoplayer2/upstream/BandwidthMeter;", "dataSourceFactoryProvider", "Lcom/devbrackets/android/exomedia/core/source/data/DataSourceFactoryProvider;", "fallbackManager", "Lcom/devbrackets/android/exomedia/util/FallbackManager;", "handler", "Landroid/os/Handler;", "loadControl", "Lcom/google/android/exoplayer2/LoadControl;", "mediaSourceFactory", "Lcom/google/android/exoplayer2/source/MediaSourceFactory;", "mediaSourceProvider", "Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider;", "renderProviders", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Lcom/devbrackets/android/exomedia/core/renderer/RenderProvider;", "trackManager", "Lcom/devbrackets/android/exomedia/nmp/manager/track/TrackManager;", "userAgentProvider", "Lcom/devbrackets/android/exomedia/nmp/manager/UserAgentProvider;", "wakeManager", "Lcom/devbrackets/android/exomedia/nmp/manager/WakeManager;", "build", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "setAnalyticsCollector", "setBandwidthMeter", "setDataSourceFactoryProvider", "provider", "setFallbackManager", "manager", "setHandler", "setLoadControl", "setMediaSourceFactory", "factory", "setMediaSourceProvider", "setRenderProviders", "setTrackManager", "setUserAgentProvider", "setWakeManager", "library_release"})
public final class PlayerConfigBuilder {
    private AnalyticsCollector analyticsCollector;
    private BandwidthMeter bandwidthMeter;
    private Handler handler;
    private Map<RendererType, ? extends RenderProvider> renderProviders;
    private TrackManager trackManager;
    private WakeManager wakeManager;
    private LoadControl loadControl;
    private UserAgentProvider userAgentProvider;
    private MediaSourceProvider mediaSourceProvider;
    private MediaSourceFactory mediaSourceFactory;
    private DataSourceFactoryProvider dataSourceFactoryProvider;
    private FallbackManager fallbackManager;
    private final Context context;

    @NotNull
    public final PlayerConfigBuilder setAnalyticsCollector(@NotNull AnalyticsCollector analyticsCollector) {
        Intrinsics.checkNotNullParameter((Object)analyticsCollector, (String)"analyticsCollector");
        this.analyticsCollector = analyticsCollector;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setBandwidthMeter(@NotNull BandwidthMeter bandwidthMeter) {
        Intrinsics.checkNotNullParameter((Object)bandwidthMeter, (String)"bandwidthMeter");
        this.bandwidthMeter = bandwidthMeter;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setRenderProviders(@NotNull Map<RendererType, ? extends RenderProvider> renderProviders) {
        Intrinsics.checkNotNullParameter(renderProviders, (String)"renderProviders");
        this.renderProviders = renderProviders;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setTrackManager(@NotNull TrackManager trackManager) {
        Intrinsics.checkNotNullParameter((Object)trackManager, (String)"trackManager");
        this.trackManager = trackManager;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setWakeManager(@NotNull WakeManager wakeManager) {
        Intrinsics.checkNotNullParameter((Object)wakeManager, (String)"wakeManager");
        this.wakeManager = wakeManager;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setLoadControl(@NotNull LoadControl loadControl) {
        Intrinsics.checkNotNullParameter((Object)loadControl, (String)"loadControl");
        this.loadControl = loadControl;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setUserAgentProvider(@NotNull UserAgentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.userAgentProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setMediaSourceProvider(@NotNull MediaSourceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.mediaSourceProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setMediaSourceFactory(@NotNull MediaSourceFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.mediaSourceFactory = factory;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setDataSourceFactoryProvider(@NotNull DataSourceFactoryProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.dataSourceFactoryProvider = provider;
        return this;
    }

    @NotNull
    public final PlayerConfigBuilder setFallbackManager(@NotNull FallbackManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.fallbackManager = manager;
        return this;
    }

    @NotNull
    public final PlayerConfig build() {
        DataSourceFactoryProvider dataSourceFactoryProvider;
        MediaSourceFactory mediaSourceFactory;
        MediaSourceProvider mediaSourceProvider;
        UserAgentProvider userAgentProvider;
        LoadControl loadControl;
        WakeManager wakeManager;
        TrackManager trackManager;
        BandwidthMeter bandwidthMeter;
        FallbackManager fallbackManager;
        Map providers;
        AnalyticsCollector analyticsCollector;
        Handler actualHandler;
        Handler handler = this.handler;
        if (handler == null) {
            handler = actualHandler = new Handler(Looper.getMainLooper());
        }
        if ((analyticsCollector = this.analyticsCollector) == null) {
            analyticsCollector = new AnalyticsCollector(Clock.DEFAULT);
        }
        AnalyticsCollector actualAnalyticsCollector = analyticsCollector;
        CorePlayerListeners coreListener = new CorePlayerListeners(null, null, null, 7, null);
        Map map = this.renderProviders;
        if (map == null) {
            map = providers = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)RendererType.AUDIO), (Object)new AudioRenderProvider(this.context, actualHandler, new DefaultAudioRenderListener(actualAnalyticsCollector))), TuplesKt.to((Object)((Object)RendererType.VIDEO), (Object)new VideoRenderProvider(this.context, actualHandler, new DefaultVideoRenderListener(coreListener, actualAnalyticsCollector), 0, 0L, 24, null)), TuplesKt.to((Object)((Object)RendererType.CLOSED_CAPTION), (Object)new CaptionRenderProvider(actualHandler, new DefaultCaptionRenderListener(coreListener))), TuplesKt.to((Object)((Object)RendererType.METADATA), (Object)new MetadataRenderProvider(actualHandler, new DefaultMetadataRenderListener(coreListener, actualAnalyticsCollector)))});
        }
        if ((fallbackManager = this.fallbackManager) == null) {
            fallbackManager = new FallbackManager();
        }
        if ((bandwidthMeter = this.bandwidthMeter) == null) {
            DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter.Builder(this.context).build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultBandwidthMeter, (String)"DefaultBandwidthMeter.Builder(context).build()");
            bandwidthMeter = (BandwidthMeter)defaultBandwidthMeter;
        }
        if ((trackManager = this.trackManager) == null) {
            trackManager = new TrackManager(this.context);
        }
        if ((wakeManager = this.wakeManager) == null) {
            wakeManager = new WakeManager(this.context);
        }
        if ((loadControl = this.loadControl) == null) {
            loadControl = (LoadControl)new DefaultLoadControl();
        }
        if ((userAgentProvider = this.userAgentProvider) == null) {
            userAgentProvider = new UserAgentProvider();
        }
        if ((mediaSourceProvider = this.mediaSourceProvider) == null) {
            mediaSourceProvider = new MediaSourceProvider();
        }
        if ((mediaSourceFactory = this.mediaSourceFactory) == null) {
            mediaSourceFactory = (MediaSourceFactory)new DefaultMediaSourceFactory(this.context);
        }
        if ((dataSourceFactoryProvider = this.dataSourceFactoryProvider) == null) {
            dataSourceFactoryProvider = new DefaultDataSourceFactoryProvider();
        }
        return new PlayerConfig(this.context, coreListener, fallbackManager, actualAnalyticsCollector, bandwidthMeter, actualHandler, providers, trackManager, wakeManager, loadControl, userAgentProvider, mediaSourceProvider, mediaSourceFactory, dataSourceFactoryProvider);
    }

    public PlayerConfigBuilder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

