/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp;

import android.net.Uri;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.FloatRange;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.listener.VideoSizeListener;
import com.devbrackets.android.exomedia.core.renderer.RenderProvider;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.core.source.builder.MediaSourceBuilder;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.StateStore;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0095\u00012\u00020\u00012\u00020\u0002:\u0002\u0095\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020^2\u0006\u0010_\u001a\u00020-H\u0016J\u0010\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020\fH\u0016J\b\u0010d\u001a\u00020^H\u0016J\b\u0010e\u001a\u00020^H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010f\u001a\u000201H\u0016J\u0018\u0010g\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\f2\u0006\u0010h\u001a\u00020\u0007H\u0016J\u0010\u0010i\u001a\u0002012\u0006\u0010c\u001a\u00020\fH\u0016J\u0010\u0010j\u001a\u00020^2\u0006\u0010k\u001a\u00020lH\u0016J\u0018\u0010m\u001a\u00020^2\u0006\u00100\u001a\u0002012\u0006\u0010n\u001a\u00020\u0007H\u0016J\b\u0010o\u001a\u00020^H\u0016J\b\u0010p\u001a\u00020^H\u0016J\b\u0010q\u001a\u00020^H\u0016J\u0010\u0010r\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010s\u001a\u00020^2\u0006\u0010_\u001a\u00020-H\u0016J\b\u0010t\u001a\u00020^H\u0002J\b\u0010u\u001a\u000201H\u0016J\u0010\u0010v\u001a\u00020^2\u0006\u0010w\u001a\u00020\u001bH\u0016J\u0018\u0010v\u001a\u00020^2\u0006\u0010w\u001a\u00020\u001b2\u0006\u0010f\u001a\u000201H\u0016J\"\u0010x\u001a\u00020^2\u0006\u0010y\u001a\u00020\u00072\u0006\u0010z\u001a\u00020\u00072\b\u0010{\u001a\u0004\u0018\u00010|H\u0004J\u0010\u0010}\u001a\u00020^2\u0006\u0010~\u001a\u00020\u0007H\u0016J\u0012\u0010\u007f\u001a\u00020^2\b\u0010_\u001a\u0004\u0018\u00010\u0017H\u0016J\u0014\u0010\u0080\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u0081\u0001H\u0016J\u0014\u0010\u0082\u0001\u001a\u00020^2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010/H\u0016J\u0015\u0010\u0084\u0001\u001a\u00020^2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0016J\u0014\u0010\u0087\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u0088\u0001H\u0016J\u001a\u0010\u0089\u0001\u001a\u00020^2\u0006\u0010c\u001a\u00020\f2\u0007\u0010\u008a\u0001\u001a\u000201H\u0016J\u0012\u0010\u008b\u0001\u001a\u00020^2\u0007\u0010\u008c\u0001\u001a\u00020\u0007H\u0016J\"\u0010\u008d\u0001\u001a\u00020^2\u0006\u0010c\u001a\u00020\f2\u0006\u0010h\u001a\u00020\u00072\u0007\u0010\u008e\u0001\u001a\u00020\u0007H\u0016J\u0014\u0010\u008f\u0001\u001a\u00020^2\t\u0010_\u001a\u0005\u0018\u00010\u0090\u0001H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020^2\u0007\u0010\u0092\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u0093\u0001\u001a\u00020^H\u0016J\t\u0010\u0094\u0001\u001a\u00020^H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0015\u001a\u0004\b(\u0010)R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u0002012\u0006\u00100\u001a\u0002018V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00108\u001a\u0002072\u0006\u00106\u001a\u0002078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R$\u0010=\u001a\u0002072\u0006\u00106\u001a\u0002078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010:\"\u0004\b?\u0010<R\u0014\u0010@\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\tR\u0014\u0010B\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u00103R\u000e\u0010D\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u0015\u001a\u0004\bH\u0010IR\u0012\u0010K\u001a\u0002078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010Q\u001a\u0004\u0018\u00010P2\b\u00106\u001a\u0004\u0018\u00010P@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR$\u0010V\u001a\u0002072\u0006\u0010V\u001a\u0002078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bW\u0010:\"\u0004\bX\u0010<R\u0016\u0010Y\u001a\u0004\u0018\u00010Z8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\\u00a8\u0006\u0096\u0001"}, d2={"Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "Lcom/google/android/exoplayer2/Player$EventListener;", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Lcom/google/android/exoplayer2/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferTimer", "Ljava/util/Timer;", "getBufferTimer", "()Ljava/util/Timer;", "bufferTimer$delegate", "Lkotlin/Lazy;", "bufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "bufferedPercent", "getBufferedPercent", "currentPosition", "", "getCurrentPosition", "()J", "drmSessionManagerProvider", "Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "getDrmSessionManagerProvider", "()Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "exoPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "getExoPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "exoPlayer$delegate", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/devbrackets/android/exomedia/core/listener/ExoPlayerListener;", "mediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "playWhenReady", "", "getPlayWhenReady", "()Z", "setPlayWhenReady", "(Z)V", "value", "", "playbackPitch", "getPlaybackPitch", "()F", "setPlaybackPitch", "(F)V", "playbackSpeed", "getPlaybackSpeed", "setPlaybackSpeed", "playbackState", "getPlaybackState", "playing", "getPlaying", "prepared", "renderers", "", "Lcom/google/android/exoplayer2/Renderer;", "getRenderers", "()Ljava/util/List;", "renderers$delegate", "requestedVolume", "stateStore", "Lcom/devbrackets/android/exomedia/nmp/manager/StateStore;", "stopped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Landroid/view/Surface;", "surface", "getSurface", "()Landroid/view/Surface;", "setSurface", "(Landroid/view/Surface;)V", "volume", "getVolume", "setVolume", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "addAnalyticsListener", "", "listener", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "addListener", "clearSelectedTracks", "type", "clearSurface", "forcePrepare", "limitToCurrentWindow", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onPlayerError", "error", "Lcom/google/android/exoplayer2/ExoPlaybackException;", "onPlayerStateChanged", "state", "pause", "prepare", "release", "removeAnalyticsListener", "removeListener", "reportPlayerState", "restart", "seekTo", "positionMs", "sendMessage", "renderType", "messageType", "message", "", "setAudioStreamType", "streamType", "setBufferUpdateListener", "setCaptionListener", "Lcom/devbrackets/android/exomedia/core/listener/CaptionListener;", "setMediaSource", "source", "setMediaUri", "uri", "Landroid/net/Uri;", "setMetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setVideoSizeListener", "Lcom/devbrackets/android/exomedia/core/listener/VideoSizeListener;", "setWakeLevel", "levelAndFlags", "start", "stop", "Companion", "library_release"})
public final class ExoMediaPlayerImpl
implements Player.EventListener,
ExoMediaPlayer {
    private final Lazy exoPlayer$delegate;
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners;
    private final AtomicBoolean stopped;
    private boolean prepared;
    private final StateStore stateStore;
    private final Lazy bufferTimer$delegate;
    @Nullable
    private Surface surface;
    private MediaSource mediaSource;
    private OnBufferUpdateListener bufferUpdateListener;
    @FloatRange(from=0.0, to=1.0)
    private float requestedVolume;
    @Nullable
    private DrmSessionManagerProvider drmSessionManagerProvider;
    private final Lazy renderers$delegate;
    private final PlayerConfig config;
    private static final String TAG = "ExoMediaPlayer";
    private static final long BUFFER_REPEAT_DELAY = 1000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final ExoPlayer getExoPlayer() {
        Lazy lazy = this.exoPlayer$delegate;
        ExoMediaPlayerImpl exoMediaPlayerImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ExoPlayer)lazy.getValue();
    }

    private final Timer getBufferTimer() {
        Lazy lazy = this.bufferTimer$delegate;
        ExoMediaPlayerImpl exoMediaPlayerImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Timer)lazy.getValue();
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    @Override
    public void setSurface(@Nullable Surface value) {
        this.surface = value;
        this.sendMessage(2, 1, this.getSurface());
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.config.getTrackManager().getAvailableTracks();
    }

    @Override
    public float getVolume() {
        return this.requestedVolume;
    }

    @Override
    public void setVolume(float volume) {
        this.requestedVolume = RangesKt.coerceIn((float)volume, (float)0.0f, (float)1.0f);
        this.sendMessage(1, 2, Float.valueOf(this.requestedVolume));
    }

    @Override
    public int getPlaybackState() {
        return this.getExoPlayer().getPlaybackState();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.getExoPlayer().getPlaybackParameters().speed;
    }

    @Override
    public void setPlaybackSpeed(float value) {
        this.getExoPlayer().setPlaybackParameters(new PlaybackParameters(value, this.getExoPlayer().getPlaybackParameters().pitch));
    }

    @Override
    public float getPlaybackPitch() {
        return this.getExoPlayer().getPlaybackParameters().pitch;
    }

    @Override
    public void setPlaybackPitch(float value) {
        this.getExoPlayer().setPlaybackParameters(new PlaybackParameters(this.getExoPlayer().getPlaybackParameters().speed, value));
    }

    @Override
    public long getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    @Override
    public long getDuration() {
        return this.getExoPlayer().getDuration();
    }

    @Override
    public int getBufferedPercent() {
        return this.getExoPlayer().getBufferedPercentage();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.drmSessionManagerProvider;
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.drmSessionManagerProvider = drmSessionManagerProvider;
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        Timeline timeline = this.getExoPlayer().getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"exoPlayer.currentTimeline");
        Timeline timeline2 = timeline;
        if (timeline2.isEmpty()) {
            return null;
        }
        int currentWindowIndex = this.getExoPlayer().getCurrentWindowIndex();
        Timeline.Window window = timeline2.getWindow(currentWindowIndex, new Timeline.Window());
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"timeline.getWindow(curre\u2026Index, Timeline.Window())");
        Timeline.Window currentWindow = window;
        return new WindowInfo(this.getExoPlayer().getPreviousWindowIndex(), currentWindowIndex, this.getExoPlayer().getNextWindowIndex(), currentWindow);
    }

    @Override
    public int getAudioSessionId() {
        String string = "The DefaultAudioRenderListener keeps track of the audioSessionId";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean getPlaying() {
        return this.getExoPlayer().isPlaying();
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.getExoPlayer().getPlayWhenReady();
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.getExoPlayer().setPlayWhenReady(playWhenReady);
        this.config.getWakeManager().stayAwake(playWhenReady);
    }

    private final List<Renderer> getRenderers() {
        Lazy lazy = this.renderers$delegate;
        ExoMediaPlayerImpl exoMediaPlayerImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.reportPlayerState();
    }

    public void onPlayerError(@NotNull ExoPlaybackException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExoPlayerListener it = (ExoPlayerListener)element$iv;
            boolean bl = false;
            it.onError(this, (Exception)error);
        }
    }

    @Override
    public void setMediaUri(@Nullable Uri uri) {
        MediaSource mediaSource;
        Uri uri2 = uri;
        if (uri2 != null) {
            Uri uri3 = uri2;
            boolean bl = false;
            boolean bl2 = false;
            Uri it = uri3;
            boolean bl3 = false;
            MediaSourceBuilder.MediaSourceAttributes attributes = new MediaSourceBuilder.MediaSourceAttributes(this.config.getContext(), it, this.config.getHandler(), this.config.getUserAgentProvider().getUserAgent(), this.config.getBandwidthMeter().getTransferListener(), this.getDrmSessionManagerProvider(), null, 64, null);
            mediaSource = this.config.getMediaSourceProvider().generate(attributes);
        } else {
            mediaSource = null;
        }
        MediaSource mediaSource2 = mediaSource;
        this.setMediaSource(mediaSource2);
    }

    @Override
    public void setMediaSource(@Nullable MediaSource source) {
        MediaSource mediaSource = this.mediaSource;
        if (mediaSource != null) {
            MediaSource mediaSource2 = mediaSource;
            boolean bl = false;
            boolean bl2 = false;
            MediaSource it = mediaSource2;
            boolean bl3 = false;
            it.removeEventListener((MediaSourceEventListener)this.config.getAnalyticsCollector());
            this.config.getAnalyticsCollector().resetForNewPlaylist();
        }
        MediaSource mediaSource3 = source;
        if (mediaSource3 != null) {
            mediaSource3.addEventListener(this.config.getHandler(), (MediaSourceEventListener)this.config.getAnalyticsCollector());
        }
        this.mediaSource = source;
        this.prepared = false;
        this.prepare();
    }

    @Override
    public void addListener(@NotNull ExoPlayerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull ExoPlayerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Override
    public void setBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
    }

    @Override
    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.config.getCoreListeners().setMetadataListener(listener);
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener) {
        this.config.getCoreListeners().setCaptionListener(listener);
    }

    @Override
    public void setVideoSizeListener(@Nullable VideoSizeListener listener) {
        this.config.getCoreListeners().setVideoSizeListener(listener);
    }

    @Override
    public void addAnalyticsListener(@NotNull AnalyticsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.config.getAnalyticsCollector().addListener(listener);
    }

    @Override
    public void removeAnalyticsListener(@NotNull AnalyticsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.config.getAnalyticsCollector().removeListener(listener);
    }

    @Override
    public void clearSurface() {
        Surface surface2 = this.getSurface();
        if (surface2 != null) {
            surface2.release();
        }
        this.setSurface(null);
        this.sendMessage(2, 1, null);
    }

    @Override
    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType((int)streamType);
        int contentType = Util.getAudioContentTypeForStreamType((int)streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        Intrinsics.checkNotNullExpressionValue((Object)audioAttributes, (String)"AudioAttributes.Builder(\u2026entType)\n        .build()");
        AudioAttributes audioAttributes2 = audioAttributes;
        this.sendMessage(1, 3, audioAttributes2);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.config.getTrackManager().isRendererEnabled(type);
    }

    @Override
    public void forcePrepare() {
        this.prepared = false;
    }

    @Override
    public void prepare() {
        MediaSource source = this.mediaSource;
        if (this.prepared || source == null) {
            return;
        }
        Collection collection = this.getRenderers();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getExoPlayer().stop();
        }
        this.stateStore.reset();
        this.getExoPlayer().setMediaSource(source);
        this.getExoPlayer().prepare();
        this.prepared = true;
        this.stopped.set(false);
    }

    @Override
    public void start() {
        this.setPlayWhenReady(true);
    }

    @Override
    public void pause() {
        this.setPlayWhenReady(false);
    }

    @Override
    public boolean restart() {
        int playbackState = this.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            return false;
        }
        this.seekTo(0L);
        this.setPlayWhenReady(true);
        this.forcePrepare();
        this.prepare();
        return true;
    }

    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.getExoPlayer().setPlayWhenReady(false);
            this.getExoPlayer().stop();
        }
    }

    @Override
    public void release() {
        this.getBufferTimer().cancel();
        this.listeners.clear();
        MediaSource mediaSource = this.mediaSource;
        if (mediaSource != null) {
            mediaSource.removeEventListener((MediaSourceEventListener)this.config.getAnalyticsCollector());
        }
        this.setSurface(null);
        this.setPlayWhenReady(false);
        this.getExoPlayer().release();
        this.config.getWakeManager().stayAwake(false);
    }

    @Override
    public void seekTo(long positionMs) {
        this.seekTo(positionMs, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void seekTo(long positionMs, boolean limitToCurrentWindow) {
        this.config.getAnalyticsCollector().notifySeekStarted();
        if (limitToCurrentWindow) {
            this.getExoPlayer().seekTo(positionMs);
            this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
            return;
        }
        Timeline timeline = this.getExoPlayer().getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"exoPlayer.currentTimeline");
        Timeline timeline2 = timeline;
        int windowCount = timeline2.getWindowCount();
        long cumulativePositionMs = 0L;
        Timeline.Window window = new Timeline.Window();
        int n = 0;
        int n2 = windowCount;
        while (n < n2) {
            void index;
            timeline2.getWindow((int)index, window);
            long windowDurationMs = window.getDurationMs();
            if (cumulativePositionMs < positionMs && positionMs <= cumulativePositionMs + windowDurationMs) {
                this.getExoPlayer().seekTo((int)index, positionMs - cumulativePositionMs);
                this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
                return;
            }
            cumulativePositionMs += windowDurationMs;
            ++index;
        }
        Log.e((String)TAG, (String)"Unable to seek across windows, falling back to in-window seeking");
        this.getExoPlayer().seekTo(positionMs);
        this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getCurrentPosition(boolean limitToCurrentWindow) {
        long positionInCurrentWindow = this.getExoPlayer().getCurrentPosition();
        if (limitToCurrentWindow) {
            return positionInCurrentWindow;
        }
        Timeline timeline = this.getExoPlayer().getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"exoPlayer.currentTimeline");
        Timeline timeline2 = timeline;
        int n = timeline2.getWindowCount() - 1;
        int n2 = this.getExoPlayer().getCurrentWindowIndex();
        boolean bl = false;
        int maxWindowIndex = Math.min(n, n2);
        long cumulativePositionMs = 0L;
        Timeline.Window window = new Timeline.Window();
        int n3 = 0;
        int n4 = maxWindowIndex;
        while (n3 < n4) {
            void index;
            timeline2.getWindow((int)index, window);
            cumulativePositionMs += window.getDurationMs();
            ++index;
        }
        return cumulativePositionMs + positionInCurrentWindow;
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.config.getWakeManager().setWakeLevel(levelAndFlags);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.getExoPlayer().setRepeatMode(repeatMode);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.config.getTrackManager().setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.config.getTrackManager().getSelectedTrackIndex(type, groupIndex);
    }

    protected final void sendMessage(int renderType, int messageType, @Nullable Object message) {
        Iterable $this$forEach$iv = this.getRenderers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Renderer renderer = (Renderer)element$iv;
            boolean bl = false;
            if (renderer.getTrackType() != renderType) continue;
            this.getExoPlayer().createMessage((PlayerMessage.Target)renderer).setType(messageType).setPayload(message).send();
        }
    }

    private final void reportPlayerState() {
        int playbackState;
        boolean playWhenReady = this.getExoPlayer().getPlayWhenReady();
        int newState = this.stateStore.getState(playWhenReady, playbackState = this.getPlaybackState());
        if (newState == this.stateStore.getMostRecentState()) {
            return;
        }
        this.stateStore.setMostRecentState(playWhenReady, playbackState);
        boolean informSeekCompletion = this.stateStore.seekCompleted();
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExoPlayerListener listener = (ExoPlayerListener)element$iv;
            boolean bl = false;
            listener.onStateChanged(playWhenReady, playbackState);
            if (!informSeekCompletion) continue;
            listener.onSeekComplete();
        }
    }

    public ExoMediaPlayerImpl(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.exoPlayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExoPlayer>(this){
            final /* synthetic */ ExoMediaPlayerImpl this$0;

            @NotNull
            public final ExoPlayer invoke() {
                Collection $this$toTypedArray$iv = ExoMediaPlayerImpl.access$getRenderers$p(this.this$0);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Renderer[] rendererArray = thisCollection$iv.toArray(new Renderer[0]);
                if (rendererArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ExoPlayer exoPlayer2 = new ExoPlayer.Builder(rendererArray, (TrackSelector)ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getTrackManager().getSelector(), ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getMediaSourceFactory(), ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getLoadControl(), ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getBandwidthMeter()).setAnalyticsCollector(ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getAnalyticsCollector()).build();
                boolean bl = false;
                boolean bl2 = false;
                ExoPlayer it = exoPlayer2;
                boolean bl3 = false;
                it.addListener((Player.EventListener)this.this$0);
                it.addListener((Player.EventListener)ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getAnalyticsCollector());
                ExoPlayer exoPlayer3 = exoPlayer2;
                Intrinsics.checkNotNullExpressionValue((Object)exoPlayer3, (String)"ExoPlayer.Builder(\n     \u2026yticsCollector)\n        }");
                return exoPlayer3;
            }
            {
                this.this$0 = exoMediaPlayerImpl;
                super(0);
            }
        }));
        this.listeners = new CopyOnWriteArrayList();
        this.stopped = new AtomicBoolean();
        this.stateStore = new StateStore();
        this.bufferTimer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Timer>(this){
            final /* synthetic */ ExoMediaPlayerImpl this$0;

            @NotNull
            public final Timer invoke() {
                Timer timer;
                String string = "bufferRepeater";
                boolean bl = true;
                long l = 0L;
                long l2 = 1000L;
                boolean bl2 = false;
                Timer timer2 = timer = TimersKt.timer((String)string, (boolean)bl);
                boolean bl3 = false;
                boolean bl4 = false;
                TimerTask timerTask = new TimerTask(this){
                    final /* synthetic */ bufferTimer.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        block0: {
                            TimerTask $this$fixedRateTimer = this;
                            boolean bl = false;
                            OnBufferUpdateListener onBufferUpdateListener = ExoMediaPlayerImpl.access$getBufferUpdateListener$p(this.this$0.this$0);
                            if (onBufferUpdateListener == null) break block0;
                            onBufferUpdateListener.onBufferingUpdate(this.this$0.this$0.getBufferedPercent());
                        }
                    }
                };
                timer2.scheduleAtFixedRate(timerTask, l, l2);
                return timer;
            }
            {
                this.this$0 = exoMediaPlayerImpl;
                super(0);
            }
        }));
        this.requestedVolume = 1.0f;
        this.renderers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Renderer>>(this){
            final /* synthetic */ ExoMediaPlayerImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Renderer> invoke() {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = ExoMediaPlayerImpl.access$getConfig$p(this.this$0).getRenderProviders().values();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    RenderProvider it = (RenderProvider)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.buildRenderers();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = exoMediaPlayerImpl;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ List access$getRenderers$p(ExoMediaPlayerImpl $this) {
        return $this.getRenderers();
    }

    public static final /* synthetic */ PlayerConfig access$getConfig$p(ExoMediaPlayerImpl $this) {
        return $this.config;
    }

    public static final /* synthetic */ OnBufferUpdateListener access$getBufferUpdateListener$p(ExoMediaPlayerImpl $this) {
        return $this.bufferUpdateListener;
    }

    public static final /* synthetic */ void access$setBufferUpdateListener$p(ExoMediaPlayerImpl $this, OnBufferUpdateListener onBufferUpdateListener) {
        $this.bufferUpdateListener = onBufferUpdateListener;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl$Companion;", "", "()V", "BUFFER_REPEAT_DELAY", "", "TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

