/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.renderer;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.ExoMedia;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.metadata.MetadataDecoderFactory;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.video.MediaCodecVideoRenderer;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class RendererProvider {
    @NonNull
    protected Context context;
    @NonNull
    protected Handler handler;
    @NonNull
    protected TextOutput captionListener;
    @NonNull
    protected MetadataOutput metadataListener;
    @NonNull
    protected AudioRendererEventListener audioRendererEventListener;
    @NonNull
    protected VideoRendererEventListener videoRendererEventListener;
    @Nullable
    protected DrmSessionManager<FrameworkMediaCrypto> drmSessionManager;
    protected int droppedFrameNotificationAmount = 50;
    protected int videoJoiningTimeMs = 5000;

    public RendererProvider(@NonNull Context context, @NonNull Handler handler, @NonNull TextOutput captionListener, @NonNull MetadataOutput metadataListener, @NonNull AudioRendererEventListener audioRendererEventListener, @NonNull VideoRendererEventListener videoRendererEventListener) {
        this.context = context;
        this.handler = handler;
        this.captionListener = captionListener;
        this.metadataListener = metadataListener;
        this.audioRendererEventListener = audioRendererEventListener;
        this.videoRendererEventListener = videoRendererEventListener;
    }

    public void setDrmSessionManager(@Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager) {
        this.drmSessionManager = drmSessionManager;
    }

    public void setDroppedFrameNotificationAmount(int droppedFrameNotificationAmount) {
        this.droppedFrameNotificationAmount = droppedFrameNotificationAmount;
    }

    public void setVideoJoiningTimeMs(int videoJoiningTimeMs) {
        this.videoJoiningTimeMs = videoJoiningTimeMs;
    }

    @NonNull
    public List<Renderer> generate() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        renderers.addAll(this.buildAudioRenderers());
        renderers.addAll(this.buildVideoRenderers());
        renderers.addAll(this.buildCaptionRenderers());
        renderers.addAll(this.buildMetadataRenderers());
        return renderers;
    }

    @NonNull
    protected List<Renderer> buildAudioRenderers() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        renderers.add((Renderer)new MediaCodecAudioRenderer(this.context, MediaCodecSelector.DEFAULT, this.drmSessionManager, true, this.handler, this.audioRendererEventListener, AudioCapabilities.getCapabilities((Context)this.context), new AudioProcessor[0]));
        List<String> classNames = ExoMedia.Data.registeredRendererClasses.get((Object)ExoMedia.RendererType.AUDIO);
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getConstructor(Handler.class, AudioRendererEventListener.class);
                    Renderer renderer = (Renderer)constructor.newInstance(this.handler, this.audioRendererEventListener);
                    renderers.add(renderer);
                }
                catch (Exception exception) {}
            }
        }
        return renderers;
    }

    @NonNull
    protected List<Renderer> buildVideoRenderers() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        renderers.add((Renderer)new MediaCodecVideoRenderer(this.context, MediaCodecSelector.DEFAULT, (long)this.videoJoiningTimeMs, this.drmSessionManager, false, this.handler, this.videoRendererEventListener, this.droppedFrameNotificationAmount));
        List<String> classNames = ExoMedia.Data.registeredRendererClasses.get((Object)ExoMedia.RendererType.VIDEO);
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE, Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
                    Renderer renderer = (Renderer)constructor.newInstance(true, this.videoJoiningTimeMs, this.handler, this.videoRendererEventListener, this.droppedFrameNotificationAmount);
                    renderers.add(renderer);
                }
                catch (Exception exception) {}
            }
        }
        return renderers;
    }

    @NonNull
    protected List<Renderer> buildCaptionRenderers() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        renderers.add((Renderer)new TextRenderer(this.captionListener, this.handler.getLooper()));
        return renderers;
    }

    @NonNull
    protected List<Renderer> buildMetadataRenderers() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        renderers.add((Renderer)new MetadataRenderer(this.metadataListener, this.handler.getLooper(), MetadataDecoderFactory.DEFAULT));
        return renderers;
    }
}

