/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;

public class Repeater {
    protected static final String HANDLER_THREAD_NAME = "ExoMedia_Repeater_HandlerThread";
    protected static final int DEFAULT_REPEAT_DELAY = 33;
    protected volatile boolean repeaterRunning = false;
    protected int repeatDelay = 33;
    protected Handler delayedHandler;
    protected HandlerThread handlerThread;
    protected boolean useHandlerThread = false;
    protected RepeatListener listener;
    protected PollRunnable pollRunnable = new PollRunnable();

    public Repeater() {
        this(true);
    }

    public Repeater(boolean processOnStartingThread) {
        if (processOnStartingThread) {
            this.delayedHandler = new Handler();
            return;
        }
        this.useHandlerThread = true;
    }

    public Repeater(Handler handler) {
        this.delayedHandler = handler;
    }

    public void setRepeaterDelay(int milliSeconds) {
        this.repeatDelay = milliSeconds;
    }

    public int getRepeaterDelay() {
        return this.repeatDelay;
    }

    public void start() {
        if (!this.repeaterRunning) {
            this.repeaterRunning = true;
            if (this.useHandlerThread) {
                this.handlerThread = new HandlerThread(HANDLER_THREAD_NAME);
                this.handlerThread.start();
                this.delayedHandler = new Handler(this.handlerThread.getLooper());
            }
            this.pollRunnable.performPoll();
        }
    }

    public void stop() {
        if (this.handlerThread != null) {
            this.handlerThread.quit();
        }
        this.repeaterRunning = false;
    }

    public boolean isRunning() {
        return this.repeaterRunning;
    }

    public void setRepeatListener(@Nullable RepeatListener listener) {
        this.listener = listener;
    }

    protected class PollRunnable
    implements Runnable {
        protected PollRunnable() {
        }

        @Override
        public void run() {
            if (Repeater.this.listener != null) {
                Repeater.this.listener.onRepeat();
            }
            if (Repeater.this.repeaterRunning) {
                this.performPoll();
            }
        }

        public void performPoll() {
            Repeater.this.delayedHandler.postDelayed((Runnable)Repeater.this.pollRunnable, (long)Repeater.this.repeatDelay);
        }
    }

    public static interface RepeatListener {
        public void onRepeat();
    }
}

