/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.app.UiModeManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import java.util.LinkedList;
import java.util.List;

public class DeviceUtil {
    protected static final List<NonCompatibleDevice> NON_COMPATIBLE_DEVICES = new LinkedList<NonCompatibleDevice>();

    public boolean supportsExoPlayer(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 16 && !this.isNotCompatible(NON_COMPATIBLE_DEVICES)) {
            return true;
        }
        return Build.MANUFACTURER.equalsIgnoreCase("Amazon") && (this.isDeviceTV(context) || Build.VERSION.SDK_INT >= 21);
    }

    public boolean isNotCompatible(@NonNull List<NonCompatibleDevice> nonCompatibleDevices) {
        for (NonCompatibleDevice device : nonCompatibleDevices) {
            if (!Build.MANUFACTURER.equalsIgnoreCase(device.getManufacturer())) continue;
            if (device.ignoreModel()) {
                return true;
            }
            if (!Build.DEVICE.equalsIgnoreCase(device.getModel())) continue;
            return true;
        }
        return false;
    }

    public boolean isDeviceTV(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            UiModeManager uiManager = (UiModeManager)context.getSystemService("uimode");
            return uiManager != null && uiManager.getCurrentModeType() == 4;
        }
        return false;
    }

    static {
        NON_COMPATIBLE_DEVICES.add(new NonCompatibleDevice("Amazon"));
    }

    public static class NonCompatibleDevice {
        private boolean ignoreModel;
        private final String model;
        private final String manufacturer;

        public NonCompatibleDevice(@NonNull String manufacturer) {
            this.manufacturer = manufacturer;
            this.model = null;
            this.ignoreModel = true;
        }

        public NonCompatibleDevice(@NonNull String model, @NonNull String manufacturer) {
            this.model = model;
            this.manufacturer = manufacturer;
        }

        public boolean ignoreModel() {
            return this.ignoreModel;
        }

        public String getModel() {
            return this.model;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }
    }
}

