/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core;

import android.media.MediaPlayer;
import android.net.NetworkInfo;
import android.os.Handler;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.devbrackets.android.exomedia.core.exception.NativeMediaPlaybackException;
import com.devbrackets.android.exomedia.core.exoplayer.ExoMediaPlayer;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class ListenerMux
implements ExoPlayerListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
OnBufferUpdateListener,
MetadataListener,
AnalyticsListener {
    private static final long COMPLETED_DURATION_LEEWAY = 1000L;
    @NonNull
    private Handler delayedHandler = new Handler();
    @NonNull
    private Notifier muxNotifier;
    @Nullable
    private OnPreparedListener preparedListener;
    @Nullable
    private OnCompletionListener completionListener;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @Nullable
    private OnSeekCompletionListener seekCompletionListener;
    @Nullable
    private OnErrorListener errorListener;
    @Nullable
    private MetadataListener metadataListener;
    @Nullable
    private AnalyticsListener analyticsListener;
    @NonNull
    private WeakReference<ClearableSurface> clearableSurfaceRef = new WeakReference<Object>(null);
    private boolean notifiedPrepared = false;
    private boolean notifiedCompleted = false;
    private boolean clearRequested = false;

    public ListenerMux(@NonNull Notifier notifier) {
        this.muxNotifier = notifier;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.onBufferingUpdate(percent);
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.completionListener != null) {
            this.completionListener.onCompletion();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return this.notifyErrorListener(new NativeMediaPlaybackException(what, extra));
    }

    public void onSeekComplete(MediaPlayer mp) {
        if (this.seekCompletionListener != null) {
            this.seekCompletionListener.onSeekComplete();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        this.notifyPreparedListener();
    }

    @Override
    public void onError(ExoMediaPlayer exoMediaPlayer, Exception e) {
        this.muxNotifier.onMediaPlaybackEnded();
        this.muxNotifier.onExoPlayerError(exoMediaPlayer, e);
        this.notifyErrorListener(e);
    }

    @Override
    public void onStateChanged(boolean playWhenReady, int playbackState) {
        if (playbackState == 4) {
            this.muxNotifier.onMediaPlaybackEnded();
            if (!this.notifiedCompleted) {
                this.notifyCompletionListener();
            }
        } else if (playbackState == 3 && !this.notifiedPrepared) {
            this.notifyPreparedListener();
        }
        if (playbackState == 3 && playWhenReady) {
            this.muxNotifier.onPreviewImageStateChanged(false);
        }
        if (playbackState == 1 && this.clearRequested) {
            this.clearRequested = false;
            ClearableSurface clearableSurface = (ClearableSurface)this.clearableSurfaceRef.get();
            if (clearableSurface != null) {
                clearableSurface.clearSurface();
                this.clearableSurfaceRef = new WeakReference<Object>(null);
            }
        }
    }

    @Override
    public void onSeekComplete() {
        this.muxNotifier.onSeekComplete();
        if (this.seekCompletionListener != null) {
            this.seekCompletionListener.onSeekComplete();
        }
    }

    @Override
    public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
        this.muxNotifier.onBufferUpdated(percent);
        if (this.bufferUpdateListener != null) {
            this.bufferUpdateListener.onBufferingUpdate(percent);
        }
    }

    @Override
    public void onMetadata(Metadata metadata) {
        if (this.metadataListener != null) {
            this.metadataListener.onMetadata(metadata);
        }
    }

    @Override
    public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
        this.muxNotifier.onVideoSizeChanged(width, height, unAppliedRotationDegrees, pixelWidthHeightRatio);
    }

    public void onPlayerStateChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int playbackState) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onPlayerStateChanged(eventTime, playWhenReady, playbackState);
        }
    }

    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onTimelineChanged(eventTime, reason);
        }
    }

    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onPositionDiscontinuity(eventTime, reason);
        }
    }

    public void onSeekStarted(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onSeekStarted(eventTime);
        }
    }

    public void onSeekProcessed(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onSeekProcessed(eventTime);
        }
    }

    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onPlaybackParametersChanged(eventTime, playbackParameters);
        }
    }

    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onRepeatModeChanged(eventTime, repeatMode);
        }
    }

    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onShuffleModeChanged(eventTime, shuffleModeEnabled);
        }
    }

    public void onLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onLoadingChanged(eventTime, isLoading);
        }
    }

    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onPlayerError(eventTime, error);
        }
    }

    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onTracksChanged(eventTime, trackGroups, trackSelections);
        }
    }

    public void onLoadStarted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onLoadStarted(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onLoadCompleted(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onLoadCanceled(eventTime, loadEventInfo, mediaLoadData);
        }
    }

    public void onLoadError(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onLoadError(eventTime, loadEventInfo, mediaLoadData, error, wasCanceled);
        }
    }

    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDownstreamFormatChanged(eventTime, mediaLoadData);
        }
    }

    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onUpstreamDiscarded(eventTime, mediaLoadData);
        }
    }

    public void onMediaPeriodCreated(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onMediaPeriodCreated(eventTime);
        }
    }

    public void onMediaPeriodReleased(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onMediaPeriodReleased(eventTime);
        }
    }

    public void onReadingStarted(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onReadingStarted(eventTime);
        }
    }

    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onBandwidthEstimate(eventTime, totalLoadTimeMs, totalBytesLoaded, bitrateEstimate);
        }
    }

    public void onViewportSizeChange(AnalyticsListener.EventTime eventTime, int width, int height) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onViewportSizeChange(eventTime, width, height);
        }
    }

    public void onNetworkTypeChanged(AnalyticsListener.EventTime eventTime, @Nullable NetworkInfo networkInfo) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onNetworkTypeChanged(eventTime, networkInfo);
        }
    }

    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onMetadata(eventTime, metadata);
        }
    }

    public void onDecoderEnabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDecoderEnabled(eventTime, trackType, decoderCounters);
        }
    }

    public void onDecoderInitialized(AnalyticsListener.EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDecoderInitialized(eventTime, trackType, decoderName, initializationDurationMs);
        }
    }

    public void onDecoderInputFormatChanged(AnalyticsListener.EventTime eventTime, int trackType, Format format) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDecoderInputFormatChanged(eventTime, trackType, format);
        }
    }

    public void onDecoderDisabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDecoderDisabled(eventTime, trackType, decoderCounters);
        }
    }

    public void onAudioSessionId(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onAudioSessionId(eventTime, audioSessionId);
        }
    }

    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onAudioUnderrun(eventTime, bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }
    }

    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDroppedVideoFrames(eventTime, droppedFrames, elapsedMs);
        }
    }

    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onVideoSizeChanged(eventTime, width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }
    }

    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Surface surface) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onRenderedFirstFrame(eventTime, surface);
        }
    }

    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDrmKeysLoaded(eventTime);
        }
    }

    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDrmSessionManagerError(eventTime, error);
        }
    }

    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDrmKeysRestored(eventTime);
        }
    }

    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
        if (this.analyticsListener != null) {
            this.analyticsListener.onDrmKeysRemoved(eventTime);
        }
    }

    public void clearSurfaceWhenReady(@Nullable ClearableSurface clearableSurface) {
        this.clearRequested = true;
        this.clearableSurfaceRef = new WeakReference<ClearableSurface>(clearableSurface);
    }

    public void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.preparedListener = listener;
    }

    public void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.completionListener = listener;
    }

    public void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
    }

    public void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.seekCompletionListener = listener;
    }

    public void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.errorListener = listener;
    }

    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.metadataListener = listener;
    }

    public void setAnalyticsListener(@Nullable AnalyticsListener listener) {
        this.analyticsListener = listener;
    }

    public void setNotifiedPrepared(boolean wasNotified) {
        this.notifiedPrepared = wasNotified;
        this.muxNotifier.onPreviewImageStateChanged(true);
    }

    public boolean isPrepared() {
        return this.notifiedPrepared;
    }

    public void setNotifiedCompleted(boolean wasNotified) {
        this.notifiedCompleted = wasNotified;
    }

    private boolean notifyErrorListener(Exception e) {
        return this.errorListener != null && this.errorListener.onError(e);
    }

    private void notifyPreparedListener() {
        this.notifiedPrepared = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                ListenerMux.this.performPreparedHandlerNotification();
            }
        });
    }

    private void performPreparedHandlerNotification() {
        this.muxNotifier.onPrepared();
        if (this.preparedListener != null) {
            this.preparedListener.onPrepared();
        }
    }

    private void notifyCompletionListener() {
        if (!this.muxNotifier.shouldNotifyCompletion(1000L)) {
            return;
        }
        this.notifiedCompleted = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ListenerMux.this.completionListener != null) {
                    ListenerMux.this.completionListener.onCompletion();
                }
            }
        });
    }

    public static abstract class Notifier {
        public void onSeekComplete() {
        }

        public void onBufferUpdated(int percent) {
        }

        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
        }

        public void onPrepared() {
        }

        public void onPreviewImageStateChanged(boolean toVisible) {
        }

        public abstract boolean shouldNotifyCompletion(long var1);

        public abstract void onExoPlayerError(ExoMediaPlayer var1, Exception var2);

        public abstract void onMediaPlaybackEnded();
    }
}

