/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.exo;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.exoplayer.ExoMediaPlayer;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public class ExoVideoDelegate {
    protected ExoMediaPlayer exoMediaPlayer;
    protected ListenerMux listenerMux;
    protected boolean playRequested = false;
    protected Context context;
    protected ClearableSurface clearableSurface;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();

    public ExoVideoDelegate(@NonNull Context context, @NonNull ClearableSurface clearableSurface) {
        this.context = context.getApplicationContext();
        this.clearableSurface = clearableSurface;
        this.setup();
    }

    public void setVideoUri(@Nullable Uri uri) {
        this.setVideoUri(uri, null);
    }

    public void setVideoUri(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.listenerMux.setNotifiedPrepared(false);
        this.exoMediaPlayer.seekTo(0L);
        if (mediaSource != null) {
            this.exoMediaPlayer.setMediaSource(mediaSource);
            this.listenerMux.setNotifiedCompleted(false);
        } else if (uri != null) {
            this.exoMediaPlayer.setUri(uri);
            this.listenerMux.setNotifiedCompleted(false);
        } else {
            this.exoMediaPlayer.setMediaSource(null);
        }
    }

    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.exoMediaPlayer.setDrmCallback(drmCallback);
    }

    public boolean restart() {
        if (!this.exoMediaPlayer.restart()) {
            return false;
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.exoMediaPlayer.getVolume();
    }

    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.exoMediaPlayer.setVolume(volume);
        return true;
    }

    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.exoMediaPlayer.seekTo(milliseconds);
    }

    public boolean isPlaying() {
        return this.exoMediaPlayer.getPlayWhenReady();
    }

    public void start() {
        this.exoMediaPlayer.setPlayWhenReady(true);
        this.listenerMux.setNotifiedCompleted(false);
        this.playRequested = true;
    }

    public void pause() {
        this.exoMediaPlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    public void stopPlayback(boolean clearSurface) {
        this.exoMediaPlayer.stop();
        this.playRequested = false;
        if (clearSurface) {
            this.listenerMux.clearSurfaceWhenReady(this.clearableSurface);
        }
    }

    public void suspend() {
        this.exoMediaPlayer.release();
        this.playRequested = false;
    }

    public long getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.exoMediaPlayer.getDuration();
    }

    public long getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.exoMediaPlayer.getCurrentPosition();
    }

    public int getBufferedPercent() {
        return this.exoMediaPlayer.getBufferedPercentage();
    }

    @Nullable
    public WindowInfo getWindowInfo() {
        return this.exoMediaPlayer.getWindowInfo();
    }

    public boolean trackSelectionAvailable() {
        return true;
    }

    public void setTrack(ExoMedia.RendererType trackType, int trackIndex) {
        this.exoMediaPlayer.setSelectedTrack(trackType, trackIndex);
    }

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.exoMediaPlayer.getAvailableTracks();
    }

    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
        this.exoMediaPlayer.setRendererEnabled(type, enabled);
    }

    public boolean setPlaybackSpeed(float speed) {
        return this.exoMediaPlayer.setPlaybackSpeed(speed);
    }

    public float getPlaybackSpeed() {
        return this.exoMediaPlayer.getPlaybackSpeed();
    }

    public void release() {
        this.exoMediaPlayer.release();
    }

    public void setListenerMux(ListenerMux listenerMux) {
        if (this.listenerMux != null) {
            this.exoMediaPlayer.removeListener(this.listenerMux);
        }
        this.listenerMux = listenerMux;
        this.exoMediaPlayer.addListener(listenerMux);
    }

    public void setRepeatMode(int repeatMode) {
        this.exoMediaPlayer.setRepeatMode(repeatMode);
    }

    public void onSurfaceReady(Surface surface) {
        this.exoMediaPlayer.setSurface(surface);
        if (this.playRequested) {
            this.exoMediaPlayer.setPlayWhenReady(true);
        }
    }

    public void onSurfaceDestroyed() {
        this.exoMediaPlayer.clearSurface();
    }

    protected void setup() {
        this.initExoPlayer();
    }

    protected void initExoPlayer() {
        this.exoMediaPlayer = new ExoMediaPlayer(this.context);
        this.exoMediaPlayer.setMetadataListener(this.internalListeners);
        this.exoMediaPlayer.setBufferUpdateListener(this.internalListeners);
    }

    protected class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener {
        protected InternalListeners() {
        }

        @Override
        public void onMetadata(Metadata metadata) {
            ExoVideoDelegate.this.listenerMux.onMetadata(metadata);
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            ExoVideoDelegate.this.listenerMux.onBufferingUpdate(percent);
        }
    }
}

