/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.exoplayer;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.view.Surface;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.InternalErrorListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererProvider;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.util.Repeater;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.drm.DefaultDrmSessionEventListener;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExoMediaPlayer
extends Player.DefaultEventListener {
    private static final String TAG = "ExoMediaPlayer";
    private static final int BUFFER_REPEAT_DELAY = 1000;
    private static final int WAKE_LOCK_TIMEOUT = 1000;
    @NonNull
    private final Context context;
    @NonNull
    private final ExoPlayer player;
    @NonNull
    private final DefaultTrackSelector trackSelector;
    @NonNull
    private final AdaptiveTrackSelection.Factory adaptiveTrackSelectionFactory;
    @NonNull
    private final Handler mainHandler;
    @NonNull
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners = new CopyOnWriteArrayList();
    @NonNull
    private final AtomicBoolean stopped = new AtomicBoolean();
    private boolean prepared = false;
    @NonNull
    private StateStore stateStore = new StateStore();
    @NonNull
    private Repeater bufferRepeater = new Repeater();
    @Nullable
    private Surface surface;
    @Nullable
    private MediaDrmCallback drmCallback;
    @Nullable
    private MediaSource mediaSource;
    @NonNull
    private List<Renderer> renderers;
    @NonNull
    private DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
    @Nullable
    private CaptionListener captionListener;
    @Nullable
    private MetadataListener metadataListener;
    @Nullable
    private InternalErrorListener internalErrorListener;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @Nullable
    private PowerManager.WakeLock wakeLock = null;
    @NonNull
    private CapabilitiesListener capabilitiesListener = new CapabilitiesListener();
    private int audioSessionId = 0;
    @FloatRange(from=0.0, to=1.0)
    protected float requestedVolume = 1.0f;

    public ExoMediaPlayer(@NonNull Context context) {
        this.context = context;
        this.bufferRepeater.setRepeaterDelay(1000);
        this.bufferRepeater.setRepeatListener(new BufferRepeatListener());
        this.mainHandler = new Handler();
        ComponentListener componentListener = new ComponentListener();
        RendererProvider rendererProvider = new RendererProvider(context, this.mainHandler, componentListener, componentListener, componentListener, componentListener);
        rendererProvider.setDrmSessionManager(this.generateDrmSessionManager());
        this.renderers = rendererProvider.generate();
        this.adaptiveTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)this.bandwidthMeter);
        this.trackSelector = new DefaultTrackSelector((TrackSelection.Factory)this.adaptiveTrackSelectionFactory);
        LoadControl loadControl = ExoMedia.Data.loadControl != null ? ExoMedia.Data.loadControl : new DefaultLoadControl();
        this.player = ExoPlayerFactory.newInstance((Renderer[])this.renderers.toArray(new Renderer[this.renderers.size()]), (TrackSelector)this.trackSelector, (LoadControl)loadControl);
        this.player.addListener((Player.EventListener)this);
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.reportPlayerState();
    }

    public void onPlayerError(ExoPlaybackException exception) {
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError(this, (Exception)exception);
        }
    }

    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.drmCallback = drmCallback;
    }

    public void setUri(@Nullable Uri uri) {
        this.setMediaSource(uri != null ? ExoMedia.Data.mediaSourceProvider.generate(this.context, this.mainHandler, uri, (TransferListener<? super DataSource>)this.bandwidthMeter) : null);
    }

    public void setMediaSource(@Nullable MediaSource source) {
        this.mediaSource = source;
        this.prepared = false;
        this.prepare();
    }

    public void addListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void setBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
        this.setBufferRepeaterStarted(listener != null);
    }

    public void setInternalErrorListener(@Nullable InternalErrorListener listener) {
        this.internalErrorListener = listener;
    }

    public void setCaptionListener(@Nullable CaptionListener listener) {
        this.captionListener = listener;
    }

    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.metadataListener = listener;
    }

    public void setSurface(@Nullable Surface surface) {
        this.surface = surface;
        this.sendMessage(2, 1, surface, false);
    }

    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    public void clearSurface() {
        if (this.surface != null) {
            this.surface.release();
        }
        this.surface = null;
        this.sendMessage(2, 1, null, false);
    }

    @Deprecated
    public void blockingClearSurface() {
        this.clearSurface();
    }

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        ExoMedia.RendererType[] types;
        if (this.getPlaybackState() == 1) {
            return null;
        }
        ArrayMap trackMap = new ArrayMap();
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return trackMap;
        }
        for (ExoMedia.RendererType type : types = new ExoMedia.RendererType[]{ExoMedia.RendererType.AUDIO, ExoMedia.RendererType.VIDEO, ExoMedia.RendererType.CLOSED_CAPTION, ExoMedia.RendererType.METADATA}) {
            int exoPlayerTrackIndex = this.getExoPlayerTrackIndex(type);
            if (mappedTrackInfo.getRendererCount() <= exoPlayerTrackIndex) continue;
            trackMap.put(type, mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex));
        }
        return trackMap;
    }

    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type) {
        TrackGroupArray trackGroupArray;
        int exoPlayerTrackIndex = this.getExoPlayerTrackIndex(type);
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        TrackGroupArray trackGroupArray2 = trackGroupArray = mappedTrackInfo == null ? null : mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex);
        if (trackGroupArray == null || trackGroupArray.length == 0) {
            return -1;
        }
        DefaultTrackSelector.SelectionOverride selectionOverride = this.trackSelector.getParameters().getSelectionOverride(exoPlayerTrackIndex, trackGroupArray);
        if (selectionOverride == null || selectionOverride.groupIndex != exoPlayerTrackIndex || selectionOverride.length <= 0) {
            return -1;
        }
        return selectionOverride.tracks[0];
    }

    public void setSelectedTrack(@NonNull ExoMedia.RendererType type, int index) {
        TrackGroupArray trackGroupArray;
        int exoPlayerTrackIndex = this.getExoPlayerTrackIndex(type);
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        TrackGroupArray trackGroupArray2 = trackGroupArray = mappedTrackInfo == null ? null : mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex);
        if (trackGroupArray == null || trackGroupArray.length == 0) {
            return;
        }
        DefaultTrackSelector.SelectionOverride selectionOverride = new DefaultTrackSelector.SelectionOverride(exoPlayerTrackIndex, new int[]{index});
        this.trackSelector.setParameters(this.trackSelector.buildUponParameters().setSelectionOverride(exoPlayerTrackIndex, trackGroupArray, selectionOverride));
    }

    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
        int exoPlayerTrackIndex = this.getExoPlayerTrackIndex(type);
        this.trackSelector.setParameters(this.trackSelector.buildUponParameters().setRendererDisabled(exoPlayerTrackIndex, !enabled));
    }

    public void setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.requestedVolume = volume;
        this.sendMessage(1, 2, Float.valueOf(this.requestedVolume));
    }

    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.requestedVolume;
    }

    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType((int)streamType);
        int contentType = Util.getAudioContentTypeForStreamType((int)streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        this.sendMessage(1, 3, audioAttributes);
    }

    public void forcePrepare() {
        this.prepared = false;
    }

    public void prepare() {
        if (this.prepared || this.mediaSource == null) {
            return;
        }
        if (!this.renderers.isEmpty()) {
            this.player.stop();
        }
        this.stateStore.reset();
        this.player.prepare(this.mediaSource);
        this.prepared = true;
        this.stopped.set(false);
    }

    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.player.setPlayWhenReady(false);
            this.player.stop();
        }
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
        this.stayAwake(playWhenReady);
    }

    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
        this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
    }

    public boolean restart() {
        int playbackState = this.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            return false;
        }
        this.seekTo(0L);
        this.setPlayWhenReady(true);
        this.forcePrepare();
        this.prepare();
        return true;
    }

    public void release() {
        this.setBufferRepeaterStarted(false);
        this.listeners.clear();
        this.surface = null;
        this.player.release();
        this.stayAwake(false);
    }

    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public boolean setPlaybackSpeed(float speed) {
        PlaybackParameters params = new PlaybackParameters(speed, 1.0f);
        this.player.setPlaybackParameters(params);
        return true;
    }

    public float getPlaybackSpeed() {
        PlaybackParameters params = this.player.getPlaybackParameters();
        return params.speed;
    }

    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Nullable
    public WindowInfo getWindowInfo() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return null;
        }
        int currentWindowIndex = this.player.getCurrentWindowIndex();
        Timeline.Window currentWindow = timeline.getWindow(currentWindowIndex, new Timeline.Window());
        return new WindowInfo(this.player.getPreviousWindowIndex(), currentWindowIndex, this.player.getNextWindowIndex(), currentWindow);
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    public void setWakeMode(Context context, int mode) {
        boolean wasHeld = false;
        if (this.wakeLock != null) {
            if (this.wakeLock.isHeld()) {
                wasHeld = true;
                this.wakeLock.release();
            }
            this.wakeLock = null;
        }
        if (context.getPackageManager().checkPermission("android.permission.WAKE_LOCK", context.getPackageName()) == 0) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            if (pm != null) {
                this.wakeLock = pm.newWakeLock(mode | 0x20000000, ExoMediaPlayer.class.getName());
                this.wakeLock.setReferenceCounted(false);
            } else {
                Log.e((String)TAG, (String)"Unable to acquire WAKE_LOCK due to a null power manager");
            }
        } else {
            Log.w((String)TAG, (String)"Unable to acquire WAKE_LOCK due to missing manifest permission");
        }
        this.stayAwake(wasHeld);
    }

    public void setRepeatMode(int repeatMode) {
        this.player.setRepeatMode(repeatMode);
    }

    protected int getExoPlayerTrackType(@NonNull ExoMedia.RendererType type) {
        switch (type) {
            case AUDIO: {
                return 1;
            }
            case VIDEO: {
                return 2;
            }
            case CLOSED_CAPTION: {
                return 3;
            }
            case METADATA: {
                return 4;
            }
        }
        return -1;
    }

    protected int getExoPlayerTrackIndex(@NonNull ExoMedia.RendererType type) {
        switch (type) {
            case AUDIO: 
            case VIDEO: 
            case CLOSED_CAPTION: 
            case METADATA: {
                return type.ordinal();
            }
        }
        return -1;
    }

    protected void sendMessage(int renderType, int messageType, Object message) {
        this.sendMessage(renderType, messageType, message, false);
    }

    protected void sendMessage(int renderType, int messageType, Object message, boolean blocking) {
        if (this.renderers.isEmpty()) {
            return;
        }
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != renderType) continue;
            messages.add(this.player.createMessage((PlayerMessage.Target)renderer).setType(messageType).setPayload(message));
        }
        if (blocking) {
            this.blockingSendMessages(messages);
        } else {
            for (PlayerMessage playerMessage : messages) {
                playerMessage.send();
            }
        }
    }

    protected void blockingSendMessages(List<PlayerMessage> messages) {
        boolean wasInterrupted = false;
        for (PlayerMessage message : messages) {
            boolean blockMessage = true;
            while (blockMessage) {
                try {
                    message.blockUntilDelivered();
                    blockMessage = false;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected void stayAwake(boolean awake) {
        if (this.wakeLock == null) {
            return;
        }
        if (awake && !this.wakeLock.isHeld()) {
            this.wakeLock.acquire(1000L);
        } else if (!awake && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    @Nullable
    protected DrmSessionManager<FrameworkMediaCrypto> generateDrmSessionManager() {
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        UUID uuid = C.WIDEVINE_UUID;
        try {
            DefaultDrmSessionManager sessionManager = new DefaultDrmSessionManager(uuid, (ExoMediaDrm)FrameworkMediaDrm.newInstance((UUID)uuid), (MediaDrmCallback)new DelegatedMediaDrmCallback(), null);
            sessionManager.addListener(this.mainHandler, (DefaultDrmSessionEventListener)this.capabilitiesListener);
            return sessionManager;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Unable to create a DrmSessionManager due to an exception", (Throwable)e);
            return null;
        }
    }

    private void reportPlayerState() {
        int playbackState;
        boolean playWhenReady = this.player.getPlayWhenReady();
        int newState = this.stateStore.getState(playWhenReady, playbackState = this.getPlaybackState());
        if (newState != this.stateStore.getMostRecentState()) {
            this.stateStore.setMostRecentState(playWhenReady, playbackState);
            if (newState == 3) {
                this.setBufferRepeaterStarted(true);
            } else if (newState == 1 || newState == 4) {
                this.setBufferRepeaterStarted(false);
            }
            boolean informSeekCompletion = this.stateStore.matchesHistory(new int[]{100, 2, 3}, true);
            informSeekCompletion |= this.stateStore.matchesHistory(new int[]{2, 100, 3}, true);
            informSeekCompletion |= this.stateStore.matchesHistory(new int[]{100, 3, 2, 3}, true);
            for (ExoPlayerListener listener : this.listeners) {
                listener.onStateChanged(playWhenReady, playbackState);
                if (!informSeekCompletion) continue;
                listener.onSeekComplete();
            }
        }
    }

    private void setBufferRepeaterStarted(boolean start) {
        if (start && this.bufferUpdateListener != null) {
            this.bufferRepeater.start();
        } else {
            this.bufferRepeater.stop();
        }
    }

    private class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput {
        private ComponentListener() {
        }

        public void onAudioEnabled(DecoderCounters counters) {
        }

        public void onAudioDisabled(DecoderCounters counters) {
            ExoMediaPlayer.this.audioSessionId = 0;
        }

        public void onAudioSessionId(int sessionId) {
            ExoMediaPlayer.this.audioSessionId = sessionId;
        }

        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        }

        public void onAudioInputFormatChanged(Format format) {
        }

        public void onAudioSinkUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (ExoMediaPlayer.this.internalErrorListener != null) {
                ExoMediaPlayer.this.internalErrorListener.onAudioSinkUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }

        public void onVideoEnabled(DecoderCounters counters) {
        }

        public void onVideoDisabled(DecoderCounters counters) {
        }

        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
        }

        public void onVideoInputFormatChanged(Format format) {
        }

        public void onDroppedFrames(int count, long elapsedMs) {
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            for (ExoPlayerListener listener : ExoMediaPlayer.this.listeners) {
                listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
        }

        public void onRenderedFirstFrame(Surface surface) {
        }

        public void onMetadata(Metadata metadata) {
            if (ExoMediaPlayer.this.metadataListener != null) {
                ExoMediaPlayer.this.metadataListener.onMetadata(metadata);
            }
        }

        public void onCues(List<Cue> cues) {
            if (ExoMediaPlayer.this.captionListener != null) {
                ExoMediaPlayer.this.captionListener.onCues(cues);
            }
        }
    }

    private class CapabilitiesListener
    implements DefaultDrmSessionManager.EventListener {
        private CapabilitiesListener() {
        }

        public void onDrmKeysLoaded() {
        }

        public void onDrmKeysRestored() {
        }

        public void onDrmKeysRemoved() {
        }

        public void onDrmSessionManagerError(Exception e) {
            if (ExoMediaPlayer.this.internalErrorListener != null) {
                ExoMediaPlayer.this.internalErrorListener.onDrmSessionManagerError(e);
            }
        }
    }

    private class DelegatedMediaDrmCallback
    implements MediaDrmCallback {
        private DelegatedMediaDrmCallback() {
        }

        public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest request) throws Exception {
            return ExoMediaPlayer.this.drmCallback != null ? ExoMediaPlayer.this.drmCallback.executeProvisionRequest(uuid, request) : new byte[]{};
        }

        public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest request) throws Exception {
            return ExoMediaPlayer.this.drmCallback != null ? ExoMediaPlayer.this.drmCallback.executeKeyRequest(uuid, request) : new byte[]{};
        }
    }

    private class BufferRepeatListener
    implements Repeater.RepeatListener {
        private BufferRepeatListener() {
        }

        @Override
        public void onRepeat() {
            if (ExoMediaPlayer.this.bufferUpdateListener != null) {
                ExoMediaPlayer.this.bufferUpdateListener.onBufferingUpdate(ExoMediaPlayer.this.getBufferedPercentage());
            }
        }
    }

    private static class StateStore {
        public static final int FLAG_PLAY_WHEN_READY = -268435456;
        public static final int STATE_SEEKING = 100;
        private int[] prevStates = new int[]{1, 1, 1, 1};

        private StateStore() {
        }

        public void reset() {
            for (int i = 0; i < this.prevStates.length; ++i) {
                this.prevStates[i] = 1;
            }
        }

        public void setMostRecentState(boolean playWhenReady, int state) {
            int newState = this.getState(playWhenReady, state);
            if (this.prevStates[3] == newState) {
                return;
            }
            this.prevStates[0] = this.prevStates[1];
            this.prevStates[1] = this.prevStates[2];
            this.prevStates[2] = this.prevStates[3];
            this.prevStates[3] = state;
        }

        public int getState(boolean playWhenReady, int state) {
            return state | (playWhenReady ? -268435456 : 0);
        }

        public int getMostRecentState() {
            return this.prevStates[3];
        }

        public boolean isLastReportedPlayWhenReady() {
            return (this.prevStates[3] & 0xF0000000) != 0;
        }

        public boolean matchesHistory(@Size(min=1L, max=4L) int[] states, boolean ignorePlayWhenReady) {
            int startIndex;
            boolean flag = true;
            int andFlag = ignorePlayWhenReady ? 0xFFFFFFF : -1;
            for (int i = startIndex = this.prevStates.length - states.length; i < this.prevStates.length; ++i) {
                flag &= (this.prevStates[i] & andFlag) == (states[i - startIndex] & andFlag);
            }
            return flag;
        }
    }
}

