/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.api;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public interface AudioPlayerApi {
    public void setDataSource(@Nullable Uri var1);

    public void setDataSource(@Nullable Uri var1, @Nullable MediaSource var2);

    public void setDrmCallback(@Nullable MediaDrmCallback var1);

    public void prepareAsync();

    public boolean isPlaying();

    public void start();

    public void pause();

    public void stopPlayback();

    public boolean restart();

    public void release();

    public void reset();

    @IntRange(from=0L)
    public long getDuration();

    @IntRange(from=0L)
    public long getCurrentPosition();

    @IntRange(from=0L, to=100L)
    public int getBufferedPercent();

    @Nullable
    public WindowInfo getWindowInfo();

    public int getAudioSessionId();

    public boolean setPlaybackSpeed(float var1);

    public float getPlaybackSpeed();

    public void setAudioStreamType(int var1);

    public boolean trackSelectionAvailable();

    public void setTrack(@NonNull ExoMedia.RendererType var1, int var2);

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks();

    @FloatRange(from=0.0, to=1.0)
    public float getVolumeLeft();

    @FloatRange(from=0.0, to=1.0)
    public float getVolumeRight();

    public void setVolume(@FloatRange(from=0.0, to=1.0) float var1, @FloatRange(from=0.0, to=1.0) float var2);

    public void seekTo(@IntRange(from=0L) long var1);

    public void setWakeMode(@NonNull Context var1, int var2);

    public void setListenerMux(ListenerMux var1);

    public void onMediaPrepared();

    public void setRepeatMode(int var1);
}

