/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core;

import android.media.MediaPlayer;
import android.os.Handler;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.exception.NativeMediaPlaybackException;
import com.devbrackets.android.exomedia.core.exoplayer.ExoMediaPlayer;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.google.android.exoplayer2.metadata.Metadata;
import java.lang.ref.WeakReference;

public class ListenerMux
implements ExoPlayerListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
OnBufferUpdateListener,
MetadataListener {
    private static final long COMPLETED_DURATION_LEEWAY = 1000L;
    @NonNull
    private Handler delayedHandler = new Handler();
    @NonNull
    private Notifier muxNotifier;
    @Nullable
    private OnPreparedListener preparedListener;
    @Nullable
    private OnCompletionListener completionListener;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @Nullable
    private OnSeekCompletionListener seekCompletionListener;
    @Nullable
    private OnErrorListener errorListener;
    @Nullable
    private MetadataListener metadataListener;
    @NonNull
    private WeakReference<ClearableSurface> clearableSurfaceRef = new WeakReference<Object>(null);
    private boolean notifiedPrepared = false;
    private boolean notifiedCompleted = false;
    private boolean clearRequested = false;

    public ListenerMux(@NonNull Notifier notifier) {
        this.muxNotifier = notifier;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.onBufferingUpdate(percent);
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.completionListener != null) {
            this.completionListener.onCompletion();
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        return this.notifyErrorListener(new NativeMediaPlaybackException(what, extra));
    }

    public void onSeekComplete(MediaPlayer mp) {
        if (this.seekCompletionListener != null) {
            this.seekCompletionListener.onSeekComplete();
        }
    }

    public void onPrepared(MediaPlayer mp) {
        this.notifyPreparedListener();
    }

    @Override
    public void onError(ExoMediaPlayer exoMediaPlayer, Exception e) {
        this.muxNotifier.onMediaPlaybackEnded();
        this.muxNotifier.onExoPlayerError(exoMediaPlayer, e);
        this.notifyErrorListener(e);
    }

    @Override
    public void onStateChanged(boolean playWhenReady, int playbackState) {
        if (playbackState == 4) {
            this.muxNotifier.onMediaPlaybackEnded();
            if (!this.notifiedCompleted) {
                this.notifyCompletionListener();
            }
        } else if (playbackState == 3 && !this.notifiedPrepared) {
            this.notifyPreparedListener();
        }
        if (playbackState == 3 && playWhenReady) {
            this.muxNotifier.onPreviewImageStateChanged(false);
        }
        if (playbackState == 1 && this.clearRequested) {
            this.clearRequested = false;
            ClearableSurface clearableSurface = (ClearableSurface)this.clearableSurfaceRef.get();
            if (clearableSurface != null) {
                clearableSurface.clearSurface();
                this.clearableSurfaceRef = new WeakReference<Object>(null);
            }
        }
    }

    @Override
    public void onSeekComplete() {
        this.muxNotifier.onSeekComplete();
        if (this.seekCompletionListener != null) {
            this.seekCompletionListener.onSeekComplete();
        }
    }

    @Override
    public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
        this.muxNotifier.onBufferUpdated(percent);
        if (this.bufferUpdateListener != null) {
            this.bufferUpdateListener.onBufferingUpdate(percent);
        }
    }

    @Override
    public void onMetadata(Metadata metadata) {
        if (this.metadataListener != null) {
            this.metadataListener.onMetadata(metadata);
        }
    }

    @Override
    public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
        this.muxNotifier.onVideoSizeChanged(width, height, unAppliedRotationDegrees, pixelWidthHeightRatio);
    }

    public void clearSurfaceWhenReady(@Nullable ClearableSurface clearableSurface) {
        this.clearRequested = true;
        this.clearableSurfaceRef = new WeakReference<ClearableSurface>(clearableSurface);
    }

    public void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.preparedListener = listener;
    }

    public void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.completionListener = listener;
    }

    public void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
    }

    public void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.seekCompletionListener = listener;
    }

    public void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.errorListener = listener;
    }

    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.metadataListener = listener;
    }

    public void setNotifiedPrepared(boolean wasNotified) {
        this.notifiedPrepared = wasNotified;
        this.muxNotifier.onPreviewImageStateChanged(true);
    }

    public boolean isPrepared() {
        return this.notifiedPrepared;
    }

    public void setNotifiedCompleted(boolean wasNotified) {
        this.notifiedCompleted = wasNotified;
    }

    private boolean notifyErrorListener(Exception e) {
        return this.errorListener != null && this.errorListener.onError(e);
    }

    private void notifyPreparedListener() {
        this.notifiedPrepared = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                ListenerMux.this.performPreparedHandlerNotification();
            }
        });
    }

    private void performPreparedHandlerNotification() {
        this.muxNotifier.onPrepared();
        if (this.preparedListener != null) {
            this.preparedListener.onPrepared();
        }
    }

    private void notifyCompletionListener() {
        if (!this.muxNotifier.shouldNotifyCompletion(1000L)) {
            return;
        }
        this.notifiedCompleted = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ListenerMux.this.completionListener != null) {
                    ListenerMux.this.completionListener.onCompletion();
                }
            }
        });
    }

    public static abstract class Notifier {
        public void onSeekComplete() {
        }

        public void onBufferUpdated(int percent) {
        }

        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
        }

        public void onPrepared() {
        }

        public void onPreviewImageStateChanged(boolean toVisible) {
        }

        public abstract boolean shouldNotifyCompletion(long var1);

        public abstract void onExoPlayerError(ExoMediaPlayer var1, Exception var2);

        public abstract void onMediaPlaybackEnded();
    }
}

