/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.exo;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.video.ResizingTextureView;
import com.devbrackets.android.exomedia.core.video.exo.ExoVideoDelegate;
import com.devbrackets.android.exomedia.util.DrmProvider;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

@TargetApi(value=16)
public class ExoTextureVideoView
extends ResizingTextureView
implements VideoViewApi {
    protected ExoVideoDelegate delegate;

    public ExoTextureVideoView(Context context) {
        super(context);
        this.setup();
    }

    public ExoTextureVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public ExoTextureVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    public ExoTextureVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.delegate.setVideoUri(uri);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        this.delegate.setVideoUri(uri, renderBuilder);
    }

    @Override
    public void setDrmProvider(@Nullable DrmProvider drmProvider) {
        this.delegate.setDrmProvider(drmProvider);
    }

    @Override
    public boolean restart() {
        return this.delegate.restart();
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.delegate.setVolume(volume);
    }

    @Override
    public void seekTo(@IntRange(from=0L) int milliseconds) {
        this.delegate.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.delegate.isPlaying();
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public void stopPlayback() {
        this.delegate.stopPlayback();
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    @Override
    public int getDuration() {
        return this.delegate.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.delegate.getBufferedPercent();
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.delegate.trackSelectionAvailable();
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
        this.delegate.setTrack(trackType, trackIndex);
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.delegate.getAvailableTracks();
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.delegate.setListenerMux(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    public String getUserAgent() {
        return this.delegate.getUserAgent();
    }

    protected void setup() {
        this.delegate = new ExoVideoDelegate(this.getContext(), this);
        this.setSurfaceTextureListener(new EMExoVideoSurfaceTextureListener());
        this.updateVideoSize(0, 0);
    }

    protected class EMExoVideoSurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        protected EMExoVideoSurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            ExoTextureVideoView.this.delegate.onSurfaceReady(new Surface(surfaceTexture));
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            ExoTextureVideoView.this.delegate.onSurfaceDestroyed();
            surfaceTexture.release();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }
}

