/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.exo;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.video.ResizingSurfaceView;
import com.devbrackets.android.exomedia.core.video.exo.ExoVideoDelegate;
import com.devbrackets.android.exomedia.util.DrmProvider;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

@TargetApi(value=16)
public class ExoSurfaceVideoView
extends ResizingSurfaceView
implements VideoViewApi {
    protected ExoVideoDelegate delegate;

    public ExoSurfaceVideoView(Context context) {
        super(context);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.delegate.setVideoUri(uri);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.delegate.setVideoUri(uri, mediaSource);
    }

    @Override
    public void setDrmProvider(@Nullable DrmProvider drmProvider) {
        this.delegate.setDrmProvider(drmProvider);
    }

    @Override
    public boolean restart() {
        return this.delegate.restart();
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.delegate.setVolume(volume);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.delegate.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.delegate.isPlaying();
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public void stopPlayback() {
        this.delegate.stopPlayback();
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    @Override
    public long getDuration() {
        return this.delegate.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.delegate.getBufferedPercent();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.delegate.setPlaybackSpeed(speed);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.delegate.trackSelectionAvailable();
    }

    @Override
    public void setTrack(ExoMedia.RendererType trackType, int trackIndex) {
        this.delegate.setTrack(trackType, trackIndex);
    }

    @Override
    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.delegate.getAvailableTracks();
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public void setListenerMux(ListenerMux listenerMux) {
        this.delegate.setListenerMux(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    protected void setup() {
        this.delegate = new ExoVideoDelegate(this.getContext(), this);
        this.getHolder().addCallback((SurfaceHolder.Callback)new HolderCallback());
        this.updateVideoSize(0, 0);
    }

    protected class HolderCallback
    implements SurfaceHolder.Callback {
        protected HolderCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            ExoSurfaceVideoView.this.delegate.onSurfaceReady(holder.getSurface());
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            ExoSurfaceVideoView.this.delegate.onSurfaceDestroyed();
            holder.getSurface().release();
        }
    }
}

