/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.support.annotation.NonNull;
import com.devbrackets.android.exomedia.core.source.MediaSourceProvider;
import com.devbrackets.android.exomedia.core.source.builder.DashMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.HlsMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.SsMediaSourceBuilder;
import com.google.android.exoplayer2.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExoMedia {
    public static void registerRenderer(@NonNull RendererType type, @NonNull Class<? super Renderer> clazz) {
        Data.registeredRendererClasses.get((Object)type).add(clazz.getName());
    }

    public static void registerMediaSourceBuilder(@NonNull MediaSourceProvider.SourceTypeBuilder builder) {
        Data.sourceTypeBuilders.add(0, builder);
    }

    public static class Data {
        @NonNull
        public static final Map<RendererType, List<String>> registeredRendererClasses = new HashMap<RendererType, List<String>>();
        @NonNull
        public static final List<MediaSourceProvider.SourceTypeBuilder> sourceTypeBuilders = new ArrayList<MediaSourceProvider.SourceTypeBuilder>();

        private static void instantiateRendererClasses() {
            registeredRendererClasses.put(RendererType.AUDIO, new LinkedList());
            registeredRendererClasses.put(RendererType.VIDEO, new LinkedList());
            registeredRendererClasses.put(RendererType.CLOSED_CAPTION, new LinkedList());
            registeredRendererClasses.put(RendererType.METADATA, new LinkedList());
            List<String> audioClasses = registeredRendererClasses.get((Object)RendererType.AUDIO);
            audioClasses.add("com.google.android.exoplayer2.ext.opus.LibopusAudioRenderer");
            audioClasses.add("com.google.android.exoplayer2.ext.flac.LibflacAudioRenderer");
            audioClasses.add("com.google.android.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer");
            List<String> videoClasses = registeredRendererClasses.get((Object)RendererType.VIDEO);
            videoClasses.add("com.google.android.exoplayer2.ext.vp9.LibvpxVideoRenderer");
        }

        private static void instantiateSourceProviders() {
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new HlsMediaSourceBuilder(), ".m3u8", ".*m3u8.*"));
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new DashMediaSourceBuilder(), ".mpd", ".*mpd.*"));
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new SsMediaSourceBuilder(), ".ism", ".*ism.*"));
        }

        static {
            Data.instantiateRendererClasses();
            Data.instantiateSourceProviders();
        }
    }

    public static enum RendererType {
        AUDIO,
        VIDEO,
        CLOSED_CAPTION,
        METADATA;

    }
}

