/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.mp;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import java.io.IOException;
import java.util.Map;

public class NativeVideoDelegate {
    protected Map<String, String> headers;
    protected State currentState = State.IDLE;
    protected Context context;
    protected Callback callback;
    protected ClearableSurface clearableSurface;
    protected MediaPlayer mediaPlayer;
    protected boolean playRequested = false;
    protected long requestedSeek;
    protected int currentBufferPercent;
    protected ListenerMux listenerMux;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();
    @Nullable
    protected MediaPlayer.OnCompletionListener onCompletionListener;
    @Nullable
    protected MediaPlayer.OnPreparedListener onPreparedListener;
    @Nullable
    protected MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
    @Nullable
    protected MediaPlayer.OnSeekCompleteListener onSeekCompleteListener;
    @Nullable
    protected MediaPlayer.OnErrorListener onErrorListener;
    @Nullable
    protected MediaPlayer.OnInfoListener onInfoListener;

    public NativeVideoDelegate(@NonNull Context context, @NonNull Callback callback, @NonNull ClearableSurface clearableSurface) {
        this.context = context;
        this.callback = callback;
        this.clearableSurface = clearableSurface;
        this.initMediaPlayer();
        this.currentState = State.IDLE;
    }

    public void start() {
        if (this.isReady()) {
            this.mediaPlayer.start();
            this.currentState = State.PLAYING;
        }
        this.playRequested = true;
        this.listenerMux.setNotifiedCompleted(false);
    }

    public void pause() {
        if (this.isReady() && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
            this.currentState = State.PAUSED;
        }
        this.playRequested = false;
    }

    public long getDuration() {
        if (!this.listenerMux.isPrepared() || !this.isReady()) {
            return 0L;
        }
        return this.mediaPlayer.getDuration();
    }

    public long getCurrentPosition() {
        if (!this.listenerMux.isPrepared() || !this.isReady()) {
            return 0L;
        }
        return this.mediaPlayer.getCurrentPosition();
    }

    public void seekTo(long milliseconds) {
        if (this.isReady()) {
            this.mediaPlayer.seekTo((int)milliseconds);
            this.requestedSeek = 0L;
        } else {
            this.requestedSeek = milliseconds;
        }
    }

    public boolean isPlaying() {
        return this.isReady() && this.mediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mediaPlayer != null) {
            return this.currentBufferPercent;
        }
        return 0;
    }

    public boolean setPlaybackSpeed(float speed) {
        if (Build.VERSION.SDK_INT >= 23) {
            PlaybackParams params = new PlaybackParams();
            params.setSpeed(speed);
            this.mediaPlayer.setPlaybackParams(params);
            return true;
        }
        return false;
    }

    public void stopPlayback() {
        this.currentState = State.IDLE;
        if (this.isReady()) {
            try {
                this.mediaPlayer.stop();
            }
            catch (Exception e) {
                Log.d((String)"ContentValues", (String)"stopPlayback: error calling mediaPlayer.stop()", (Throwable)e);
            }
        }
        this.playRequested = false;
        this.listenerMux.clearSurfaceWhenReady(this.clearableSurface);
    }

    public void suspend() {
        this.currentState = State.IDLE;
        try {
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
        }
        catch (Exception e) {
            Log.d((String)"ContentValues", (String)"stopPlayback: error calling mediaPlayer.reset() or mediaPlayer.release()", (Throwable)e);
        }
        this.playRequested = false;
    }

    public boolean restart() {
        if (this.currentState != State.COMPLETED) {
            return false;
        }
        this.seekTo(0L);
        this.start();
        this.listenerMux.setNotifiedPrepared(false);
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    public void setVideoURI(Uri uri, @Nullable Map<String, String> headers) {
        this.headers = headers;
        this.requestedSeek = 0L;
        this.playRequested = false;
        this.openVideo(uri);
    }

    public void setListenerMux(ListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.setOnCompletionListener(listenerMux);
        this.setOnPreparedListener(listenerMux);
        this.setOnBufferingUpdateListener(listenerMux);
        this.setOnSeekCompleteListener(listenerMux);
        this.setOnErrorListener(listenerMux);
    }

    public void setOnPreparedListener(@Nullable MediaPlayer.OnPreparedListener listener) {
        this.onPreparedListener = listener;
    }

    public void setOnCompletionListener(@Nullable MediaPlayer.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(@Nullable MediaPlayer.OnBufferingUpdateListener listener) {
        this.onBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(@Nullable MediaPlayer.OnSeekCompleteListener listener) {
        this.onSeekCompleteListener = listener;
    }

    public void setOnErrorListener(@Nullable MediaPlayer.OnErrorListener listener) {
        this.onErrorListener = listener;
    }

    public void setOnInfoListener(@Nullable MediaPlayer.OnInfoListener listener) {
        this.onInfoListener = listener;
    }

    public void onSurfaceSizeChanged(int width, int height) {
        if (this.mediaPlayer == null || width <= 0 || height <= 0) {
            return;
        }
        if (this.requestedSeek != 0L) {
            this.seekTo(this.requestedSeek);
        }
        if (this.playRequested) {
            this.start();
        }
    }

    public void onSurfaceReady(Surface surface) {
        this.mediaPlayer.setSurface(surface);
        if (this.playRequested) {
            this.start();
        }
    }

    protected void initMediaPlayer() {
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.internalListeners);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.internalListeners);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.internalListeners);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.internalListeners);
        this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.internalListeners);
        this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.internalListeners);
        this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.internalListeners);
        this.mediaPlayer.setAudioStreamType(3);
        this.mediaPlayer.setScreenOnWhilePlaying(true);
    }

    protected boolean isReady() {
        return this.currentState != State.ERROR && this.currentState != State.IDLE && this.currentState != State.PREPARING;
    }

    protected void openVideo(@Nullable Uri uri) {
        if (uri == null) {
            return;
        }
        this.currentBufferPercent = 0;
        try {
            this.mediaPlayer.reset();
            this.mediaPlayer.setDataSource(this.context.getApplicationContext(), uri, this.headers);
            this.mediaPlayer.prepareAsync();
            this.currentState = State.PREPARING;
        }
        catch (IOException | IllegalArgumentException ex) {
            Log.w((String)"ContentValues", (String)("Unable to open content: " + uri), (Throwable)ex);
            this.currentState = State.ERROR;
            this.internalListeners.onError(this.mediaPlayer, 1, 0);
        }
    }

    public class InternalListeners
    implements MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnVideoSizeChangedListener {
        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            NativeVideoDelegate.this.currentBufferPercent = percent;
            if (NativeVideoDelegate.this.onBufferingUpdateListener != null) {
                NativeVideoDelegate.this.onBufferingUpdateListener.onBufferingUpdate(mp, percent);
            }
        }

        public void onCompletion(MediaPlayer mp) {
            NativeVideoDelegate.this.currentState = State.COMPLETED;
            if (NativeVideoDelegate.this.onCompletionListener != null) {
                NativeVideoDelegate.this.onCompletionListener.onCompletion(NativeVideoDelegate.this.mediaPlayer);
            }
        }

        public void onSeekComplete(MediaPlayer mp) {
            if (NativeVideoDelegate.this.onSeekCompleteListener != null) {
                NativeVideoDelegate.this.onSeekCompleteListener.onSeekComplete(mp);
            }
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            Log.d((String)"ContentValues", (String)("Error: " + what + "," + extra));
            NativeVideoDelegate.this.currentState = State.ERROR;
            return NativeVideoDelegate.this.onErrorListener == null || NativeVideoDelegate.this.onErrorListener.onError(NativeVideoDelegate.this.mediaPlayer, what, extra);
        }

        public void onPrepared(MediaPlayer mp) {
            NativeVideoDelegate.this.currentState = State.PREPARED;
            if (NativeVideoDelegate.this.onPreparedListener != null) {
                NativeVideoDelegate.this.onPreparedListener.onPrepared(NativeVideoDelegate.this.mediaPlayer);
            }
            NativeVideoDelegate.this.callback.videoSizeChanged(mp.getVideoWidth(), mp.getVideoHeight());
            if (NativeVideoDelegate.this.requestedSeek != 0L) {
                NativeVideoDelegate.this.seekTo(NativeVideoDelegate.this.requestedSeek);
            }
            if (NativeVideoDelegate.this.playRequested) {
                NativeVideoDelegate.this.start();
            }
        }

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            return NativeVideoDelegate.this.onInfoListener == null || NativeVideoDelegate.this.onInfoListener.onInfo(mp, what, extra);
        }

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            NativeVideoDelegate.this.callback.videoSizeChanged(mp.getVideoWidth(), mp.getVideoHeight());
        }
    }

    public static enum State {
        ERROR,
        IDLE,
        PREPARING,
        PREPARED,
        PLAYING,
        PAUSED,
        COMPLETED;

    }

    public static interface Callback {
        public void videoSizeChanged(int var1, int var2);
    }
}

