/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.mp;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.MediaController;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.video.ResizingTextureView;
import com.devbrackets.android.exomedia.core.video.mp.NativeVideoDelegate;
import com.devbrackets.android.exomedia.util.DrmProvider;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

public class NativeTextureVideoView
extends ResizingTextureView
implements MediaController.MediaPlayerControl,
NativeVideoDelegate.Callback,
VideoViewApi {
    protected View.OnTouchListener touchListener;
    protected NativeVideoDelegate delegate;

    public NativeTextureVideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public NativeTextureVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public NativeTextureVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public NativeTextureVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    @Override
    public void setDrmProvider(@Nullable DrmProvider drmProvider) {
    }

    @Override
    public void start() {
        this.delegate.start();
        this.requestFocus();
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public int getDuration() {
        return this.delegate.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    @Override
    public void seekTo(int msec) {
        this.delegate.seekTo(msec);
    }

    @Override
    public boolean isPlaying() {
        return this.delegate.isPlaying();
    }

    public int getBufferPercentage() {
        return this.delegate.getBufferPercentage();
    }

    public boolean canPause() {
        return this.delegate.canPause();
    }

    public boolean canSeekBackward() {
        return this.delegate.canSeekBackward();
    }

    public boolean canSeekForward() {
        return this.delegate.canSeekForward();
    }

    public int getAudioSessionId() {
        return this.delegate.getAudioSessionId();
    }

    @Override
    public void videoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean flag = false;
        if (this.touchListener != null) {
            flag = this.touchListener.onTouch((View)this, ev);
        }
        return flag || super.onTouchEvent(ev);
    }

    @Override
    public void setOnTouchListener(View.OnTouchListener listener) {
        this.touchListener = listener;
        super.setOnTouchListener(listener);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.setVideoUri(uri, null);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        this.setVideoURI(uri);
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return false;
    }

    @Override
    public int getBufferedPercent() {
        return this.getBufferPercentage();
    }

    @Override
    public boolean restart() {
        return this.delegate.restart();
    }

    @Override
    public void stopPlayback() {
        this.delegate.stopPlayback();
    }

    @Override
    public void release() {
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return null;
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.delegate.setListenerMux(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, @Nullable Map<String, String> headers) {
        this.delegate.setVideoURI(uri, headers);
        this.requestLayout();
        this.invalidate();
    }

    public void setOnPreparedListener(@Nullable MediaPlayer.OnPreparedListener listener) {
        this.delegate.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(@Nullable MediaPlayer.OnCompletionListener listener) {
        this.delegate.setOnCompletionListener(listener);
    }

    public void setOnBufferingUpdateListener(@Nullable MediaPlayer.OnBufferingUpdateListener listener) {
        this.delegate.setOnBufferingUpdateListener(listener);
    }

    public void setOnSeekCompleteListener(@Nullable MediaPlayer.OnSeekCompleteListener listener) {
        this.delegate.setOnSeekCompleteListener(listener);
    }

    public void setOnErrorListener(@Nullable MediaPlayer.OnErrorListener listener) {
        this.delegate.setOnErrorListener(listener);
    }

    public void setOnInfoListener(@Nullable MediaPlayer.OnInfoListener listener) {
        this.delegate.setOnInfoListener(listener);
    }

    protected void setup(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.delegate = new NativeVideoDelegate(context, this, this);
        this.setSurfaceTextureListener(new TextureVideoViewSurfaceListener());
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.updateVideoSize(0, 0);
    }

    protected class TextureVideoViewSurfaceListener
    implements TextureView.SurfaceTextureListener {
        protected TextureVideoViewSurfaceListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            NativeTextureVideoView.this.delegate.onSurfaceReady(new Surface(surfaceTexture));
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            NativeTextureVideoView.this.delegate.onSurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            surface.release();
            NativeTextureVideoView.this.suspend();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    }
}

