/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.MediaPlayerApi;
import com.devbrackets.android.exomedia.core.builder.DashRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.HlsRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.builder.SmoothStreamRenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.listener.Id3MetadataListener;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.type.MediaSourceType;
import com.devbrackets.android.exomedia.util.MediaSourceUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import java.util.List;
import java.util.Map;

@TargetApi(value=16)
public class ExoMediaPlayer
implements MediaPlayerApi {
    protected static final String USER_AGENT_FORMAT = "EMAudioPlayer %s / Android %s / %s";
    protected EMExoPlayer emExoPlayer;
    protected Context context;
    protected EMListenerMux listenerMux;
    protected boolean playRequested = false;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();
    protected int audioStreamType = 3;

    public ExoMediaPlayer(@NonNull Context context) {
        this.context = context;
        this.emExoPlayer = new EMExoPlayer(null);
        this.emExoPlayer.setMetadataListener(this.internalListeners);
        this.emExoPlayer.setBufferUpdateListener(this.internalListeners);
    }

    @Override
    public void setDataSource(@NonNull Context context, @Nullable Uri uri) {
        RenderBuilder builder = uri == null ? null : this.getRendererBuilder(MediaSourceUtil.getType(uri), uri);
        this.setDataSource(context, uri, builder);
    }

    @Override
    public void setDataSource(Context context, @Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        if (uri == null) {
            this.emExoPlayer.replaceRenderBuilder(null);
        } else {
            this.emExoPlayer.replaceRenderBuilder(renderBuilder);
            this.listenerMux.setNotifiedCompleted(false);
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.emExoPlayer.seekTo(0L);
    }

    @Override
    public void prepareAsync() {
        this.emExoPlayer.prepare();
    }

    @Override
    public void reset() {
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float left, @FloatRange(from=0.0, to=1.0) float right) {
        this.emExoPlayer.setVolume((left + right) / 2.0f);
    }

    @Override
    public void seekTo(@IntRange(from=0L) int milliseconds) {
        this.emExoPlayer.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.emExoPlayer.getPlayWhenReady();
    }

    @Override
    public void start() {
        this.emExoPlayer.setPlayWhenReady(true);
        this.listenerMux.setNotifiedCompleted(false);
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.emExoPlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stopPlayback() {
        this.emExoPlayer.stop();
        this.playRequested = false;
    }

    @Override
    public boolean restart() {
        if (!this.emExoPlayer.restart()) {
            return false;
        }
        this.listenerMux.setNotifiedCompleted(false);
        this.listenerMux.setNotifiedPrepared(false);
        return true;
    }

    @Override
    public int getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.emExoPlayer.getBufferedPercentage();
    }

    @Override
    public void release() {
        this.emExoPlayer.release();
    }

    @Override
    public int getAudioSessionId() {
        return this.emExoPlayer.getAudioSessionId();
    }

    @Override
    public void setAudioStreamType(int streamType) {
        this.audioStreamType = streamType;
    }

    @Override
    public void setWakeMode(Context context, int mode) {
        this.emExoPlayer.setWakeMode(context, mode);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
        this.emExoPlayer.setSelectedTrack(trackType, trackIndex);
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.emExoPlayer.getAvailableTracks();
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.emExoPlayer.addListener(listenerMux);
    }

    @Override
    public void onMediaPrepared() {
    }

    protected RenderBuilder getRendererBuilder(@NonNull MediaSourceType renderType, @NonNull Uri uri) {
        switch (renderType) {
            case HLS: {
                return new HlsRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.audioStreamType);
            }
            case DASH: {
                return new DashRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.audioStreamType);
            }
            case SMOOTH_STREAM: {
                return new SmoothStreamRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.audioStreamType);
            }
        }
        return new RenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.audioStreamType);
    }

    protected String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, "3.0.4 (30400)", Build.VERSION.RELEASE, Build.MODEL);
    }

    protected class InternalListeners
    implements Id3MetadataListener,
    OnBufferUpdateListener {
        protected InternalListeners() {
        }

        @Override
        public void onId3Metadata(List<Id3Frame> metadata) {
            ExoMediaPlayer.this.listenerMux.onId3Metadata(metadata);
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            ExoMediaPlayer.this.listenerMux.onBufferingUpdate(percent);
        }
    }
}

