/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.type.MediaSourceType;

public class MediaSourceUtil {
    @NonNull
    public static MediaSourceType getType(@NonNull Uri uri) {
        String extension = MediaSourceUtil.getExtension(uri);
        if (extension != null) {
            return MediaSourceType.getByExtension(extension);
        }
        return MediaSourceType.getByLooseComparison(uri);
    }

    @Nullable
    public static String getExtension(@NonNull Uri uri) {
        String path = uri.getLastPathSegment();
        int periodIndex = path.lastIndexOf(46);
        if (periodIndex == -1 && uri.getPathSegments().size() > 1) {
            path = (String)uri.getPathSegments().get(uri.getPathSegments().size() - 2);
            periodIndex = path.lastIndexOf(46);
        }
        if (periodIndex == -1) {
            periodIndex = 0;
            path = "." + uri.getLastPathSegment();
        }
        String rawExtension = path.substring(periodIndex);
        return rawExtension.toLowerCase();
    }
}

