/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.ui.widget.VideoControls;
import com.devbrackets.android.exomedia.ui.widget.VideoControlsLeanback;
import com.devbrackets.android.exomedia.ui.widget.VideoControlsMobile;
import com.devbrackets.android.exomedia.util.DeviceUtil;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.StopWatch;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

public class EMVideoView
extends RelativeLayout {
    private static final String TAG = EMVideoView.class.getSimpleName();
    @Nullable
    protected VideoControls videoControls;
    protected ImageView previewImageView;
    protected Uri videoUri;
    protected VideoViewApi videoViewImpl;
    protected Repeater pollRepeater = new Repeater();
    protected DeviceUtil deviceUtil = new DeviceUtil();
    protected int positionOffset = 0;
    protected int overriddenDuration = -1;
    protected boolean overridePosition = false;
    protected StopWatch overriddenPositionStopWatch = new StopWatch();
    protected MuxNotifier muxNotifier = new MuxNotifier();
    protected EMListenerMux listenerMux;
    protected boolean releaseOnDetachFromWindow = true;

    public EMVideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public EMVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    @TargetApi(value=11)
    public EMVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public EMVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode() && this.releaseOnDetachFromWindow) {
            this.release();
        }
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.videoViewImpl.setOnTouchListener(listener);
        super.setOnTouchListener(listener);
    }

    public void setReleaseOnDetachFromWindow(boolean releaseOnDetach) {
        this.releaseOnDetachFromWindow = releaseOnDetach;
    }

    public void release() {
        this.videoControls = null;
        this.stopPlayback();
        this.overriddenPositionStopWatch.stop();
        this.videoViewImpl.release();
    }

    public void setPreviewImage(@Nullable Drawable drawable2) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageDrawable(drawable2);
        }
    }

    public void setPreviewImage(@DrawableRes int resourceId) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageResource(resourceId);
        }
    }

    public void setPreviewImage(@Nullable Bitmap bitmap) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageBitmap(bitmap);
        }
    }

    public void setPreviewImage(@Nullable Uri uri) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageURI(uri);
        }
    }

    public ImageView getPreviewImageView() {
        return this.previewImageView;
    }

    public void setControls(@Nullable VideoControls controls) {
        if (this.videoControls != null && this.videoControls != controls) {
            this.removeView((View)this.videoControls);
        }
        if (controls != null) {
            this.videoControls = controls;
            controls.setVideoView(this);
            this.addView((View)controls);
        }
        TouchListener listener = new TouchListener(this.getContext());
        this.setOnTouchListener(this.videoControls != null ? listener : null);
    }

    public void showControls() {
        if (this.videoControls != null) {
            this.videoControls.show();
            if (this.isPlaying()) {
                this.videoControls.hideDelayed(2000L);
            }
        }
    }

    @Nullable
    public VideoControls getVideoControls() {
        return this.videoControls;
    }

    public void setVideoURI(@Nullable Uri uri) {
        this.videoUri = uri;
        this.videoViewImpl.setVideoUri(uri);
        if (this.videoControls != null) {
            this.videoControls.showLoading(true);
        }
    }

    public void setVideoURI(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        this.videoUri = uri;
        this.videoViewImpl.setVideoUri(uri, renderBuilder);
        if (this.videoControls != null) {
            this.videoControls.showLoading(true);
        }
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    @Nullable
    public Uri getVideoUri() {
        return this.videoUri;
    }

    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.videoViewImpl.setVolume(volume);
    }

    public void reset() {
        this.stopPlayback();
        this.setVideoURI(null);
    }

    public void seekTo(int milliSeconds) {
        if (this.videoControls != null) {
            this.videoControls.showLoading(false);
        }
        this.videoViewImpl.seekTo(milliSeconds);
    }

    public boolean isPlaying() {
        return this.videoViewImpl.isPlaying();
    }

    public void start() {
        this.videoViewImpl.start();
        this.setKeepScreenOn(true);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(true);
        }
    }

    public void pause() {
        this.videoViewImpl.pause();
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    public void stopPlayback() {
        this.videoViewImpl.stopPlayback();
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    public boolean restart() {
        if (this.videoUri == null) {
            return false;
        }
        if (this.videoViewImpl.restart()) {
            if (this.videoControls != null) {
                this.videoControls.showLoading(true);
            }
            return true;
        }
        return false;
    }

    public void suspend() {
        this.videoViewImpl.suspend();
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    public int getDuration() {
        if (this.overriddenDuration >= 0) {
            return this.overriddenDuration;
        }
        return this.videoViewImpl.getDuration();
    }

    public void overrideDuration(int duration) {
        this.overriddenDuration = duration;
    }

    public int getCurrentPosition() {
        if (this.overridePosition) {
            return this.positionOffset + this.overriddenPositionStopWatch.getTimeInt();
        }
        return this.positionOffset + this.videoViewImpl.getCurrentPosition();
    }

    public void setPositionOffset(int offset) {
        this.positionOffset = offset;
    }

    public void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public int getBufferPercentage() {
        return this.videoViewImpl.getBufferedPercent();
    }

    public boolean trackSelectionAvailable() {
        return this.videoViewImpl.trackSelectionAvailable();
    }

    public void setTrack(int trackType, int trackIndex) {
        this.videoViewImpl.setTrack(trackType, trackIndex);
    }

    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.videoViewImpl.getAvailableTracks();
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        this.videoViewImpl.setScaleType(scaleType);
    }

    public void setMeasureBasedOnAspectRatioEnabled(boolean measureBasedOnAspectRatioEnabled) {
        this.videoViewImpl.setMeasureBasedOnAspectRatioEnabled(measureBasedOnAspectRatioEnabled);
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation) {
        this.videoViewImpl.setVideoRotation(rotation, true);
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnBufferUpdateListener(OnBufferUpdateListener listener) {
        this.listenerMux.setOnBufferUpdateListener(listener);
    }

    public void setOnSeekCompletionListener(OnSeekCompletionListener listener) {
        this.listenerMux.setOnSeekCompletionListener(listener);
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    protected void setup(Context context, @Nullable AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        this.initView(context, attrs);
        this.readAttributes(context, attrs);
    }

    protected void readAttributes(Context context, @Nullable AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EMVideoView);
        if (typedArray == null) {
            return;
        }
        boolean useDefaultControls = typedArray.getBoolean(R.styleable.EMVideoView_useDefaultControls, false);
        if (useDefaultControls) {
            this.setControls(this.deviceUtil.isDeviceTV(this.getContext()) ? new VideoControlsLeanback(this.getContext()) : new VideoControlsMobile(this.getContext()));
        }
        typedArray.recycle();
    }

    protected void initView(Context context, @Nullable AttributeSet attrs) {
        this.inflateVideoView(context, attrs);
        this.previewImageView = (ImageView)this.findViewById(R.id.exomedia_video_preview_image);
        this.videoViewImpl = (VideoViewApi)this.findViewById(R.id.exomedia_video_view);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux = new EMListenerMux(this.muxNotifier);
        this.videoViewImpl.setListenerMux(this.listenerMux);
    }

    protected void inflateVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        View.inflate((Context)context, (int)R.layout.exomedia_video_view_layout, (ViewGroup)this);
        ViewStub videoViewStub = (ViewStub)this.findViewById(R.id.video_view_api_impl_stub);
        videoViewStub.setLayoutResource(this.getVideoViewApiImplementation(context, attrs));
        videoViewStub.inflate();
    }

    @LayoutRes
    protected int getVideoViewApiImplementation(@NonNull Context context, @Nullable AttributeSet attrs) {
        int defaultVideoViewApiImplRes;
        boolean useLegacy = !this.deviceUtil.supportsExoPlayer(context);
        int n = defaultVideoViewApiImplRes = useLegacy ? R.layout.exomedia_default_native_video_view : R.layout.exomedia_default_exo_video_view;
        if (attrs == null) {
            return defaultVideoViewApiImplRes;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EMVideoView);
        if (typedArray == null) {
            return defaultVideoViewApiImplRes;
        }
        int styleableRes = useLegacy ? R.styleable.EMVideoView_videoViewApiImplLegacy : R.styleable.EMVideoView_videoViewApiImpl;
        int videoViewApiImplRes = typedArray.getResourceId(styleableRes, defaultVideoViewApiImplRes);
        typedArray.recycle();
        return videoViewApiImplRes;
    }

    protected void onPlaybackEnded() {
        this.stopPlayback();
        this.pollRepeater.stop();
    }

    protected class TouchListener
    extends GestureDetector.SimpleOnGestureListener
    implements View.OnTouchListener {
        protected GestureDetector gestureDetector;

        public TouchListener(Context context) {
            this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        }

        public boolean onTouch(View v, MotionEvent event) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (EMVideoView.this.videoControls != null) {
                EMVideoView.this.videoControls.show();
                if (EMVideoView.this.isPlaying()) {
                    EMVideoView.this.videoControls.hideDelayed(2000L);
                }
            }
            return true;
        }
    }

    protected class MuxNotifier
    extends EMListenerMux.EMListenerMuxNotifier {
        protected MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            return (long)EMVideoView.this.getCurrentPosition() + endLeeway >= (long)EMVideoView.this.getDuration();
        }

        @Override
        public void onExoPlayerError(EMExoPlayer emExoPlayer, Exception e) {
            EMVideoView.this.stopPlayback();
            if (emExoPlayer != null) {
                emExoPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            EMVideoView.this.setKeepScreenOn(false);
            EMVideoView.this.onPlaybackEnded();
        }

        @Override
        public void onSeekComplete() {
            if (EMVideoView.this.videoControls != null) {
                EMVideoView.this.videoControls.finishLoading();
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
            EMVideoView.this.videoViewImpl.setVideoRotation(unAppliedRotationDegrees, false);
            EMVideoView.this.videoViewImpl.onVideoSizeChanged(width, height);
        }

        @Override
        public void onPrepared() {
            if (EMVideoView.this.videoControls != null) {
                EMVideoView.this.videoControls.setDuration(EMVideoView.this.getDuration());
                EMVideoView.this.videoControls.finishLoading();
            }
        }

        @Override
        public void onPreviewImageStateChanged(boolean toVisible) {
            if (EMVideoView.this.previewImageView != null) {
                EMVideoView.this.previewImageView.setVisibility(toVisible ? 0 : 8);
            }
        }
    }
}

