/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.renderer.EMMediaCodecAudioTrackRenderer;
import com.devbrackets.android.exomedia.util.MediaUtil;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorSampleSource;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;

@TargetApi(value=16)
public class RenderBuilder {
    protected static final int DROPPED_FRAME_NOTIFICATION_AMOUNT = 50;
    protected static final long MAX_JOIN_TIME = 5000L;
    protected static final int BUFFER_SEGMENT_SIZE = 65536;
    protected static final int BUFFER_SEGMENTS_VIDEO = 200;
    protected static final int BUFFER_SEGMENTS_AUDIO = 54;
    protected static final int BUFFER_SEGMENTS_TEXT = 2;
    protected static final int BUFFER_SEGMENTS_TOTAL = 256;
    protected final Context context;
    protected final String userAgent;
    protected final String uri;
    protected final int streamType;

    public RenderBuilder(Context context, String userAgent, String uri) {
        this(context, userAgent, uri, 3);
    }

    public RenderBuilder(Context context, String userAgent, String uri, int streamType) {
        this.uri = uri;
        this.userAgent = userAgent;
        this.context = context;
        this.streamType = streamType;
    }

    public Context getContext() {
        return this.context;
    }

    public void buildRenderers(EMExoPlayer player) {
        DefaultAllocator allocator = new DefaultAllocator(65536);
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(player.getMainHandler(), (BandwidthMeter.EventListener)player);
        DataSource dataSource = this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
        ExtractorSampleSource sampleSource = new ExtractorSampleSource(Uri.parse((String)MediaUtil.getUriWithProtocol(this.uri)), dataSource, (Allocator)allocator, 0x1000000, player.getMainHandler(), (ExtractorSampleSource.EventListener)player, 0, new Extractor[0]);
        MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSource, MediaCodecSelector.DEFAULT, 1, 5000L, player.getMainHandler(), (MediaCodecVideoTrackRenderer.EventListener)player, 50);
        EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer((SampleSource)sampleSource, MediaCodecSelector.DEFAULT, null, true, player.getMainHandler(), (MediaCodecAudioTrackRenderer.EventListener)player, AudioCapabilities.getCapabilities((Context)this.context), this.streamType);
        TextTrackRenderer captionsRenderer = new TextTrackRenderer((SampleSource)sampleSource, (TextRenderer)player, player.getMainHandler().getLooper(), new SubtitleParser[0]);
        TrackRenderer[] renderers = new TrackRenderer[4];
        renderers[0] = videoRenderer;
        renderers[1] = audioRenderer;
        renderers[2] = captionsRenderer;
        player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
    }

    public void cancel() {
    }

    protected DataSource createDataSource(Context context, TransferListener transferListener, String userAgent) {
        return new DefaultUriDataSource(context, transferListener, userAgent, true);
    }
}

