/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.audio;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.MediaPlayerApi;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

public class NativeMediaPlayer
extends MediaPlayer
implements MediaPlayerApi,
MediaPlayer.OnBufferingUpdateListener {
    private static final String TAG = "NativeMediaPlayer";
    protected int currentBufferPercent = 0;
    protected EMListenerMux listenerMux;
    protected int requestedSeek;

    public NativeMediaPlayer(Context context) {
        this.setOnBufferingUpdateListener(this);
    }

    @Override
    public void setDataSource(Context context, Uri uri) {
        this.setDataSource(context, uri, null);
    }

    @Override
    public void setDataSource(Context context, Uri uri, RenderBuilder renderBuilder) {
        try {
            this.requestedSeek = 0;
            super.setDataSource(context, uri);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"MediaPlayer: error setting data source", (Throwable)e);
        }
    }

    public void prepare() {
        try {
            super.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.listenerMux != null) {
            this.listenerMux.setNotifiedCompleted(false);
        }
    }

    @Override
    public void stopPlayback() {
        this.stop();
    }

    @Override
    public boolean restart() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return false;
        }
        super.seekTo(0);
        super.start();
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    @Override
    public int getDuration() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return 0;
        }
        return super.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return 0;
        }
        return super.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.currentBufferPercent;
    }

    @Override
    public void seekTo(int msec) {
        if (this.listenerMux != null && this.listenerMux.isPrepared()) {
            super.seekTo(msec);
            this.requestedSeek = 0;
        } else {
            this.requestedSeek = msec;
        }
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return null;
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.setOnCompletionListener(listenerMux);
        this.setOnPreparedListener(listenerMux);
        this.setOnBufferingUpdateListener(listenerMux);
        this.setOnSeekCompleteListener(listenerMux);
        this.setOnErrorListener(listenerMux);
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.currentBufferPercent = percent;
    }

    @Override
    public void onMediaPrepared() {
        if (this.requestedSeek != 0) {
            this.seekTo(this.requestedSeek);
        }
    }
}

