/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.util.EMResourceUtil;
import com.devbrackets.android.exomedia.util.TimeFormatUtil;
import com.devbrackets.android.exomedia.widget.DefaultControls;

@TargetApi(value=21)
public class DefaultControlsLeanback
extends DefaultControls {
    private static final int FAST_FORWARD_REWIND_AMOUNT = 10000;
    private ProgressBar progressBar;
    private ImageView rippleIndicator;
    private ImageButton fastForwardButton;
    private ImageButton rewindButton;
    private Drawable defaultRewindDrawable;
    private Drawable defaultFastForwardDrawable;
    private View currentFocus;
    private ButtonFocusChangeListener buttonFocusChangeListener = new ButtonFocusChangeListener();

    public DefaultControlsLeanback(Context context) {
        super(context);
    }

    public DefaultControlsLeanback(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DefaultControlsLeanback(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public DefaultControlsLeanback(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void setup(Context context) {
        super.setup(context);
        this.registerForInput();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.playPauseButton.requestFocus();
        this.currentFocus = this.playPauseButton;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_video_controls_overlay_leanback;
    }

    @Override
    public void setPosition(long position) {
        this.currentTime.setText((CharSequence)TimeFormatUtil.formatMs(position));
        this.progressBar.setProgress((int)position);
    }

    @Override
    public void setDuration(long duration) {
        if (duration != (long)this.progressBar.getMax()) {
            this.endTime.setText((CharSequence)TimeFormatUtil.formatMs(duration));
            this.progressBar.setMax((int)duration);
        }
    }

    @Override
    public void setProgressEvent(EMMediaProgressEvent event) {
        this.progressBar.setSecondaryProgress((int)((float)this.progressBar.getMax() * event.getBufferPercentFloat()));
        this.progressBar.setProgress((int)event.getPosition());
        this.currentTime.setText((CharSequence)TimeFormatUtil.formatMs(event.getPosition()));
    }

    @Override
    public void setRewindImageResource(@DrawableRes int resourceId) {
        if (this.rewindButton == null) {
            return;
        }
        if (resourceId != 0) {
            this.rewindButton.setImageResource(resourceId);
        } else {
            this.rewindButton.setImageDrawable(this.defaultRewindDrawable);
        }
    }

    @Override
    public void setFastForwardImageResource(@DrawableRes int resourceId) {
        if (this.fastForwardButton == null) {
            return;
        }
        if (resourceId != 0) {
            this.fastForwardButton.setImageResource(resourceId);
        } else {
            this.fastForwardButton.setImageDrawable(this.defaultFastForwardDrawable);
        }
    }

    @Override
    public void setRewindButtonEnabled(boolean enabled) {
        if (this.rewindButton != null) {
            this.rewindButton.setEnabled(enabled);
        }
    }

    @Override
    public void setFastForwardButtonEnabled(boolean enabled) {
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setEnabled(enabled);
        }
    }

    @Override
    public void setRewindButtonRemoved(boolean removed) {
        if (this.rewindButton != null) {
            this.rewindButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    public void setFastForwardButtonRemoved(boolean removed) {
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setVisibility(removed ? 8 : 0);
        }
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        this.progressBar = (ProgressBar)this.findViewById(R.id.exomedia_controls_video_progress);
        this.rewindButton = (ImageButton)this.findViewById(R.id.exomedia_controls_rewind_btn);
        this.fastForwardButton = (ImageButton)this.findViewById(R.id.exomedia_controls_fast_forward_btn);
        this.rippleIndicator = (ImageView)this.findViewById(R.id.exomedia_controls_leanback_ripple);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.rewindButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultControlsLeanback.this.onRewindClick();
            }
        });
        this.fastForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultControlsLeanback.this.onFastForwardClick();
            }
        });
        this.previousButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.rewindButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.playPauseButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.fastForwardButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
        this.nextButton.setOnFocusChangeListener((View.OnFocusChangeListener)this.buttonFocusChangeListener);
    }

    @Override
    protected void updateButtonDrawables() {
        super.updateButtonDrawables();
        this.defaultRewindDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_rewind_white, R.color.exomedia_default_controls_button_selector);
        this.rewindButton.setImageDrawable(this.defaultRewindDrawable);
        this.defaultFastForwardDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_fast_forward_white, R.color.exomedia_default_controls_button_selector);
        this.fastForwardButton.setImageDrawable(this.defaultFastForwardDrawable);
    }

    private void onRewindClick() {
        int newPosition = (int)this.videoView.getCurrentPosition() - 10000;
        if (newPosition < 0) {
            newPosition = 0;
        }
        this.performSeek(newPosition);
    }

    private void onFastForwardClick() {
        int newPosition = (int)this.videoView.getCurrentPosition() + 10000;
        if (newPosition > this.progressBar.getMax()) {
            newPosition = this.progressBar.getMax();
        }
        this.performSeek(newPosition);
    }

    private void performSeek(int seekToTime) {
        if (this.seekCallbacks != null && this.seekCallbacks.onSeekEnded(seekToTime)) {
            return;
        }
        this.videoView.seekTo(seekToTime);
    }

    private void showTemporary() {
        this.show();
        if (this.videoView.isPlaying()) {
            this.hideDelayed(2000L);
        }
    }

    private void registerForInput() {
        RemoteKeyListener remoteKeyListener = new RemoteKeyListener();
        this.setOnKeyListener(remoteKeyListener);
        this.playPauseButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.previousButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.nextButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.rewindButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
        this.fastForwardButton.setOnKeyListener((View.OnKeyListener)remoteKeyListener);
    }

    private void focusNext(View view) {
        int nextId = view.getNextFocusRightId();
        if (nextId == -1) {
            return;
        }
        View nextView = this.findViewById(nextId);
        if (nextView.getVisibility() != 0) {
            this.focusNext(nextView);
            return;
        }
        nextView.requestFocus();
        this.currentFocus = nextView;
        this.buttonFocusChangeListener.onFocusChange(nextView, true);
    }

    private void focusPrevious(View view) {
        int previousId = view.getNextFocusLeftId();
        if (previousId == -1) {
            return;
        }
        View previousView = this.findViewById(previousId);
        if (previousView.getVisibility() != 0) {
            this.focusPrevious(previousView);
            return;
        }
        previousView.requestFocus();
        this.currentFocus = previousView;
        this.buttonFocusChangeListener.onFocusChange(previousView, true);
    }

    private class RippleTranslateAnimation
    extends TranslateAnimation
    implements Animation.AnimationListener {
        private static final long DURATION = 250L;
        private int xDelta;

        public RippleTranslateAnimation(int xDelta) {
            super(0.0f, (float)xDelta, 0.0f, 0.0f);
            this.xDelta = xDelta;
            this.setDuration(250L);
            this.setAnimationListener(this);
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            DefaultControlsLeanback.this.rippleIndicator.setX(DefaultControlsLeanback.this.rippleIndicator.getX() + (float)this.xDelta);
            DefaultControlsLeanback.this.rippleIndicator.clearAnimation();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    private class RemoteKeyListener
    implements View.OnKeyListener {
        private RemoteKeyListener() {
        }

        public boolean onKey(View view, int keyCode, KeyEvent event) {
            if (event.getAction() != 0) {
                return false;
            }
            switch (keyCode) {
                case 4: {
                    if (!DefaultControlsLeanback.this.isVisible) break;
                    DefaultControlsLeanback.this.hideDelayed(0L);
                    return true;
                }
                case 19: {
                    DefaultControlsLeanback.this.showTemporary();
                    return true;
                }
                case 20: {
                    DefaultControlsLeanback.this.hideDelayed(0L);
                    return true;
                }
                case 21: {
                    DefaultControlsLeanback.this.showTemporary();
                    DefaultControlsLeanback.this.focusPrevious(DefaultControlsLeanback.this.currentFocus);
                    return true;
                }
                case 22: {
                    DefaultControlsLeanback.this.showTemporary();
                    DefaultControlsLeanback.this.focusNext(DefaultControlsLeanback.this.currentFocus);
                    return true;
                }
                case 23: {
                    DefaultControlsLeanback.this.showTemporary();
                    DefaultControlsLeanback.this.currentFocus.callOnClick();
                    return true;
                }
                case 85: {
                    DefaultControlsLeanback.this.onPlayPauseClick();
                    return true;
                }
                case 126: {
                    if (DefaultControlsLeanback.this.videoView.isPlaying()) break;
                    DefaultControlsLeanback.this.videoView.start();
                    return true;
                }
                case 127: {
                    if (!DefaultControlsLeanback.this.videoView.isPlaying()) break;
                    DefaultControlsLeanback.this.videoView.pause();
                    return true;
                }
                case 87: {
                    DefaultControlsLeanback.this.onNextClick();
                    return true;
                }
                case 88: {
                    DefaultControlsLeanback.this.onPreviousClick();
                    return true;
                }
                case 89: {
                    DefaultControlsLeanback.this.onRewindClick();
                    return true;
                }
                case 90: {
                    DefaultControlsLeanback.this.onFastForwardClick();
                    return true;
                }
            }
            return false;
        }
    }

    private class ButtonFocusChangeListener
    implements View.OnFocusChangeListener {
        private ButtonFocusChangeListener() {
        }

        public void onFocusChange(View view, boolean hasFocus) {
            if (!hasFocus) {
                return;
            }
            int xDelta = this.getHorizontalDelta(view);
            DefaultControlsLeanback.this.rippleIndicator.startAnimation((Animation)new RippleTranslateAnimation(xDelta));
        }

        private int getHorizontalDelta(View selectedView) {
            int[] position = new int[2];
            selectedView.getLocationOnScreen(position);
            int viewX = position[0];
            DefaultControlsLeanback.this.rippleIndicator.getLocationOnScreen(position);
            int newRippleX = viewX - (DefaultControlsLeanback.this.rippleIndicator.getWidth() - selectedView.getWidth()) / 2;
            return newRippleX - position[0];
        }
    }
}

