/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.event.EMAudioFocusGainedEvent;
import com.devbrackets.android.exomedia.event.EMAudioFocusLostEvent;
import com.devbrackets.android.exomedia.listener.EMAudioFocusCallback;
import com.devbrackets.android.exomedia.util.EMEventBus;

public class EMAudioFocusHelper {
    @Nullable
    private EMEventBus bus;
    private AudioManager audioManager;
    private EMAudioFocusCallback callbacks;
    private AudioFocusListener audioFocusListener = new AudioFocusListener();
    private Focus currentFocus = Focus.NONE;

    public EMAudioFocusHelper(Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    public void setBus(@Nullable EMEventBus bus) {
        this.bus = bus;
    }

    public void setAudioFocusCallback(@Nullable EMAudioFocusCallback callback) {
        this.callbacks = callback;
    }

    public Focus getCurrentAudioFocus() {
        return this.currentFocus;
    }

    public boolean requestFocus() {
        if (this.currentFocus == Focus.FOCUSED) {
            return true;
        }
        int status = this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this.audioFocusListener, 3, 1);
        return 1 == status;
    }

    public boolean abandonFocus() {
        if (this.currentFocus == Focus.NONE) {
            return true;
        }
        int status = this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.audioFocusListener);
        if (1 == status) {
            this.currentFocus = Focus.NONE;
        }
        return 1 == status;
    }

    private class AudioFocusListener
    implements AudioManager.OnAudioFocusChangeListener {
        private AudioFocusListener() {
        }

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    EMAudioFocusHelper.this.currentFocus = Focus.FOCUSED;
                    this.postAudioFocusGained();
                    break;
                }
                case -2: 
                case -1: {
                    EMAudioFocusHelper.this.currentFocus = Focus.NO_FOCUS_NO_DUCK;
                    this.postAudioFocusLost(false);
                    break;
                }
                case -3: {
                    EMAudioFocusHelper.this.currentFocus = Focus.NO_FOCUS_CAN_DUCK;
                    this.postAudioFocusLost(true);
                    break;
                }
            }
        }

        private void postAudioFocusGained() {
            if (EMAudioFocusHelper.this.callbacks != null && EMAudioFocusHelper.this.callbacks.onAudioFocusGained()) {
                return;
            }
            if (EMAudioFocusHelper.this.bus != null) {
                EMAudioFocusHelper.this.bus.post(new EMAudioFocusGainedEvent());
            }
        }

        private void postAudioFocusLost(boolean canDuck) {
            if (EMAudioFocusHelper.this.callbacks != null && EMAudioFocusHelper.this.callbacks.onAudioFocusLost(canDuck)) {
                return;
            }
            if (EMAudioFocusHelper.this.bus != null) {
                EMAudioFocusHelper.this.bus.post(new EMAudioFocusLostEvent(canDuck));
            }
        }
    }

    public static enum Focus {
        NONE,
        NO_FOCUS_NO_DUCK,
        NO_FOCUS_CAN_DUCK,
        FOCUSED;

    }
}

