/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.receiver;

import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.KeyEvent;

public class MediaControlsReceiver
extends BroadcastReceiver {
    private static final String TAG = "MediaControlsReceiver";

    public void onReceive(Context context, Intent intent) {
        if (!"android.intent.action.MEDIA_BUTTON".equals(intent.getAction())) {
            return;
        }
        Class<?> mediaServiceClass = null;
        String className = intent.getStringExtra("com.devbrackets.android.exomedia.RECEIVER_EXTRA_CLASS");
        if (className != null) {
            try {
                mediaServiceClass = Class.forName(className);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
        if (mediaServiceClass != null && event != null && event.getAction() == 1) {
            this.handleKeyEvent(context, mediaServiceClass, event);
        }
    }

    private void handleKeyEvent(Context context, Class<? extends Service> mediaServiceClass, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 85: {
                this.sendPendingIntent(this.createPendingIntent(context, "remote_action_play_pause", mediaServiceClass));
                break;
            }
            case 87: {
                this.sendPendingIntent(this.createPendingIntent(context, "remote_action_next", mediaServiceClass));
                break;
            }
            case 88: {
                this.sendPendingIntent(this.createPendingIntent(context, "remote_action_previous", mediaServiceClass));
                break;
            }
        }
    }

    private PendingIntent createPendingIntent(Context context, String action, Class<? extends Service> serviceClass) {
        Intent intent = new Intent(context, serviceClass);
        intent.setAction(action);
        return PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
    }

    private void sendPendingIntent(PendingIntent pi) {
        try {
            pi.send();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Error sending lock screen pending intent", (Throwable)e);
        }
    }
}

