/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Log;
import com.devbrackets.android.exomedia.EMNotification;
import com.devbrackets.android.exomedia.receiver.MediaControlsReceiver;

public class EMLockScreen {
    private static final String TAG = "EMLockScreen";
    public static final String SESSION_TAG = "EMLockScreen.Session";
    public static final String RECEIVER_EXTRA_CLASS = "com.devbrackets.android.exomedia.RECEIVER_EXTRA_CLASS";
    @NonNull
    private Context context;
    @Nullable
    private Bitmap appIconBitmap;
    @Nullable
    private MediaSessionCompat mediaSession;
    private boolean showLockScreen = true;

    public EMLockScreen(@NonNull Context context, @NonNull Class<? extends Service> mediaServiceClass) {
        this.context = context;
        ComponentName componentName = new ComponentName(context, MediaControlsReceiver.class.getName());
        this.mediaSession = new MediaSessionCompat(context, SESSION_TAG, componentName, this.getMediaButtonReceiverPendingIntent(componentName, mediaServiceClass));
        this.mediaSession.setFlags(3);
        this.mediaSession.setCallback((MediaSessionCompat.Callback)new SessionCallback(mediaServiceClass));
    }

    public void release() {
        if (this.mediaSession != null) {
            this.mediaSession.release();
        }
        this.appIconBitmap = null;
    }

    public void setLockScreenEnabled(boolean enabled) {
        if (this.showLockScreen == enabled) {
            return;
        }
        this.showLockScreen = enabled;
        if (!enabled && this.mediaSession != null) {
            this.mediaSession.setActive(false);
        }
    }

    public void setLockScreenBaseInformation(@DrawableRes int appIcon) {
        this.appIconBitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)appIcon);
    }

    public void updateLockScreenInformation(String title, String album, String artist, Bitmap mediaArtwork, EMNotification.NotificationMediaState notificationMediaState) {
        MediaMetadataCompat.Builder metaDataBuilder = new MediaMetadataCompat.Builder();
        metaDataBuilder.putBitmap("android.media.metadata.DISPLAY_ICON", this.appIconBitmap);
        metaDataBuilder.putString("android.media.metadata.TITLE", title);
        metaDataBuilder.putString("android.media.metadata.ALBUM", album);
        metaDataBuilder.putString("android.media.metadata.ARTIST", artist);
        if (mediaArtwork != null) {
            metaDataBuilder.putBitmap("android.media.metadata.ALBUM_ART", mediaArtwork);
        }
        if (this.mediaSession != null) {
            this.mediaSession.setMetadata(metaDataBuilder.build());
        }
        PlaybackStateCompat.Builder playbackStateBuilder = new PlaybackStateCompat.Builder();
        playbackStateBuilder.setActions(this.getPlaybackOptions(notificationMediaState));
        playbackStateBuilder.setState(this.getPlaybackState(notificationMediaState.isPlaying()), -1L, 1.0f);
        this.mediaSession.setPlaybackState(playbackStateBuilder.build());
        Log.d((String)TAG, (String)("update, controller is null ? " + (this.mediaSession.getController() == null ? "true" : "false")));
        if (this.showLockScreen && !this.mediaSession.isActive()) {
            this.mediaSession.setActive(true);
        }
    }

    private PendingIntent getMediaButtonReceiverPendingIntent(ComponentName componentName, @NonNull Class<? extends Service> serviceClass) {
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setComponent(componentName);
        mediaButtonIntent.putExtra(RECEIVER_EXTRA_CLASS, serviceClass.getName());
        return PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)mediaButtonIntent, (int)0x10000000);
    }

    private int getPlaybackState(boolean isPlaying) {
        return isPlaying ? 3 : 2;
    }

    private long getPlaybackOptions(EMNotification.NotificationMediaState mediaState) {
        long availableActions = 518L;
        if (mediaState.isNextEnabled()) {
            availableActions |= 0x20L;
        }
        if (mediaState.isPreviousEnabled()) {
            availableActions |= 0x10L;
        }
        return availableActions;
    }

    private PendingIntent createPendingIntent(@NonNull String action, @NonNull Class<? extends Service> serviceClass) {
        Intent intent = new Intent(this.context, serviceClass);
        intent.setAction(action);
        return PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
    }

    private class SessionCallback
    extends MediaSessionCompat.Callback {
        private PendingIntent playPausePendingIntent;
        private PendingIntent nextPendingIntent;
        private PendingIntent previousPendingIntent;

        public SessionCallback(Class<? extends Service> serviceClass) {
            this.playPausePendingIntent = EMLockScreen.this.createPendingIntent("remote_action_play_pause", serviceClass);
            this.nextPendingIntent = EMLockScreen.this.createPendingIntent("remote_action_next", serviceClass);
            this.previousPendingIntent = EMLockScreen.this.createPendingIntent("remote_action_previous", serviceClass);
        }

        public void onPlay() {
            this.sendPendingIntent(this.playPausePendingIntent);
        }

        public void onPause() {
            this.sendPendingIntent(this.playPausePendingIntent);
        }

        public void onSkipToNext() {
            this.sendPendingIntent(this.nextPendingIntent);
        }

        public void onSkipToPrevious() {
            this.sendPendingIntent(this.previousPendingIntent);
        }

        private void sendPendingIntent(PendingIntent pi) {
            try {
                pi.send();
            }
            catch (Exception e) {
                Log.d((String)EMLockScreen.TAG, (String)"Error sending lock screen pending intent", (Throwable)e);
            }
        }
    }
}

