/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.type;

import android.net.Uri;
import android.support.annotation.Nullable;

public enum MediaSourceType {
    HLS(".*m3u8.*"),
    DASH(".*mpd.*"),
    SMOOTH_STREAM(".*ism.*"),
    DEFAULT(null);

    @Nullable
    private String regex;

    private MediaSourceType(String regex) {
        this.regex = regex;
    }

    @Nullable
    public String getRegex() {
        return this.regex;
    }

    public static MediaSourceType get(Uri uri) {
        for (int ordinal = 0; ordinal < MediaSourceType.values().length; ++ordinal) {
            String regex = MediaSourceType.values()[ordinal].getRegex();
            if (regex == null || !uri.toString().matches(regex)) continue;
            return MediaSourceType.values()[ordinal];
        }
        return DEFAULT;
    }
}

