/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.EMListenerMux;
import com.devbrackets.android.exomedia.builder.DashRenderBuilder;
import com.devbrackets.android.exomedia.builder.HlsRenderBuilder;
import com.devbrackets.android.exomedia.builder.RenderBuilder;
import com.devbrackets.android.exomedia.builder.SmoothStreamRenderBuilder;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.listener.EMProgressCallback;
import com.devbrackets.android.exomedia.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.type.MediaSourceType;
import com.devbrackets.android.exomedia.util.EMDeviceUtil;
import com.devbrackets.android.exomedia.util.EMEventBus;
import com.devbrackets.android.exomedia.util.MediaUtil;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.StopWatch;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioCapabilitiesReceiver;

public class EMAudioPlayer
implements AudioCapabilitiesReceiver.Listener {
    private static final String TAG = EMAudioPlayer.class.getSimpleName();
    private static final String USER_AGENT_FORMAT = "EMAudioPlayer %s / Android %s / %s";
    private Context context;
    private MediaPlayer mediaPlayer;
    private EMExoPlayer emExoPlayer;
    private EMListenerMux listenerMux;
    private boolean useExo;
    private int currentBufferPercent = 0;
    private int overriddenDuration = -1;
    private int positionOffset = 0;
    private boolean overridePosition = false;
    @Nullable
    private EMEventBus bus;
    private EMProgressCallback progressCallback;
    private Repeater pollRepeater = new Repeater();
    private StopWatch overriddenPositionStopWatch = new StopWatch();
    private AudioCapabilities audioCapabilities;
    private AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    private EMMediaProgressEvent currentMediaProgressEvent = new EMMediaProgressEvent(0L, 0, 0L);

    public EMAudioPlayer(Context context) {
        this.context = context;
        boolean bl = this.useExo = Build.VERSION.SDK_INT >= 16 && EMDeviceUtil.isDeviceCTSCompliant();
        if (!this.useExo && this.mediaPlayer == null) {
            this.setupMediaPlayer();
        } else if (this.useExo && this.emExoPlayer == null) {
            this.setupEMExoPlayer();
        }
        this.pollRepeater.setRepeatListener(new Repeater.RepeatListener(){

            @Override
            public void onRepeat() {
                EMAudioPlayer.this.currentMediaProgressEvent.update(EMAudioPlayer.this.getCurrentPosition(), EMAudioPlayer.this.getBufferPercentage(), EMAudioPlayer.this.getDuration());
                if (EMAudioPlayer.this.progressCallback != null && EMAudioPlayer.this.progressCallback.onProgressUpdated(EMAudioPlayer.this.currentMediaProgressEvent)) {
                    return;
                }
                if (EMAudioPlayer.this.bus != null) {
                    EMAudioPlayer.this.bus.post(EMAudioPlayer.this.currentMediaProgressEvent);
                }
            }
        });
    }

    private void setupEMExoPlayer() {
        if (this.audioCapabilitiesReceiver == null) {
            this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.context.getApplicationContext(), (AudioCapabilitiesReceiver.Listener)this);
            this.audioCapabilitiesReceiver.register();
        }
        if (this.emExoPlayer == null) {
            this.emExoPlayer = new EMExoPlayer();
            this.listenerMux = new EMListenerMux(new MuxNotifier());
            this.emExoPlayer.addListener(this.listenerMux);
            this.emExoPlayer.setMetadataListener(null);
        }
    }

    private void setupMediaPlayer() {
        this.listenerMux = new EMListenerMux(new MuxNotifier());
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.listenerMux);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.listenerMux);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.listenerMux);
        this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.listenerMux);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.listenerMux);
        }
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        if (!audioCapabilities.equals((Object)this.audioCapabilities)) {
            this.audioCapabilities = audioCapabilities;
        }
    }

    public void setProgressPollDelay(int milliSeconds) {
        this.pollRepeater.setRepeaterDelay(milliSeconds);
    }

    public void setBus(@Nullable EMEventBus bus) {
        this.bus = bus;
        this.listenerMux.setBus(bus);
    }

    public void startProgressPoll(@Nullable EMEventBus bus) {
        this.setBus(bus);
        if (bus != null) {
            this.pollRepeater.start();
        }
    }

    public void startProgressPoll(EMProgressCallback callback) {
        this.progressCallback = callback;
        if (this.progressCallback != null) {
            this.pollRepeater.start();
        }
    }

    public void stopProgressPoll() {
        this.pollRepeater.stop();
    }

    private RenderBuilder getRendererBuilder(MediaSourceType renderType, Uri uri, MediaUtil.MediaType defaultMediaType) {
        switch (renderType) {
            case HLS: {
                return new HlsRenderBuilder(this.context, this.getUserAgent(), uri.toString());
            }
            case DASH: {
                return new DashRenderBuilder(this.context, this.getUserAgent(), uri.toString());
            }
            case SMOOTH_STREAM: {
                return new SmoothStreamRenderBuilder(this.context, this.getUserAgent(), uri.toString());
            }
        }
        return new RenderBuilder(this.context, this.getUserAgent(), uri.toString());
    }

    public String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, "2.5.2 (25200)", Build.VERSION.RELEASE, Build.MODEL);
    }

    public int getAudioSessionId() {
        if (!this.useExo) {
            return this.mediaPlayer.getAudioSessionId();
        }
        return this.emExoPlayer.getAudioSessionId();
    }

    public void setAudioStreamType(int steamType) {
        if (!this.useExo) {
            this.mediaPlayer.setAudioStreamType(steamType);
        }
    }

    public void setDataSource(Context context, Uri uri) {
        this.setDataSource(context, uri, MediaUtil.MediaType.MP3);
    }

    public void setDataSource(Context context, Uri uri, MediaUtil.MediaType defaultMediaType) {
        RenderBuilder builder = null;
        if (uri != null) {
            builder = this.getRendererBuilder(MediaSourceType.get(uri), uri, defaultMediaType);
        }
        this.setDataSource(context, uri, builder);
    }

    public void setDataSource(Context context, Uri uri, RenderBuilder renderBuilder) {
        if (!this.useExo) {
            try {
                this.mediaPlayer.setDataSource(context, uri);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"MediaPlayer: error setting data source", (Throwable)e);
            }
        } else {
            if (uri != null) {
                this.emExoPlayer.replaceRenderBuilder(renderBuilder);
                this.listenerMux.setNotifiedCompleted(false);
            } else {
                this.emExoPlayer.replaceRenderBuilder(null);
            }
            this.emExoPlayer.seekTo(0L);
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.overrideDuration(-1);
        this.setPositionOffset(0);
    }

    public void prepareAsync() {
        if (!this.useExo) {
            this.mediaPlayer.prepareAsync();
        } else {
            this.emExoPlayer.prepare();
        }
    }

    public void setVolume(float leftVolume, float rightVolume) {
        if (!this.useExo) {
            this.mediaPlayer.setVolume(leftVolume, rightVolume);
        } else {
            this.emExoPlayer.setVolume(leftVolume);
        }
    }

    public void setWakeMode(Context context, int mode) {
        if (!this.useExo) {
            this.mediaPlayer.setWakeMode(context, mode);
        } else {
            this.emExoPlayer.setWakeMode(context, mode);
        }
    }

    public void reset() {
        this.stopPlayback();
        this.setDataSource(null, null);
        if (!this.useExo) {
            this.mediaPlayer.reset();
        }
    }

    public void seekTo(int milliSeconds) {
        if (!this.listenerMux.isPrepared()) {
            return;
        }
        if ((long)milliSeconds > this.getDuration()) {
            milliSeconds = (int)this.getDuration();
        }
        if (!this.useExo) {
            this.mediaPlayer.seekTo(milliSeconds);
        } else {
            this.emExoPlayer.seekTo(milliSeconds);
        }
    }

    public boolean isPlaying() {
        if (!this.useExo) {
            return this.mediaPlayer.isPlaying();
        }
        return this.emExoPlayer.getPlayWhenReady();
    }

    public void start() {
        if (!this.useExo) {
            this.mediaPlayer.start();
        } else {
            this.emExoPlayer.setPlayWhenReady(true);
        }
        this.startProgressPoll(this.bus);
        this.startProgressPoll(this.progressCallback);
    }

    public void pause() {
        if (!this.useExo) {
            this.mediaPlayer.pause();
        } else {
            this.emExoPlayer.setPlayWhenReady(false);
        }
        this.stopProgressPoll();
    }

    public void stopPlayback() {
        if (!this.useExo) {
            this.mediaPlayer.stop();
        } else {
            this.emExoPlayer.setPlayWhenReady(false);
        }
        this.stopProgressPoll();
    }

    public void release() {
        if (!this.useExo) {
            this.mediaPlayer.release();
        } else {
            this.emExoPlayer.release();
        }
        this.stopProgressPoll();
        this.overriddenPositionStopWatch.stop();
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
            this.audioCapabilitiesReceiver = null;
        }
    }

    public long getDuration() {
        if (this.overriddenDuration >= 0) {
            return this.overriddenDuration;
        }
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        if (!this.useExo) {
            return this.mediaPlayer.getDuration();
        }
        return this.emExoPlayer.getDuration();
    }

    public void overrideDuration(int duration) {
        this.overriddenDuration = duration;
    }

    public long getCurrentPosition() {
        if (this.overridePosition) {
            return (long)this.positionOffset + this.overriddenPositionStopWatch.getTime();
        }
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        if (!this.useExo) {
            return this.positionOffset + this.mediaPlayer.getCurrentPosition();
        }
        return (long)this.positionOffset + this.emExoPlayer.getCurrentPosition();
    }

    public void setPositionOffset(int offset) {
        this.positionOffset = offset;
    }

    public void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public int getBufferPercentage() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        if (!this.useExo) {
            return this.currentBufferPercent;
        }
        return this.emExoPlayer.getBufferedPercentage();
    }

    public void addExoPlayerListener(ExoPlayerListener listener) {
        this.listenerMux.addExoPlayerListener(listener);
    }

    public void removeExoPlayerListener(ExoPlayerListener listener) {
        this.listenerMux.removeExoPlayerListener(listener);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.listenerMux.setOnInfoListener(listener);
    }

    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.listenerMux.setOnBufferingUpdateListener(listener);
    }

    private void onPlaybackEnded() {
        this.stopPlayback();
        this.pollRepeater.stop();
    }

    private class MuxNotifier
    extends EMListenerMux.EMListenerMuxNotifier {
        private MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            return EMAudioPlayer.this.getCurrentPosition() + endLeeway >= EMAudioPlayer.this.getDuration();
        }

        @Override
        public void onExoPlayerError(Exception e) {
            if (EMAudioPlayer.this.emExoPlayer != null) {
                EMAudioPlayer.this.emExoPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            EMAudioPlayer.this.onPlaybackEnded();
        }

        @Override
        public void onBufferUpdated(int percent) {
            EMAudioPlayer.this.currentBufferPercent = percent;
        }
    }
}

