/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.widget;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;

public class VideoSurfaceView
extends SurfaceView {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    private float videoAspectRatio;
    @Nullable
    private OnSizeChangeListener listener;
    private Point oldSize = new Point(0, 0);

    public VideoSurfaceView(Context context) {
        super(context);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAspectRatio(float widthHeightRatio) {
        if (this.videoAspectRatio != widthHeightRatio) {
            this.videoAspectRatio = widthHeightRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.videoAspectRatio == 0.0f) {
            return;
        }
        int width = this.getMeasuredWidth();
        float viewAspectRatio = (float)width / (float)(height = this.getMeasuredHeight());
        float aspectDeformation = this.videoAspectRatio / viewAspectRatio - 1.0f;
        if (Math.abs(aspectDeformation) <= 0.01f) {
            this.notifyListener(width, height);
            return;
        }
        if (aspectDeformation > 0.0f) {
            height = (int)((float)width / this.videoAspectRatio);
        } else {
            width = (int)((float)height * this.videoAspectRatio);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        this.notifyListener(width, height);
    }

    public void setOnSizeChangeListener(@Nullable OnSizeChangeListener listener) {
        this.listener = listener;
    }

    private void notifyListener(int width, int height) {
        if (this.listener != null && (this.oldSize.x != width || this.oldSize.y != height)) {
            this.oldSize.x = width;
            this.oldSize.y = height;
            this.listener.onVideoSurfaceSizeChange(width, height);
        }
    }

    public static interface OnSizeChangeListener {
        public void onVideoSurfaceSizeChange(int var1, int var2);
    }
}

