/*
 * Decompiled with CFR 0.152.
 */
package edu.umontreal.kotlingrad.api;

import ch.obermuhlner.math.big.BigDecimalMath;
import edu.umontreal.kotlingrad.api.RealNumber;
import edu.umontreal.kotlingrad.api.SFun;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0016J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0096\u0002J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0096\u0004J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010H\u0096\u0002J\t\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Ledu/umontreal/kotlingrad/api/BDReal;", "Ledu/umontreal/kotlingrad/api/RealNumber;", "Ljava/math/BigDecimal;", "number", "", "sigFigs", "", "(Ljava/lang/Number;I)V", "mc", "Ljava/math/MathContext;", "getMc", "()Ljava/math/MathContext;", "getSigFigs", "()I", "cos", "log", "Ledu/umontreal/kotlingrad/api/SFun;", "base", "plus", "addend", "pow", "exponent", "sin", "sqrt", "tan", "times", "multiplicand", "unaryMinus", "wrap", "Companion", "kotlingrad"})
public class BDReal
extends RealNumber<BDReal, BigDecimal> {
    @NotNull
    private final MathContext mc;
    private final int sigFigs;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MathContext getMc() {
        return this.mc;
    }

    @NotNull
    public BDReal wrap(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return new BDReal(number.doubleValue(), this.sigFigs);
    }

    @Override
    @NotNull
    public BDReal sin() {
        BigDecimal bigDecimal = BigDecimalMath.sin((BigDecimal)((BigDecimal)this.getValue()), (MathContext)this.mc);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.sin(value, mc)");
        return new BDReal(bigDecimal, 0, 2, null);
    }

    @Override
    @NotNull
    public BDReal cos() {
        BigDecimal bigDecimal = BigDecimalMath.cos((BigDecimal)((BigDecimal)this.getValue()), (MathContext)this.mc);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.cos(value, mc)");
        return new BDReal(bigDecimal, 0, 2, null);
    }

    @Override
    @NotNull
    public BDReal tan() {
        BigDecimal bigDecimal = BigDecimalMath.tan((BigDecimal)((BigDecimal)this.getValue()), (MathContext)this.mc);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.tan(value, mc)");
        return new BDReal(bigDecimal, 0, 2, null);
    }

    @Override
    @NotNull
    public BDReal sqrt() {
        BigDecimal bigDecimal = BigDecimalMath.sqrt((BigDecimal)((BigDecimal)this.getValue()), (MathContext)this.mc);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.sqrt(value, mc)");
        return new BDReal(bigDecimal, 0, 2, null);
    }

    @Override
    @NotNull
    public BDReal unaryMinus() {
        BigDecimal bigDecimal = (BigDecimal)this.getValue();
        boolean bl = false;
        BigDecimal bigDecimal2 = bigDecimal.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.negate()");
        return new BDReal(bigDecimal2, 0, 2, null);
    }

    @Override
    @NotNull
    public SFun<BDReal> log(@NotNull SFun<BDReal> base) {
        SFun sFun;
        Intrinsics.checkNotNullParameter(base, (String)"base");
        SFun<BDReal> sFun2 = base;
        if (sFun2 instanceof BDReal) {
            BigDecimal bigDecimal = BigDecimalMath.log((BigDecimal)((BigDecimal)this.getValue()), (MathContext)this.mc);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.log(value, mc)");
            BigDecimal bigDecimal2 = bigDecimal;
            BigDecimal bigDecimal3 = BigDecimalMath.log((BigDecimal)((BigDecimal)((BDReal)base).getValue()), (MathContext)this.mc);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"BigDecimalMath.log(base.value, mc)");
            BigDecimal bigDecimal4 = bigDecimal3;
            boolean bl = false;
            BigDecimal bigDecimal5 = bigDecimal2.divide(bigDecimal4, RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
            sFun = new BDReal(bigDecimal5, 0, 2, null);
        } else {
            sFun = super.log(base);
        }
        return sFun;
    }

    @Override
    @NotNull
    public SFun<BDReal> plus(@NotNull SFun<BDReal> addend) {
        SFun sFun;
        Intrinsics.checkNotNullParameter(addend, (String)"addend");
        SFun<BDReal> sFun2 = addend;
        if (sFun2 instanceof BDReal) {
            BigDecimal bigDecimal = (BigDecimal)this.getValue();
            BigDecimal bigDecimal2 = (BigDecimal)((BDReal)addend).getValue();
            boolean bl = false;
            BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.add(other)");
            sFun = new BDReal(bigDecimal3, 0, 2, null);
        } else {
            sFun = super.plus(addend);
        }
        return sFun;
    }

    @Override
    @NotNull
    public SFun<BDReal> times(@NotNull SFun<BDReal> multiplicand) {
        SFun sFun;
        Intrinsics.checkNotNullParameter(multiplicand, (String)"multiplicand");
        SFun<BDReal> sFun2 = multiplicand;
        if (sFun2 instanceof BDReal) {
            BigDecimal bigDecimal = (BigDecimal)this.getValue();
            BigDecimal bigDecimal2 = (BigDecimal)((BDReal)multiplicand).getValue();
            boolean bl = false;
            BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
            sFun = new BDReal(bigDecimal3, 0, 2, null);
        } else {
            sFun = super.times(multiplicand);
        }
        return sFun;
    }

    @Override
    @NotNull
    public SFun<BDReal> pow(@NotNull SFun<BDReal> exponent) {
        SFun sFun;
        Intrinsics.checkNotNullParameter(exponent, (String)"exponent");
        SFun<BDReal> sFun2 = exponent;
        if (sFun2 instanceof BDReal) {
            BigDecimal bigDecimal = BigDecimalMath.pow((BigDecimal)((BigDecimal)this.getValue()), (BigDecimal)((BigDecimal)((BDReal)exponent).getValue()), (MathContext)this.mc);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimalMath.pow(value, exponent.value, mc)");
            sFun = new BDReal(bigDecimal, 0, 2, null);
        } else {
            sFun = super.pow(exponent);
        }
        return sFun;
    }

    public final int getSigFigs() {
        return this.sigFigs;
    }

    public BDReal(@NotNull Number number, int sigFigs) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)number;
        } else {
            double d = number.doubleValue();
            boolean bl = false;
            bigDecimal = Double.isNaN(d) ? BigDecimal.ZERO : (1.0E30 < number.doubleValue() ? new BigDecimal(1.0E30) : (-1.0E30 > number.doubleValue() ? new BigDecimal(1.0E30) : new BigDecimal(number.doubleValue() + 0.0)));
        }
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"when {\n  number is BigDe\u2026umber.toDouble() + 0.0)\n}");
        super((Number)bigDecimal);
        this.sigFigs = sigFigs;
        this.mc = new MathContext(this.sigFigs);
    }

    public /* synthetic */ BDReal(Number number, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        this(number, n);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ledu/umontreal/kotlingrad/api/BDReal$Companion;", "Ledu/umontreal/kotlingrad/api/BDReal;", "()V", "kotlingrad"})
    public static final class Companion
    extends BDReal {
        private Companion() {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.ZERO");
            super(bigDecimal, 0, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

