/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceView;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class SquareCameraPreview
extends SurfaceView {
    public static final String TAG = SquareCameraPreview.class.getSimpleName();
    private static final int INVALID_POINTER_ID = -1;
    private static final int ZOOM_OUT = 0;
    private static final int ZOOM_IN = 1;
    private static final int ZOOM_DELTA = 1;
    private static final int FOCUS_SQR_SIZE = 100;
    private static final int FOCUS_MAX_BOUND = 1000;
    private static final int FOCUS_MIN_BOUND = -1000;
    private static final double ASPECT_RATIO = 0.75;
    private Camera mCamera;
    private float mLastTouchX;
    private float mLastTouchY;
    private int mMaxZoom;
    private boolean mIsZoomSupported;
    private int mActivePointerId = -1;
    private int mScaleFactor = 1;
    private ScaleGestureDetector mScaleDetector;
    private boolean mIsFocus;
    private Camera.Area mFocusArea;
    private ArrayList<Camera.Area> mFocusAreas;

    public SquareCameraPreview(Context context) {
        super(context);
        this.init(context);
    }

    public SquareCameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SquareCameraPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mFocusArea = new Camera.Area(new Rect(), 1000);
        this.mFocusAreas = new ArrayList();
        this.mFocusAreas.add(this.mFocusArea);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean isPortrait;
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        boolean bl = isPortrait = this.getResources().getConfiguration().orientation == 1;
        if (isPortrait) {
            if ((double)width > (double)height * 0.75) {
                width = (int)((double)height * 0.75 + 0.5);
            } else {
                height = (int)((double)width / 0.75 + 0.5);
            }
        } else if ((double)height > (double)width * 0.75) {
            height = (int)((double)width * 0.75 + 0.5);
        } else {
            width = (int)((double)height / 0.75 + 0.5);
        }
        this.setMeasuredDimension(width, height);
    }

    public int getViewWidth() {
        return this.getWidth();
    }

    public int getViewHeight() {
        return this.getHeight();
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (camera != null) {
            Camera.Parameters params = camera.getParameters();
            this.mIsZoomSupported = params.isZoomSupported();
            if (this.mIsZoomSupported) {
                this.mMaxZoom = params.getMaxZoom();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mScaleDetector.onTouchEvent(event);
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mIsFocus = true;
                this.mLastTouchX = event.getX();
                this.mLastTouchY = event.getY();
                this.mActivePointerId = event.getPointerId(0);
                break;
            }
            case 1: {
                if (this.mIsFocus) {
                    this.handleFocus(this.mCamera.getParameters());
                }
                this.mActivePointerId = -1;
                break;
            }
            case 5: {
                this.mCamera.cancelAutoFocus();
                this.mIsFocus = false;
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
            }
        }
        return true;
    }

    private void handleZoom(Camera.Parameters params) {
        int zoom = params.getZoom();
        if (this.mScaleFactor == 1) {
            if (zoom < this.mMaxZoom) {
                ++zoom;
            }
        } else if (this.mScaleFactor == 0 && zoom > 0) {
            --zoom;
        }
        params.setZoom(zoom);
        this.mCamera.setParameters(params);
    }

    private void handleFocus(Camera.Parameters params) {
        float x = this.mLastTouchX;
        float y = this.mLastTouchY;
        if (!this.setFocusBound(x, y)) {
            return;
        }
        List supportedFocusModes = params.getSupportedFocusModes();
        if (supportedFocusModes != null && supportedFocusModes.contains("auto")) {
            Log.d((String)TAG, (String)(this.mFocusAreas.size() + ""));
            params.setFocusAreas(this.mFocusAreas);
            params.setFocusMode("auto");
            this.mCamera.setParameters(params);
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                }
            });
        }
    }

    private boolean setFocusBound(float x, float y) {
        int left = (int)(x - 50.0f);
        int right = (int)(x + 50.0f);
        int top = (int)(y - 50.0f);
        int bottom = (int)(y + 50.0f);
        if (-1000 > left || left > 1000) {
            return false;
        }
        if (-1000 > right || right > 1000) {
            return false;
        }
        if (-1000 > top || top > 1000) {
            return false;
        }
        if (-1000 > bottom || bottom > 1000) {
            return false;
        }
        this.mFocusArea.rect.set(left, top, right, bottom);
        return true;
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            SquareCameraPreview.this.mScaleFactor = (int)detector.getScaleFactor();
            SquareCameraPreview.this.handleZoom(SquareCameraPreview.this.mCamera.getParameters());
            return true;
        }
    }
}

