/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.desmond.squarecamera.ImageParameters;
import com.desmond.squarecamera.R;

public class ResizeAnimation
extends Animation {
    final int mStartLength;
    final int mFinalLength;
    final boolean mIsPortrait;
    final View mView;

    public ResizeAnimation(@NonNull View view, ImageParameters imageParameters) {
        this.mStartLength = view.getContext().getResources().getDimensionPixelSize(R.dimen.cover_start_width);
        this.mFinalLength = imageParameters.getAnimationParameter();
        this.mIsPortrait = imageParameters.isPortrait();
        this.mView = view;
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        int newLength = (int)((float)this.mStartLength + (float)(this.mFinalLength - this.mStartLength) * interpolatedTime);
        if (this.mIsPortrait) {
            this.mView.getLayoutParams().height = newLength;
        } else {
            this.mView.getLayoutParams().width = newLength;
        }
        this.mView.requestLayout();
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
    }

    public boolean willChangeBounds() {
        return true;
    }
}

