/*
 * Decompiled with CFR 0.152.
 */
package com.github.bombe93;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import com.github.bombe93.R;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Main {
    private static final String TAG = "ChangeLogDialog";
    private final Context mContext;
    private String mStyle = "h1 { margin-left: 0px; font-size: 12pt; }li { margin-left: 0px; font-size: 9pt; }ul { padding-left: 30px; }.summary { font-size: 9pt; color: #606060; display: block; clear: left; }.date { font-size: 9pt; color: #606060;  display: block; }";
    protected DialogInterface.OnDismissListener mOnDismissListener;

    public Main(Context context) {
        this.mContext = context;
    }

    protected Context getContext() {
        return this.mContext;
    }

    private String getAppVersion() {
        String versionName = "";
        try {
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return versionName;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private String parseDate(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date parsedDate = dateFormat.parse(dateString);
            return DateFormat.getDateFormat((Context)this.getContext()).format(parsedDate);
        }
        catch (ParseException ignored) {
            return dateString;
        }
    }

    private void parseReleaseTag(StringBuilder changelogBuilder, XmlPullParser resourceParser) throws XmlPullParserException, IOException {
        changelogBuilder.append("<h1>Release: ").append(resourceParser.getAttributeValue(null, "version")).append("</h1>");
        if (resourceParser.getAttributeValue(null, "date") != null) {
            changelogBuilder.append("<span class='date'>").append(this.parseDate(resourceParser.getAttributeValue(null, "date"))).append("</span>");
        }
        if (resourceParser.getAttributeValue(null, "summary") != null) {
            changelogBuilder.append("<span class='summary'>").append(resourceParser.getAttributeValue(null, "summary")).append("</span>");
        }
        changelogBuilder.append("<ul>");
        int eventType = resourceParser.getEventType();
        while (eventType != 3 || resourceParser.getName().equals("change")) {
            if (eventType == 2 && resourceParser.getName().equals("change")) {
                eventType = resourceParser.next();
                changelogBuilder.append("<li>" + resourceParser.getText() + "</li>");
            }
            eventType = resourceParser.next();
        }
        changelogBuilder.append("</ul>");
    }

    private String getStyle() {
        return String.format("<style type=\"text/css\">%s</style>", this.mStyle);
    }

    public void setStyle(String style) {
        this.mStyle = style;
    }

    public Main setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHTMLChangelog(int resourceId, Resources resources, int version) {
        boolean releaseFound = false;
        StringBuilder changelogBuilder = new StringBuilder();
        changelogBuilder.append("<html><head>").append(this.getStyle()).append("</head><body>");
        try (XmlResourceParser xml2 = resources.getXml(resourceId);){
            int eventType = xml2.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && xml2.getName().equals("release")) {
                    int versioncode = Integer.parseInt(xml2.getAttributeValue(null, "versioncode"));
                    if (version == 0 || versioncode == version) {
                        this.parseReleaseTag(changelogBuilder, (XmlPullParser)xml2);
                        releaseFound = true;
                    }
                }
                eventType = xml2.next();
            }
        }
        changelogBuilder.append("</body></html>");
        if (releaseFound) {
            return changelogBuilder.toString();
        }
        return "";
    }

    public String getHTML() {
        Resources resources;
        String packageName = this.mContext.getPackageName();
        try {
            resources = this.mContext.getPackageManager().getResourcesForApplication(packageName);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return "";
        }
        return this.getHTMLChangelog(R.xml.changelog, resources, 0);
    }

    public void show() {
        this.show(0);
    }

    protected void show(int version) {
        Resources resources;
        String packageName = this.mContext.getPackageName();
        try {
            resources = this.mContext.getPackageManager().getResourcesForApplication(packageName);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return;
        }
        String title = resources.getString(R.string.title_changelog);
        title = String.format("%s v%s", title, this.getAppVersion());
        String htmlChangelog = this.getHTMLChangelog(R.xml.changelog, resources, version);
        String closeString = resources.getString(R.string.changelog_close);
        if (htmlChangelog.length() == 0) {
            return;
        }
        WebView webView = new WebView(this.mContext);
        webView.loadDataWithBaseURL(null, htmlChangelog, "text/html", "utf-8", null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)title).setView((View)webView).setPositiveButton((CharSequence)closeString, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (Main.this.mOnDismissListener != null) {
                    Main.this.mOnDismissListener.onDismiss(dialog);
                }
            }
        });
        dialog.show();
    }
}

