/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.util;

import android.os.SystemClock;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import me.bogerchan.niervisualizer.core.NierConstants;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/bogerchan/niervisualizer/util/FpsHelper;", "", "()V", "mAwaitTime", "", "mFps", "mFrameGap", "mLastSampleTime", "", "mLastTrackTime", "mSkippedFrame", "end", "", "nextDelayTime", "start", "Companion", "core_release"})
public final class FpsHelper {
    private final int mFrameGap = 41;
    private long mLastTrackTime = -1L;
    private int mAwaitTime;
    private int mSkippedFrame;
    private long mLastSampleTime = -1L;
    private int mFps;
    private static final int DEFAULT_CALIBRATION = 2;
    private static final long DEFAULT_TOLERATE_TIME = 2000L;
    public static final Companion Companion = new Companion(null);

    public final void start() {
        long curTime = SystemClock.elapsedRealtime();
        long interval = curTime - this.mLastTrackTime;
        int lastAwaitTime = this.mAwaitTime;
        this.mAwaitTime = this.mFrameGap;
        if (interval < DEFAULT_TOLERATE_TIME) {
            if (this.mLastTrackTime >= 0L) {
                this.mAwaitTime -= (int)interval - lastAwaitTime;
            }
        } else {
            this.mFps = 0;
            this.mLastSampleTime = curTime;
        }
        this.mAwaitTime -= DEFAULT_CALIBRATION;
        this.mLastTrackTime = curTime;
        if (this.mLastSampleTime == -1L) {
            this.mLastSampleTime = curTime;
        }
    }

    public final void end() {
        long curTime = SystemClock.elapsedRealtime();
        this.mAwaitTime -= (int)(curTime - this.mLastTrackTime);
        if (this.mAwaitTime < 0) {
            this.mSkippedFrame = -this.mAwaitTime / this.mFrameGap + 1;
            this.mAwaitTime += this.mSkippedFrame * this.mFrameGap;
            Log.d((String)NierConstants.INSTANCE.getTAG(), (String)("skipped frame: " + this.mSkippedFrame + ", await: " + this.mAwaitTime));
        } else {
            this.mSkippedFrame = 0;
        }
        this.mLastTrackTime = curTime;
        int n = this.mFps;
        this.mFps = n + 1;
        if (curTime - this.mLastSampleTime > 1000L) {
            Log.d((String)NierConstants.INSTANCE.getTAG(), (String)("current fps: " + (int)(1000.0 / (double)(curTime - this.mLastSampleTime) * (double)this.mFps)));
            this.mFps = 0;
            this.mLastSampleTime = curTime;
        }
    }

    public final long nextDelayTime() {
        return this.mAwaitTime;
    }

    static {
        DEFAULT_CALIBRATION = 2;
        DEFAULT_TOLERATE_TIME = 2000L;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/bogerchan/niervisualizer/util/FpsHelper$Companion;", "", "()V", "DEFAULT_CALIBRATION", "", "getDEFAULT_CALIBRATION", "()I", "DEFAULT_TOLERATE_TIME", "", "getDEFAULT_TOLERATE_TIME", "()J", "core_release"})
    public static final class Companion {
        public final int getDEFAULT_CALIBRATION() {
            return DEFAULT_CALIBRATION;
        }

        public final long getDEFAULT_TOLERATE_TIME() {
            return DEFAULT_TOLERATE_TIME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

