/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer;

import android.media.audiofx.Visualizer;
import android.util.Log;
import android.view.SurfaceView;
import java.lang.ref.WeakReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import me.bogerchan.niervisualizer.NierVisualizerManager;
import me.bogerchan.niervisualizer.core.NierConstants;
import me.bogerchan.niervisualizer.core.NierVisualizerRenderWorker;
import me.bogerchan.niervisualizer.core.PeriodWorker;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\"J!\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u0006,"}, d2={"Lme/bogerchan/niervisualizer/NierVisualizerManager;", "", "()V", "mDataCaptureSize", "", "mDataSourceType", "mFftBuffer", "", "mPeriodWorker", "Lme/bogerchan/niervisualizer/core/PeriodWorker;", "mRenderer", "Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker;", "getMRenderer", "()Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker;", "mRenderer$delegate", "Lkotlin/Lazy;", "mState", "mStateBlock", "Ljava/lang/Object;", "mVisualizer", "Landroid/media/audiofx/Visualizer;", "mWaveBuffer", "renderViewWR", "Ljava/lang/ref/WeakReference;", "Landroid/view/SurfaceView;", "renderers", "", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "[Lme/bogerchan/niervisualizer/renderer/IRenderer;", "init", "audioSession", "dataSource", "Lme/bogerchan/niervisualizer/NierVisualizerManager$NVDataSource;", "pause", "", "release", "resume", "start", "view", "newRenderers", "(Landroid/view/SurfaceView;[Lme/bogerchan/niervisualizer/renderer/IRenderer;)V", "stop", "Companion", "NVDataSource", "core_release"})
public final class NierVisualizerManager {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Visualizer mVisualizer;
    private final Lazy mRenderer$delegate = LazyKt.lazy((Function0)mRenderer.2.INSTANCE);
    private byte[] mWaveBuffer;
    private byte[] mFftBuffer;
    private final Object mStateBlock = new Object();
    private WeakReference<SurfaceView> renderViewWR;
    private IRenderer[] renderers;
    private PeriodWorker mPeriodWorker;
    private int mDataSourceType = -1;
    private int mDataCaptureSize;
    private int mState;
    private static final int DATA_SOURCE_TYPE_UNKNOWN = -1;
    private static final int DATA_SOURCE_TYPE_VISUALIZER = 0;
    private static final int DATA_SOURCE_TYPE_OUTSIDE = 1;
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_START = 2;
    private static final int STATE_STOP = 3;
    private static final int STATE_PAUSE = 4;
    private static final int STATE_RESUME = 5;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NierVisualizerManager.class), "mRenderer", "getMRenderer()Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker;"))};
        Companion = new Companion(null);
    }

    private final NierVisualizerRenderWorker getMRenderer() {
        Lazy lazy = this.mRenderer$delegate;
        NierVisualizerManager nierVisualizerManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (NierVisualizerRenderWorker)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int init(int audioSession) {
        Object object = this.mStateBlock;
        synchronized (object) {
            if (this.mState != 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't initialize library, invalid state: " + this.mState));
                return 1;
            }
            try {
                int n;
                Visualizer visualizer;
                Visualizer visualizer2 = new Visualizer(audioSession);
                NierVisualizerManager nierVisualizerManager = this;
                Visualizer $receiver = visualizer2;
                $receiver.setEnabled(false);
                $receiver.setCaptureSize(512);
                try {
                    $receiver.setScalingMode(0);
                }
                catch (NoSuchMethodError e) {
                    Log.e((String)NierConstants.INSTANCE.getTAG(), (String)"Can't set scaling mode", (Throwable)e);
                }
                $receiver.setMeasurementMode(0);
                $receiver.setDataCaptureListener(new Visualizer.OnDataCaptureListener(this, audioSession){
                    final /* synthetic */ NierVisualizerManager this$0;
                    final /* synthetic */ int $audioSession$inlined;
                    {
                        this.this$0 = nierVisualizerManager;
                        this.$audioSession$inlined = n;
                    }

                    public void onFftDataCapture(@Nullable Visualizer visualizer, @Nullable byte[] fft, int samplingRate) {
                        byte[] byArray = NierVisualizerManager.access$getMFftBuffer$p(this.this$0);
                        if (byArray == null) {
                            return;
                        }
                        byte[] fftBuffer = byArray;
                        if (fft == null || fft.length != fftBuffer.length) {
                            return;
                        }
                        System.arraycopy(fft, 0, fftBuffer, 0, fft.length);
                        NierVisualizerManager.access$getMRenderer$p(this.this$0).updateFftData(fftBuffer);
                    }

                    public void onWaveFormDataCapture(@Nullable Visualizer visualizer, @Nullable byte[] waveform, int samplingRate) {
                        byte[] byArray = NierVisualizerManager.access$getMWaveBuffer$p(this.this$0);
                        if (byArray == null) {
                            return;
                        }
                        byte[] waveBuffer = byArray;
                        if (waveform == null || waveform.length != waveBuffer.length) {
                            return;
                        }
                        System.arraycopy(waveform, 0, waveBuffer, 0, waveform.length);
                        NierVisualizerManager.access$getMRenderer$p(this.this$0).updateWaveData(waveBuffer);
                    }
                }, Visualizer.getMaxCaptureRate(), true, true);
                $receiver = visualizer2 = (visualizer = visualizer2);
                int n2 = $receiver.getCaptureSize();
                NierVisualizerManager nierVisualizerManager2 = this;
                int $receiver2 = n2;
                this.mWaveBuffer = new byte[$receiver2];
                this.mFftBuffer = new byte[$receiver2];
                nierVisualizerManager2.mDataCaptureSize = n = n2;
                nierVisualizerManager.mVisualizer = visualizer = visualizer2;
                this.mDataSourceType = 0;
                this.mState = 1;
                return 0;
            }
            catch (IllegalStateException e) {
                this.mVisualizer = null;
                this.mWaveBuffer = null;
                this.mFftBuffer = null;
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)"Can't initialize Nier library!", (Throwable)e);
                return 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int init(@NotNull NVDataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Object object = this.mStateBlock;
        synchronized (object) {
            int n;
            block4: {
                if (this.mState == 0) break block4;
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't initialize library, invalid state: " + this.mState));
                int n2 = 1;
                return n2;
            }
            int n3 = dataSource.getDataLength();
            NierVisualizerManager nierVisualizerManager = this;
            int $receiver = n3;
            this.mWaveBuffer = new byte[$receiver];
            this.mFftBuffer = new byte[$receiver];
            nierVisualizerManager.mDataCaptureSize = n = n3;
            this.mPeriodWorker = new PeriodWorker(dataSource.getDataSamplingInterval(), (Function0<Unit>)((Function0)new Function0<Unit>(this, dataSource){
                final /* synthetic */ NierVisualizerManager this$0;
                final /* synthetic */ NVDataSource $dataSource$inlined;
                {
                    this.this$0 = nierVisualizerManager;
                    this.$dataSource$inlined = nVDataSource;
                    super(0);
                }

                public final void invoke() {
                    block7: {
                        byte[] $receiver;
                        byte[] byArray;
                        NVDataSource nVDataSource;
                        NVDataSource $receiver2 = nVDataSource = this.$dataSource$inlined;
                        byte[] byArray2 = $receiver2.fetchFftData();
                        if (byArray2 != null) {
                            $receiver = byArray = byArray2;
                            byte[] byArray3 = NierVisualizerManager.access$getMFftBuffer$p(this.this$0);
                            if (byArray3 == null) {
                            } else {
                                byte[] fftBuffer = byArray3;
                                if ($receiver.length != fftBuffer.length) {
                                    throw (Throwable)new IllegalStateException("NVDataSource must provide correct fft data size as it's getDataLength() says.");
                                }
                                System.arraycopy($receiver, 0, fftBuffer, 0, $receiver.length);
                                NierVisualizerManager.access$getMRenderer$p(this.this$0).updateFftData(fftBuffer);
                            }
                        }
                        byte[] byArray4 = $receiver2.fetchWaveData();
                        if (byArray4 == null) break block7;
                        $receiver = byArray = byArray4;
                        byte[] byArray5 = NierVisualizerManager.access$getMWaveBuffer$p(this.this$0);
                        if (byArray5 == null) {
                        } else {
                            byte[] waveBuffer = byArray5;
                            if ($receiver.length != waveBuffer.length) {
                                throw (Throwable)new IllegalStateException("NVDataSource must provide correct wave data size as it's getDataLength() says.");
                            }
                            System.arraycopy($receiver, 0, waveBuffer, 0, $receiver.length);
                            NierVisualizerManager.access$getMRenderer$p(this.this$0).updateFftData(waveBuffer);
                        }
                    }
                }
            }));
            this.mDataSourceType = 1;
            this.mState = 1;
            int n4 = 0;
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        Object object = this.mStateBlock;
        synchronized (object) {
            if (this.mState == 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't release library, invalid state: " + this.mState));
                return;
            }
            this.renderViewWR = null;
            this.renderers = null;
            this.getMRenderer().stop();
            this.getMRenderer().quit();
            this.mWaveBuffer = null;
            this.mFftBuffer = null;
            switch (this.mDataSourceType) {
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    if (visualizer != null) {
                        visualizer.setEnabled(false);
                    }
                    Visualizer visualizer2 = this.mVisualizer;
                    if (visualizer2 != null) {
                        visualizer2.setDataCaptureListener(null, Visualizer.getMaxCaptureRate(), true, true);
                    }
                    Visualizer visualizer3 = this.mVisualizer;
                    if (visualizer3 != null) {
                        visualizer3.release();
                    }
                    this.mVisualizer = null;
                    break;
                }
                case 1: {
                    PeriodWorker periodWorker = this.mPeriodWorker;
                    if (periodWorker != null) {
                        periodWorker.stop();
                    }
                    this.mPeriodWorker = null;
                }
            }
            this.mState = 0;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull SurfaceView view, @NotNull IRenderer[] newRenderers) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)newRenderers, (String)"newRenderers");
        Object object = this.mStateBlock;
        synchronized (object) {
            IRenderer[] iRendererArray = newRenderers;
            if (iRendererArray.length == 0) {
                throw (Throwable)new IllegalStateException("Renders is empty!");
            }
            if (this.mState == 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't start to work, invalid state: " + this.mState));
                return;
            }
            switch (this.mDataSourceType) {
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    if (visualizer == null) {
                        throw (Throwable)new IllegalStateException("You must call NierVisualizerManager.init() first!");
                    }
                    Visualizer visualizer2 = visualizer;
                    visualizer2.setEnabled(true);
                    break;
                }
                case 1: {
                    PeriodWorker periodWorker = this.mPeriodWorker;
                    if (periodWorker == null) {
                        throw (Throwable)new IllegalStateException("You must call NierVisualizerManager.init() first!");
                    }
                    PeriodWorker periodWorker2 = periodWorker;
                    periodWorker2.start();
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("You must call NierVisualizerManager.init() first!");
                }
            }
            this.renderViewWR = new WeakReference<SurfaceView>(view);
            this.renderers = newRenderers;
            this.getMRenderer().start(new NierVisualizerRenderWorker.RenderCore(this.mDataCaptureSize, view, newRenderers));
            this.mState = 2;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mStateBlock;
        synchronized (object) {
            if (this.mState == 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't stop work, invalid state: " + this.mState));
                return;
            }
            this.renderViewWR = null;
            this.renderers = null;
            this.getMRenderer().stop();
            switch (this.mDataSourceType) {
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    if (visualizer != null) {
                        visualizer.setEnabled(false);
                    }
                    break;
                }
                case 1: {
                    PeriodWorker periodWorker = this.mPeriodWorker;
                    if (periodWorker == null) break;
                    periodWorker.stop();
                    break;
                }
            }
            this.mState = 3;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mStateBlock;
        synchronized (object) {
            if (this.mState == 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't pause work, invalid state: " + this.mState));
                return;
            }
            this.getMRenderer().pause();
            switch (this.mDataSourceType) {
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    if (visualizer != null) {
                        visualizer.setEnabled(false);
                    }
                    break;
                }
                case 1: {
                    PeriodWorker periodWorker = this.mPeriodWorker;
                    if (periodWorker == null) break;
                    periodWorker.pause();
                    break;
                }
            }
            this.mState = 4;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mStateBlock;
        synchronized (object) {
            if (this.mState == 0) {
                Log.e((String)NierConstants.INSTANCE.getTAG(), (String)("Can't resume work, invalid state: " + this.mState));
                return;
            }
            this.getMRenderer().resume();
            switch (this.mDataSourceType) {
                case 0: {
                    Visualizer visualizer = this.mVisualizer;
                    if (visualizer != null) {
                        visualizer.setEnabled(true);
                    }
                    break;
                }
                case 1: {
                    PeriodWorker periodWorker = this.mPeriodWorker;
                    if (periodWorker == null) break;
                    periodWorker.resume();
                    break;
                }
            }
            this.mState = 5;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public static final /* synthetic */ byte[] access$getMFftBuffer$p(NierVisualizerManager $this) {
        return $this.mFftBuffer;
    }

    public static final /* synthetic */ void access$setMFftBuffer$p(NierVisualizerManager $this, @Nullable byte[] byArray) {
        $this.mFftBuffer = byArray;
    }

    @NotNull
    public static final /* synthetic */ NierVisualizerRenderWorker access$getMRenderer$p(NierVisualizerManager $this) {
        return $this.getMRenderer();
    }

    @Nullable
    public static final /* synthetic */ byte[] access$getMWaveBuffer$p(NierVisualizerManager $this) {
        return $this.mWaveBuffer;
    }

    public static final /* synthetic */ void access$setMWaveBuffer$p(NierVisualizerManager $this, @Nullable byte[] byArray) {
        $this.mWaveBuffer = byArray;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lme/bogerchan/niervisualizer/NierVisualizerManager$NVDataSource;", "", "fetchFftData", "", "fetchWaveData", "getDataLength", "", "getDataSamplingInterval", "", "core_release"})
    public static interface NVDataSource {
        public long getDataSamplingInterval();

        public int getDataLength();

        @Nullable
        public byte[] fetchFftData();

        @Nullable
        public byte[] fetchWaveData();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/bogerchan/niervisualizer/NierVisualizerManager$Companion;", "", "()V", "DATA_SOURCE_TYPE_OUTSIDE", "", "DATA_SOURCE_TYPE_UNKNOWN", "DATA_SOURCE_TYPE_VISUALIZER", "ERROR", "STATE_INITIALIZED", "STATE_PAUSE", "STATE_RESUME", "STATE_START", "STATE_STOP", "STATE_UNINITIALIZED", "SUCCESS", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

