/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.circle;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.LinearInterpolator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import me.bogerchan.niervisualizer.renderer.circle.CircleBarRenderer$WhenMappings;
import me.bogerchan.niervisualizer.util.NierAnimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002&'BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0013H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "divisions", "", "type", "Lme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer$Type;", "modulationStrength", "", "amplification", "animator", "Lme/bogerchan/niervisualizer/util/NierAnimator;", "(Landroid/graphics/Paint;ILme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer$Type;FFLme/bogerchan/niervisualizer/util/NierAnimator;)V", "mAggresive", "mAngleModulation", "mFFTPoints", "", "mLastDrawArea", "Landroid/graphics/Rect;", "mModulation", "", "calculate", "", "drawArea", "data", "", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "toPolar", "cartesian", "rect", "Companion", "Type", "core_release"})
public final class CircleBarRenderer
implements IRenderer {
    private float mAggresive;
    private double mModulation;
    private float mAngleModulation;
    private float[] mFFTPoints;
    private final Rect mLastDrawArea;
    private final Paint paint;
    private final int divisions;
    private final Type type;
    private final float modulationStrength;
    private final float amplification;
    private final NierAnimator animator;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onStart(int captureSize) {
        this.mFFTPoints = new float[captureSize * 4];
        this.animator.start();
    }

    @Override
    public void onStop() {
        this.animator.stop();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)this.mLastDrawArea, (Object)drawArea) ^ true) {
            this.mLastDrawArea.set(drawArea);
        }
        int drawHeight = drawArea.height();
        int n = 0;
        int n2 = data.length / this.divisions;
        while (n < n2) {
            float[] fArray;
            float[] fArray2;
            void i;
            byte rfk = data[this.divisions * i];
            byte ifk = data[this.divisions * i + 1];
            float magnitude = rfk * rfk + ifk * ifk;
            float f = (float)75 * (float)Math.log10(magnitude) * this.amplification;
            float it = f;
            float dbValue = it < 20.0f ? 20.0f : it;
            switch (CircleBarRenderer$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1: {
                    float[] fArray3 = new float[2];
                    fArray3[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray2 = fArray3;
                    fArray3[1] = (float)drawHeight / 2.0f;
                    break;
                }
                case 2: {
                    float[] fArray4 = new float[2];
                    fArray4[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray2 = fArray4;
                    fArray4[1] = (float)drawHeight / 2.0f - dbValue;
                    break;
                }
                case 3: {
                    float[] fArray5 = new float[2];
                    fArray5[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray2 = fArray5;
                    fArray5[1] = (float)drawHeight / 2.0f - dbValue;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float[] cartPoint = fArray2;
            float[] polarPoint = this.toPolar(cartPoint, drawArea);
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4] = polarPoint[0];
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + true] = polarPoint[1];
            switch (CircleBarRenderer$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
                case 1: {
                    float[] fArray6 = new float[2];
                    fArray6[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray = fArray6;
                    fArray6[1] = (float)drawHeight / 2.0f + dbValue;
                    break;
                }
                case 2: {
                    float[] fArray7 = new float[2];
                    fArray7[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray = fArray7;
                    fArray7[1] = (float)drawHeight / 2.0f;
                    break;
                }
                case 3: {
                    float[] fArray8 = new float[2];
                    fArray8[0] = (float)(i * this.divisions) / (float)(data.length - 1);
                    fArray = fArray8;
                    fArray8[1] = (float)drawHeight / 2.0f + dbValue;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float[] cartPoint2 = fArray;
            float[] polarPoint2 = this.toPolar(cartPoint2, drawArea);
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + 2] = polarPoint2[0];
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + 3] = polarPoint2[1];
            ++i;
        }
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(this.animator.computeCurrentValue(), (float)(this.mLastDrawArea.left + this.mLastDrawArea.right) / 2.0f, (float)(this.mLastDrawArea.top + this.mLastDrawArea.bottom) / 2.0f);
        if (this.mFFTPoints == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
        }
        canvas.drawLines(this.mFFTPoints, this.paint);
        canvas.restore();
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.FFT;
    }

    private final float[] toPolar(float[] cartesian, Rect rect) {
        double cX = rect.width() / 2;
        double cY = rect.height() / 2;
        double angle = (double)cartesian[0] * 2.0 * Math.PI;
        double radius = (double)((float)(rect.width() / 2) * (1.0f - this.mAggresive) + this.mAggresive * cartesian[1] / (float)2) * ((double)(1.0f - this.modulationStrength) + (double)this.modulationStrength * (1.0 + Math.sin(this.mModulation)) / (double)2);
        return new float[]{(float)(cX + radius * Math.sin(angle + (double)this.mAngleModulation)), (float)(cY + radius * Math.cos(angle + (double)this.mAngleModulation))};
    }

    public CircleBarRenderer(@NotNull Paint paint, int divisions, @NotNull Type type, float modulationStrength, float amplification, @NotNull NierAnimator animator) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        this.paint = paint;
        this.divisions = divisions;
        this.type = type;
        this.modulationStrength = modulationStrength;
        this.amplification = amplification;
        this.animator = animator;
        this.mAggresive = 0.4f;
        this.mLastDrawArea = new Rect();
    }

    public /* synthetic */ CircleBarRenderer(Paint paint, int n, Type type, float f, float f2, NierAnimator nierAnimator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            paint = CircleBarRenderer.Companion.getDefaultPaint();
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        if ((n2 & 4) != 0) {
            type = Type.TYPE_A;
        }
        if ((n2 & 8) != 0) {
            f = 0.4f;
        }
        if ((n2 & 0x10) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 0x20) != 0) {
            nierAnimator = CircleBarRenderer.Companion.getDefaultAnimator();
        }
        this(paint, n, type, f, f2, nierAnimator);
    }

    public CircleBarRenderer() {
        this(null, 0, null, 0.0f, 0.0f, null, 63, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer$Type;", "", "(Ljava/lang/String;I)V", "TYPE_A", "TYPE_B", "TYPE_A_AND_TYPE_B", "core_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type TYPE_A;
        public static final /* enum */ Type TYPE_B;
        public static final /* enum */ Type TYPE_A_AND_TYPE_B;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = TYPE_A = new Type();
            typeArray[1] = TYPE_B = new Type();
            typeArray[2] = TYPE_A_AND_TYPE_B = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer$Companion;", "", "()V", "getDefaultAnimator", "Lme/bogerchan/niervisualizer/util/NierAnimator;", "getDefaultPaint", "Landroid/graphics/Paint;", "core_release"})
    public static final class Companion {
        private final Paint getDefaultPaint() {
            Paint paint;
            Paint $receiver = paint = new Paint(1);
            $receiver.setStrokeWidth(8.0f);
            $receiver.setColor(Color.parseColor((String)"#e6ebfe"));
            return paint;
        }

        private final NierAnimator getDefaultAnimator() {
            return new NierAnimator((TimeInterpolator)new LinearInterpolator(), 20000, new float[]{0.0f, 360.0f});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

