/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.columnar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006 "}, d2={"Lme/bogerchan/niervisualizer/renderer/columnar/ColumnarType4Renderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "(Landroid/graphics/Paint;)V", "()V", "mGapRatio", "", "mLastDrawArea", "Landroid/graphics/Rect;", "mPaint", "mRadius", "mRenderColumns", "", "Landroid/graphics/RectF;", "[Landroid/graphics/RectF;", "calculate", "", "drawArea", "data", "", "calculateRenderData", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "updateWave", "core_release"})
public final class ColumnarType4Renderer
implements IRenderer {
    private final Paint mPaint;
    private final Rect mLastDrawArea;
    private RectF[] mRenderColumns;
    private final float mGapRatio = 0.7f;
    private final float mRadius = 10.0f;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStart(int captureSize) {
        void var3_4;
        RectF[] rectFArray;
        void size$iv;
        int n = Math.min(36, captureSize);
        ColumnarType4Renderer columnarType4Renderer = this;
        RectF[] result$iv = new RectF[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            RectF rectF;
            void i$iv;
            void var6_7 = i$iv;
            void var11_9 = i$iv++;
            rectFArray = result$iv;
            rectFArray[var11_9] = rectF = new RectF(0.0f, -5.0f, 0.0f, 0.0f);
        }
        rectFArray = var3_4;
        columnarType4Renderer.mRenderColumns = rectFArray;
        this.mLastDrawArea.set(0, 0, 0, 0);
    }

    @Override
    public void onStop() {
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.FFT;
    }

    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)drawArea, (Object)this.mLastDrawArea) ^ true) {
            this.calculateRenderData(drawArea);
            this.mLastDrawArea.set(drawArea);
        }
        this.updateWave(data);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWave(byte[] data) {
        int n = 0;
        int n2 = data.length / 2;
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        int n3 = Math.min(n2, ((Object[])this.mRenderColumns).length);
        while (n < n3) {
            void i;
            byte rfk = data[i];
            byte ifk = data[i + true];
            float magnitude = rfk * rfk + ifk * ifk;
            float dbValue = (float)75 * (float)Math.log10(magnitude);
            if (this.mRenderColumns == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
            }
            RectF rectF = this.mRenderColumns[i];
            rectF.top = -dbValue;
            rectF.top = rectF.top > -5.0f ? -5.0f : rectF.top;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRenderData(Rect drawArea) {
        float f = drawArea.width();
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        float perGap = f / ((float)((Object[])this.mRenderColumns).length * (this.mGapRatio + 1.0f) + 1.0f);
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        Object[] $receiver$iv = this.mRenderColumns;
        int index$iv = 0;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            void rect;
            Object item$iv = $receiver$iv[i];
            int n = index$iv++;
            RectF rectF = (RectF)item$iv;
            int index = n;
            rect.left = ((float)(index + 1) * (1.0f + this.mGapRatio) - this.mGapRatio) * perGap;
            rect.right = rect.left + this.mGapRatio * perGap;
        }
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate((float)this.mLastDrawArea.left, (float)(this.mLastDrawArea.top + this.mLastDrawArea.bottom) / 2.0f);
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        Object[] $receiver$iv = this.mRenderColumns;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            RectF it = (RectF)element$iv;
            canvas.drawRoundRect(it, this.mRadius, this.mRadius, this.mPaint);
        }
        canvas.restore();
    }

    public ColumnarType4Renderer(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.mLastDrawArea = new Rect();
        this.mGapRatio = 0.7f;
        this.mRadius = 10.0f;
        this.mPaint = paint;
    }

    public ColumnarType4Renderer() {
        this.mLastDrawArea = new Rect();
        this.mGapRatio = 0.7f;
        this.mRadius = 10.0f;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16711681);
    }
}

