/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.line;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

public class LineRenderer
implements IRenderer {
    private Paint mPaint;
    private Paint mFlashPaint;
    private boolean mCycleColor;
    private float mAmplitude = 0.0f;
    private boolean useFlashPaint = false;
    private float[] mPoints;
    private float colorCounter = 0.0f;

    public LineRenderer(boolean cycleColor) {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16711681);
        this.mPaint.setStrokeWidth(5.0f);
        this.mFlashPaint = new Paint(1);
        this.mFlashPaint.setStrokeWidth(5.0f);
        this.mFlashPaint.setColor(-16711681);
        this.mCycleColor = cycleColor;
    }

    public LineRenderer(Paint paint, Paint flashPaint) {
        this(paint, flashPaint, false);
    }

    public LineRenderer(Paint paint, Paint flashPaint, boolean cycleColor) {
        this.mPaint = paint;
        this.mFlashPaint = flashPaint;
        this.mCycleColor = cycleColor;
    }

    private void cycleColor() {
        int r = (int)Math.floor(128.0 * (Math.sin(this.colorCounter) + 3.0));
        int g = (int)Math.floor(128.0 * (Math.sin(this.colorCounter + 1.0f) + 1.0));
        int b = (int)Math.floor(128.0 * (Math.sin(this.colorCounter + 7.0f) + 1.0));
        this.mPaint.setColor(Color.argb((int)128, (int)r, (int)g, (int)b));
        this.colorCounter = (float)((double)this.colorCounter + 0.03);
    }

    @Override
    public void onStart(int captureSize) {
        this.mPoints = new float[captureSize * 4];
    }

    @Override
    public void onStop() {
    }

    @Override
    public void calculate(@NotNull Rect rect, @NotNull byte[] data) {
        if (this.mCycleColor) {
            this.cycleColor();
        }
        for (int i = 0; i < data.length - 1; ++i) {
            this.mPoints[i * 4] = rect.width() * i / (data.length - 1);
            this.mPoints[i * 4 + 1] = rect.height() / 2 + (byte)(data[i] + 128) * (rect.height() / 3) / 128;
            this.mPoints[i * 4 + 2] = rect.width() * (i + 1) / (data.length - 1);
            this.mPoints[i * 4 + 3] = rect.height() / 2 + (byte)(data[i + 1] + 128) * (rect.height() / 3) / 128;
        }
        float accumulator = 0.0f;
        for (int i = 0; i < data.length - 1; ++i) {
            accumulator += (float)Math.abs(data[i]);
        }
        float amp = accumulator / (float)(128 * data.length);
        if (amp > this.mAmplitude) {
            this.mAmplitude = amp;
            this.useFlashPaint = true;
        } else {
            this.mAmplitude = (float)((double)this.mAmplitude * 0.99);
            this.useFlashPaint = false;
        }
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        canvas.drawLines(this.mPoints, this.useFlashPaint ? this.mFlashPaint : this.mPaint);
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.WAVE;
    }
}

