/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.reporting.cucumber.builder;

import com.github.bogdanlivadariu.reporting.cucumber.json.models.Feature;
import java.util.List;

public class AllFeatureReports {
    private String pageTitle;
    private List<Feature> features;
    private int scenariosTotal;
    private int scenariosTotalPassed;
    private int scenariosTotalFailed;
    private int stepsTotal;
    private int stepsTotalPassed;
    private int stepsTotalFailed;
    private int stepsTotalSkipped;
    private long totalDuration;

    public AllFeatureReports(String pageTitle, List<Feature> features) {
        this.features = features;
        this.pageTitle = pageTitle;
        for (Feature feature : this.features) {
            this.scenariosTotal += feature.getElements().length;
            this.scenariosTotalPassed += feature.getScenariosPassedCount();
            this.scenariosTotalFailed += feature.getScenariosFailedCount();
            this.stepsTotal += feature.getStepsTotalCount();
            this.stepsTotalPassed += feature.getStepsPassedCount();
            this.stepsTotalFailed += feature.getStepsFailedCount();
            this.stepsTotalSkipped += feature.getStepsSkippedCount();
            this.totalDuration += feature.getTotal_duration();
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public int getScenariosTotal() {
        return this.scenariosTotal;
    }

    public int getScenariosTotalPassed() {
        return this.scenariosTotalPassed;
    }

    public int getScenariosTotalFailed() {
        return this.scenariosTotalFailed;
    }

    public int getStepsTotal() {
        return this.stepsTotal;
    }

    public int getStepsTotalPassed() {
        return this.stepsTotalPassed;
    }

    public int getStepsTotalFailed() {
        return this.stepsTotalFailed;
    }

    public int getStepsTotalSkipped() {
        return this.stepsTotalSkipped;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public int getFeaturesCount() {
        return this.features.size();
    }

    public String getPageTitle() {
        return this.pageTitle;
    }
}

