package com.github.bogdanlivadariu.reporting.cucumber.builder;

import static com.github.bogdanlivadariu.reporting.cucumber.helpers.Constants.FEATURE_SUMMARY_REPORT;

import java.util.List;

import com.github.bogdanlivadariu.reporting.cucumber.json.models.Feature;

public class AllFeatureReports {

    private String pageTitle;

    private List<Feature> features;

    private int scenariosTotal;

    private int scenariosTotalPassed;

    private int scenariosTotalFailed;

    private int stepsTotal;

    private int stepsTotalPassed;

    private int stepsTotalFailed;

    private int stepsTotalSkipped;

    private long totalDuration;

    public AllFeatureReports(String pageTitle, List<Feature> features) {
        this.features = features;
        this.pageTitle = pageTitle;
        for (Feature feature : this.features) {
            scenariosTotal += feature.getElements().length;
            scenariosTotalPassed += feature.getScenariosPassedCount();
            scenariosTotalFailed += feature.getScenariosFailedCount();

            stepsTotal += feature.getStepsTotalCount();
            stepsTotalPassed += feature.getStepsPassedCount();
            stepsTotalFailed += feature.getStepsFailedCount();
            stepsTotalSkipped += feature.getStepsSkippedCount();

            totalDuration += feature.getTotal_duration();
        }
    }

    public List<Feature> getFeatures() {
        return features;
    }

    public int getScenariosTotal() {
        return scenariosTotal;
    }

    public int getScenariosTotalPassed() {
        return scenariosTotalPassed;
    }

    public int getScenariosTotalFailed() {
        return scenariosTotalFailed;
    }

    public int getStepsTotal() {
        return stepsTotal;
    }

    public int getStepsTotalPassed() {
        return stepsTotalPassed;
    }

    public int getStepsTotalFailed() {
        return stepsTotalFailed;
    }

    public int getStepsTotalSkipped() {
        return stepsTotalSkipped;
    }

    public long getTotalDuration() {
        return totalDuration;
    }

    public int getFeaturesCount() {
        return features.size();
    }

    public String getPageTitle() {
        return pageTitle;
    }
}
