/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.text.StringSubstitutor;

final class FilenameInterpolator {
    private final String pattern;
    private final String prefix;
    private final String suffix;
    private final char escapeChar;

    public FilenameInterpolator(String pattern) {
        this(pattern, "#{", "}", '#');
    }

    public FilenameInterpolator(String pattern, String prefix, String suffix, char escapeChar) {
        this.pattern = pattern;
        this.prefix = prefix;
        this.suffix = suffix;
        this.escapeChar = escapeChar;
    }

    public File interpolate(File inputFile, File inputBaseDir, File targetDirectory) {
        return this.interpolate(inputFile, inputBaseDir, targetDirectory, null);
    }

    public File interpolate(File inputFile, File inputBaseDir, File targetDirectory, Map<String, String> additionalData) {
        String interpolatedFilename = this.interpolateRelative(inputFile, inputBaseDir, additionalData);
        return new File(targetDirectory, interpolatedFilename);
    }

    public String interpolateRelative(File inputFile, File inputBaseDir) {
        return this.interpolateRelative(inputFile, inputBaseDir, null);
    }

    public String interpolateRelative(File inputFile, File inputBaseDir, Map<String, String> additionalData) {
        String inputFilename = inputFile.getName();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filename", inputFilename);
        data.put("extension", FilenameUtils.getExtension((String)inputFilename));
        data.put("basename", FilenameUtils.getBaseName((String)inputFilename));
        data.put("path", FileHelper.relativizePath(inputBaseDir, inputFile.getParentFile()));
        if (additionalData != null) {
            data.putAll(additionalData);
        }
        StringSubstitutor stringSubstitutor = new StringSubstitutor(data, this.prefix, this.suffix, this.escapeChar);
        return stringSubstitutor.replace(this.pattern);
    }
}

