/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.plugin;

import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileException;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileProcessConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSpecifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.FilenameInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.ProcessingResult;
import com.github.blutorange.maven.plugin.closurecompiler.common.SourceFilesEnumeration;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.MojoMetadata;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.SkipMode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class ProcessFilesTask
implements Callable<Object> {
    private static final String DEFAULT_MERGED_FILENAME = "script.js";
    public static final String TEMP_SUFFIX = ".tmp";
    protected final MojoMetadata mojoMeta;
    protected final ClosureConfig closureConfig;
    protected final List<File> files = new ArrayList<File>();
    protected final boolean includesEmpty;
    protected final FilenameInterpolator outputFilenameInterpolator;
    protected final FileProcessConfig processConfig;
    protected final File sourceDir;
    protected final File targetDir;

    private static void addNewSourceFile(Collection<File> files, File sourceFile, MojoMetadata mojoMeta) throws IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("The source file [" + sourceFile.getPath() + "] does not exist.");
        }
        mojoMeta.getLog().debug((CharSequence)("Adding source file [" + sourceFile.getPath() + "]."));
        files.add(sourceFile.getCanonicalFile());
    }

    public ProcessFilesTask(MojoMetadata mojoMeta, FileProcessConfig processConfig, FileSpecifier fileSpecifier, ClosureConfig closureConfig) throws IOException {
        this.mojoMeta = mojoMeta;
        this.processConfig = processConfig;
        File projectBasedir = mojoMeta.getProject().getBasedir();
        this.sourceDir = FileHelper.getFile(FileHelper.getAbsoluteFile(projectBasedir, fileSpecifier.getBaseSourceDir()), fileSpecifier.getSourceDir()).getAbsoluteFile().getCanonicalFile();
        this.targetDir = FileHelper.getFile(FileHelper.getAbsoluteFile(projectBasedir, fileSpecifier.getBaseTargetDir()), fileSpecifier.getTargetDir()).getAbsoluteFile().getCanonicalFile();
        this.outputFilenameInterpolator = new FilenameInterpolator(fileSpecifier.getOutputFilename());
        for (File include : FileHelper.getIncludedFiles(this.sourceDir, fileSpecifier.getIncludes(), fileSpecifier.getExcludes())) {
            if (this.files.contains(include)) continue;
            ProcessFilesTask.addNewSourceFile(this.files, include, mojoMeta);
        }
        this.includesEmpty = fileSpecifier.getIncludes().isEmpty();
        this.closureConfig = closureConfig;
    }

    private void assertTarget(File source, File target) throws MojoFailureException {
        if (target.getAbsolutePath().equals(source.getAbsolutePath())) {
            String msg = "The source file [" + source.getName() + "] has the same name as the output file [" + target.getName() + "].";
            this.mojoMeta.getLog().warn((CharSequence)msg);
            this.mojoMeta.getLog().debug((CharSequence)("Full path for source file is [" + source.getPath() + "] and for target file [" + target.getPath() + "]"));
            throw new MojoFailureException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws IOException, MojoFailureException {
        Log log = this.mojoMeta.getLog();
        synchronized (log) {
            this.mojoMeta.getLog().info((CharSequence)"Starting JavaScript task:");
            if (!this.files.isEmpty()) {
                try {
                    this.processFiles();
                }
                catch (FileException e) {
                    this.logFailure(e);
                    throw new MojoFailureException("Closure compilation failure", (Throwable)e);
                }
                catch (Exception e) {
                    this.logFailure(e);
                    this.files.forEach(file -> this.mojoMeta.getBuildContext().addMessage(file, 1, 1, e.getMessage(), 2, (Throwable)e));
                    throw e;
                }
            } else if (!this.includesEmpty) {
                this.mojoMeta.getLog().error((CharSequence)"No valid JavaScript source files found to process.");
            }
        }
        return null;
    }

    private void logFailure(Exception e) {
        if (e != null && e instanceof FileException) {
            ((FileException)e).getFileErrors().forEach(fileError -> fileError.addTo(this.mojoMeta.getBuildContext()));
        }
        this.mojoMeta.getLog().error((CharSequence)("Failed to process the source files [" + this.files.stream().map(File::getName).collect(Collectors.joining(", ")) + "]."), (Throwable)e);
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + this.files.stream().map(File::getPath).collect(Collectors.joining(", ")) + "]"));
    }

    private void processFiles() throws IOException, MojoFailureException {
        ArrayList<ProcessingResult> results = new ArrayList<ProcessingResult>();
        if (this.processConfig.isSkipMerge()) {
            this.mojoMeta.getLog().info((CharSequence)"Skipping the merge step...");
            for (File sourceFile : this.files) {
                File minifiedFile = this.outputFilenameInterpolator.interpolate(sourceFile, this.sourceDir, this.targetDir);
                this.assertTarget(sourceFile, minifiedFile);
                if (this.processConfig.isSkipMinify()) {
                    results.add(this.copy(sourceFile, minifiedFile));
                    continue;
                }
                results.add(this.minify(sourceFile, minifiedFile));
            }
        } else if (this.processConfig.isSkipMinify()) {
            File mergedFile = this.outputFilenameInterpolator.interpolate(new File(this.targetDir, DEFAULT_MERGED_FILENAME), this.targetDir, this.targetDir);
            results.add(this.merge(mergedFile));
            this.mojoMeta.getLog().info((CharSequence)"Skipping the minify step...");
        } else {
            File minifiedFile = this.outputFilenameInterpolator.interpolate(new File(this.targetDir, DEFAULT_MERGED_FILENAME), this.targetDir, this.targetDir);
            results.add(this.minify(this.files, minifiedFile));
        }
        this.logResults(results);
    }

    protected void removeMessages(Collection<File> files) {
        files.forEach(file -> this.mojoMeta.getBuildContext().removeMessages(file));
    }

    protected void logCompressionGains(List<File> srcFiles, String minified) {
        if (!this.mojoMeta.getLog().isInfoEnabled() || this.mojoMeta.getBuildContext().isIncremental()) {
            return;
        }
        try {
            long compressedSizeGzip;
            byte[] minifiedData = minified.getBytes(this.mojoMeta.getEncoding());
            long compressedSize = minifiedData.length;
            try (ByteArrayInputStream in = new ByteArrayInputStream(minifiedData);
                 CountingOutputStream out = new CountingOutputStream((OutputStream)new NullOutputStream());
                 GZIPOutputStream outGZIP = new GZIPOutputStream((OutputStream)out);){
                IOUtils.copy((InputStream)in, (OutputStream)outGZIP, (int)this.processConfig.getBufferSize());
                outGZIP.finish();
                compressedSizeGzip = out.getByteCount();
            }
            long uncompressedSize = 0L;
            if (srcFiles != null) {
                for (File srcFile : srcFiles) {
                    uncompressedSize += srcFile.length();
                }
            }
            this.mojoMeta.getLog().info((CharSequence)("Uncompressed size: " + uncompressedSize + " bytes."));
            this.mojoMeta.getLog().info((CharSequence)("Compressed size: " + compressedSize + " bytes minified (" + compressedSizeGzip + " bytes gzipped)."));
        }
        catch (IOException e) {
            this.mojoMeta.getLog().debug((CharSequence)"Failed to calculate the gzipped file size.", (Throwable)e);
        }
    }

    protected void mkDir(File directory) {
        if (directory.exists()) {
            return;
        }
        File firstThatExists = directory;
        while ((firstThatExists = firstThatExists.getParentFile()) != null && !firstThatExists.exists()) {
        }
        try {
            if (!directory.mkdirs()) {
                throw new RuntimeException("Unable to create target directory: " + directory.getPath());
            }
        }
        finally {
            if (firstThatExists != null) {
                this.mojoMeta.getBuildContext().refresh(firstThatExists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessingResult copy(File sourceFile, File targetFile) throws IOException {
        if (!this.haveFilesChanged(Collections.singleton(sourceFile), Collections.singleton(targetFile))) {
            return new ProcessingResult().setWasSkipped(true);
        }
        this.mkDir(this.targetDir);
        this.mkDir(targetFile.getParentFile());
        FileInputStream in = null;
        OutputStream out = null;
        Reader reader = null;
        Writer writer = null;
        try {
            in = new FileInputStream(sourceFile);
            out = this.mojoMeta.getBuildContext().newFileOutputStream(targetFile);
            try {
                reader = new InputStreamReader((InputStream)in, this.mojoMeta.getEncoding());
            }
            finally {
                if (reader == null && in != null) {
                    ((InputStream)in).close();
                }
            }
            try {
                writer = new OutputStreamWriter(out, this.mojoMeta.getEncoding());
            }
            finally {
                if (writer == null && out != null) {
                    out.close();
                }
            }
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        this.mojoMeta.getLog().info((CharSequence)("Creating the copied file [" + targetFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + targetFile.getPath() + "]."));
        return new ProcessingResult().setWasSkipped(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessingResult merge(File mergedFile) throws IOException {
        if (!this.haveFilesChanged(this.files, Collections.singleton(mergedFile))) {
            return new ProcessingResult().setWasSkipped(true);
        }
        this.mkDir(this.targetDir);
        this.mkDir(mergedFile.getParentFile());
        this.mojoMeta.getLog().info((CharSequence)("Creating the merged file [" + mergedFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + mergedFile.getPath() + "]."));
        SequenceInputStream sequence = null;
        OutputStream out = null;
        InputStreamReader sequenceReader = null;
        OutputStreamWriter outWriter = null;
        try {
            sequence = new SequenceInputStream(new SourceFilesEnumeration(this.mojoMeta.getLog(), this.files, this.mojoMeta.getEncoding(), this.processConfig.getLineSeparator()));
            out = this.mojoMeta.getBuildContext().newFileOutputStream(mergedFile);
            try {
                sequenceReader = new InputStreamReader((InputStream)sequence, this.mojoMeta.getEncoding());
            }
            finally {
                if (sequenceReader == null && sequence != null) {
                    ((InputStream)sequence).close();
                }
            }
            try {
                outWriter = new OutputStreamWriter(out, this.mojoMeta.getEncoding());
            }
            finally {
                if (outWriter == null && out != null) {
                    out.close();
                }
            }
            IOUtils.copyLarge((Reader)sequenceReader, (Writer)outWriter, (char[])new char[this.processConfig.getBufferSize()]);
            outWriter.append(this.processConfig.getLineSeparator());
        }
        finally {
            try {
                if (sequenceReader != null) {
                    sequenceReader.close();
                }
            }
            finally {
                if (outWriter != null) {
                    outWriter.close();
                }
            }
        }
        return new ProcessingResult().setWasSkipped(false);
    }

    protected boolean haveFilesChanged(Collection<File> sourceFiles, Collection<File> outputFiles) {
        boolean changed;
        if (this.processConfig.isForce() && this.mojoMeta.getBuildContext().isIncremental()) {
            this.mojoMeta.getLog().warn((CharSequence)"Force is enabled, but building incrementally. Using the force option in an m2e incremental build will result in an endless build loop.");
        }
        if (this.processConfig.isForce()) {
            this.mojoMeta.getLog().info((CharSequence)"Force is enabled, skipping check for changed files.");
            changed = true;
        } else {
            changed = this.mojoMeta.getBuildContext().isIncremental() ? sourceFiles.stream().anyMatch(arg_0 -> ((BuildContext)this.mojoMeta.getBuildContext()).hasDelta(arg_0)) : this.checkFilesForChanges(sourceFiles, outputFiles);
        }
        if (changed) {
            this.removeMessages(sourceFiles);
        }
        if (this.mojoMeta.getLog().isDebugEnabled()) {
            String prefix = changed ? "Changes since last build, processing bundle with output files [" : "No changes since last build, skipping bundle with output files [";
            this.mojoMeta.getLog().debug((CharSequence)(prefix + outputFiles.stream().map(File::getPath).collect(Collectors.joining(", ")) + "]."));
        }
        return changed;
    }

    private boolean checkFilesForChanges(Collection<File> sourceFiles, Collection<File> ouptutFiles) {
        boolean ouptutFilesExist = ouptutFiles.stream().allMatch(File::exists);
        switch ((SkipMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.processConfig.getSkipMode()), (Object)((Object)SkipMode.NEWER)))) {
            case NEWER: {
                if (ouptutFilesExist) {
                    long oldestOutputFile = ouptutFiles.stream().map(File::lastModified).min(Long::compare).orElse(0L);
                    long youngestSourceFile = sourceFiles.stream().map(File::lastModified).max(Long::compare).orElse(Long.MAX_VALUE);
                    this.mojoMeta.getLog().debug((CharSequence)("Date of oldest output file is" + new Date(oldestOutputFile)));
                    this.mojoMeta.getLog().debug((CharSequence)("Date of youngest source file is " + new Date(youngestSourceFile)));
                    return oldestOutputFile <= youngestSourceFile;
                }
                return true;
            }
            case EXISTS: {
                return !ouptutFilesExist;
            }
        }
        throw new RuntimeException("Unhandled enum: " + (Object)((Object)this.processConfig.getSkipMode()));
    }

    private void logResults(List<ProcessingResult> results) {
        long skippedCount = results.stream().filter(ProcessingResult::isWasSkipped).count();
        long processedCount = (long)results.size() - skippedCount;
        this.mojoMeta.getLog().info((CharSequence)("Processed " + (processedCount + skippedCount) + " output files"));
        if (processedCount > 0L) {
            this.mojoMeta.getLog().info((CharSequence)("Created " + processedCount + " output files"));
        }
        if (skippedCount > 0L) {
            this.mojoMeta.getLog().info((CharSequence)("Skipped " + skippedCount + " output files (" + (Object)((Object)this.processConfig.getSkipMode()) + ")"));
        }
    }

    abstract ProcessingResult minify(File var1, File var2) throws IOException, MojoFailureException;

    abstract ProcessingResult minify(List<File> var1, File var2) throws IOException, MojoFailureException;
}

