/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.decode;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.blikoon.qrcodescanner.QrCodeActivity;
import com.blikoon.qrcodescanner.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

final class DecodeHandler
extends Handler {
    private final QrCodeActivity mActivity;
    private final QRCodeReader mQrCodeReader;
    private final Map<DecodeHintType, Object> mHints;
    private byte[] mRotatedData;

    DecodeHandler(QrCodeActivity activity) {
        this.mActivity = activity;
        this.mQrCodeReader = new QRCodeReader();
        this.mHints = new Hashtable<DecodeHintType, Object>();
        this.mHints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        this.mHints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, BarcodeFormat.QR_CODE);
    }

    public void handleMessage(Message message) {
        Looper looper;
        if (message.what == R.id.decode) {
            this.decode((byte[])message.obj, message.arg1, message.arg2);
        } else if (message.what == R.id.quit && null != (looper = Looper.myLooper())) {
            looper.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(byte[] data, int width, int height) {
        Message message;
        if (null == this.mRotatedData) {
            this.mRotatedData = new byte[width * height];
        } else if (this.mRotatedData.length < width * height) {
            this.mRotatedData = new byte[width * height];
        }
        Arrays.fill(this.mRotatedData, (byte)0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width && x + y * width < data.length; ++x) {
                this.mRotatedData[x * height + height - y - 1] = data[x + y * width];
            }
        }
        int tmp = width;
        width = height;
        height = tmp;
        Result rawResult = null;
        try {
            PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(this.mRotatedData, width, height, 0, 0, width, height, false);
            BinaryBitmap bitmap1 = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            rawResult = this.mQrCodeReader.decode(bitmap1, this.mHints);
        }
        catch (ReaderException source) {
        }
        finally {
            this.mQrCodeReader.reset();
        }
        if (rawResult != null) {
            message = Message.obtain((Handler)this.mActivity.getCaptureActivityHandler(), (int)R.id.decode_succeeded, rawResult);
            message.sendToTarget();
        } else {
            message = Message.obtain((Handler)this.mActivity.getCaptureActivityHandler(), (int)R.id.decode_failed);
            message.sendToTarget();
        }
    }
}

