/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.blikoon.qrcodescanner.R;
import com.blikoon.qrcodescanner.camera.CameraManager;
import com.blikoon.qrcodescanner.decode.CaptureActivityHandler;
import com.blikoon.qrcodescanner.decode.DecodeImageCallback;
import com.blikoon.qrcodescanner.decode.DecodeImageThread;
import com.blikoon.qrcodescanner.decode.DecodeManager;
import com.blikoon.qrcodescanner.decode.InactivityTimer;
import com.blikoon.qrcodescanner.view.QrCodeFinderView;
import com.google.zxing.Result;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class QrCodeActivity
extends Activity
implements SurfaceHolder.Callback,
View.OnClickListener {
    private static final int REQUEST_SYSTEM_PICTURE = 0;
    private static final int REQUEST_PICTURE = 1;
    public static final int MSG_DECODE_SUCCEED = 1;
    public static final int MSG_DECODE_FAIL = 2;
    private CaptureActivityHandler mCaptureActivityHandler;
    private boolean mHasSurface;
    private boolean mPermissionOk;
    private InactivityTimer mInactivityTimer;
    private QrCodeFinderView mQrCodeFinderView;
    private SurfaceView mSurfaceView;
    private View mLlFlashLight;
    private final DecodeManager mDecodeManager = new DecodeManager();
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private MediaPlayer mMediaPlayer;
    private boolean mPlayBeep;
    private boolean mVibrate;
    private boolean mNeedFlashLightOpen = true;
    private ImageView mIvFlashLight;
    private TextView mTvFlashLightText;
    private Executor mQrCodeExecutor;
    private Handler mHandler;
    private final String GOT_RESULT = "com.blikoon.qrcodescanner.got_qr_scan_relult";
    private final String ERROR_DECODING_IMAGE = "com.blikoon.qrcodescanner.error_decoding_image";
    private final String LOGTAG = "QRScannerQRCodeActivity";
    private Context mApplicationContext;
    private final MediaPlayer.OnCompletionListener mBeepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };
    private DecodeImageCallback mDecodeImageCallback = new DecodeImageCallback(){

        @Override
        public void decodeSucceed(Result result) {
            Log.d((String)"QRScannerQRCodeActivity", (String)("Decoded the image successfully :" + result.getText()));
            Intent data = new Intent();
            data.putExtra("com.blikoon.qrcodescanner.got_qr_scan_relult", result.getText());
            QrCodeActivity.this.setResult(-1, data);
            QrCodeActivity.this.finish();
        }

        @Override
        public void decodeFail(int type, String reason) {
            Log.d((String)"QRScannerQRCodeActivity", (String)("Something went wrong decoding the image :" + reason));
            Intent data = new Intent();
            data.putExtra("com.blikoon.qrcodescanner.error_decoding_image", reason);
            QrCodeActivity.this.setResult(0, data);
            QrCodeActivity.this.finish();
        }
    };

    private static Intent createIntent(Context context) {
        Intent i = new Intent(context, QrCodeActivity.class);
        return i;
    }

    public static void launch(Context context) {
        Intent i = QrCodeActivity.createIntent(context);
        context.startActivity(i);
    }

    public void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_qr_code);
        this.initView();
        this.initData();
        this.mApplicationContext = this.getApplicationContext();
    }

    private void checkPermission() {
        boolean hasHardware = this.checkCameraHardWare((Context)this);
        if (hasHardware) {
            if (!this.hasCameraPermission()) {
                this.findViewById(R.id.qr_code_view_background).setVisibility(0);
                this.mQrCodeFinderView.setVisibility(8);
                this.mPermissionOk = false;
            } else {
                this.mPermissionOk = true;
            }
        } else {
            this.mPermissionOk = false;
            this.finish();
        }
    }

    private void initView() {
        TextView tvPic = (TextView)this.findViewById(R.id.qr_code_header_black_pic);
        this.mIvFlashLight = (ImageView)this.findViewById(R.id.qr_code_iv_flash_light);
        this.mTvFlashLightText = (TextView)this.findViewById(R.id.qr_code_tv_flash_light);
        this.mQrCodeFinderView = (QrCodeFinderView)this.findViewById(R.id.qr_code_view_finder);
        this.mSurfaceView = (SurfaceView)this.findViewById(R.id.qr_code_preview_view);
        this.mLlFlashLight = this.findViewById(R.id.qr_code_ll_flash_light);
        this.mHasSurface = false;
        this.mIvFlashLight.setOnClickListener((View.OnClickListener)this);
        tvPic.setOnClickListener((View.OnClickListener)this);
    }

    private void initData() {
        CameraManager.init((Context)this);
        this.mInactivityTimer = new InactivityTimer(this);
        this.mQrCodeExecutor = Executors.newSingleThreadExecutor();
        this.mHandler = new WeakHandler(this);
    }

    private boolean hasCameraPermission() {
        PackageManager pm = this.getPackageManager();
        return 0 == pm.checkPermission("android.permission.CAMERA", this.getPackageName());
    }

    protected void onResume() {
        super.onResume();
        this.checkPermission();
        if (!this.mPermissionOk) {
            this.mDecodeManager.showPermissionDeniedDialog((Context)this);
            return;
        }
        SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
        this.turnFlashLightOff();
        if (this.mHasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.mPlayBeep = true;
        AudioManager audioService = (AudioManager)this.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            this.mPlayBeep = false;
        }
        this.initBeepSound();
        this.mVibrate = true;
    }

    protected void onPause() {
        super.onPause();
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.quitSynchronously();
            this.mCaptureActivityHandler = null;
        }
        CameraManager.get().closeDriver();
    }

    protected void onDestroy() {
        if (null != this.mInactivityTimer) {
            this.mInactivityTimer.shutdown();
        }
        super.onDestroy();
    }

    public void handleDecode(Result result) {
        this.mInactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        if (null == result) {
            this.mDecodeManager.showCouldNotReadQrCodeFromScanner((Context)this, new DecodeManager.OnRefreshCameraListener(){

                @Override
                public void refresh() {
                    QrCodeActivity.this.restartPreview();
                }
            });
        } else {
            String resultString = result.getText();
            this.handleResult(resultString);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException e) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.qr_code_camera_not_found), (int)0).show();
            this.finish();
            return;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.mDecodeManager.showPermissionDeniedDialog((Context)this);
            return;
        }
        this.mQrCodeFinderView.setVisibility(0);
        this.mSurfaceView.setVisibility(0);
        this.mLlFlashLight.setVisibility(0);
        this.findViewById(R.id.qr_code_view_background).setVisibility(8);
        if (this.mCaptureActivityHandler == null) {
            this.mCaptureActivityHandler = new CaptureActivityHandler(this);
        }
    }

    private void restartPreview() {
        if (null != this.mCaptureActivityHandler) {
            this.mCaptureActivityHandler.restartPreviewAndDecode();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    private boolean checkCameraHardWare(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.hasSystemFeature("android.hardware.camera");
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.mHasSurface) {
            this.mHasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mHasSurface = false;
    }

    public Handler getCaptureActivityHandler() {
        return this.mCaptureActivityHandler;
    }

    private void initBeepSound() {
        if (this.mPlayBeep && this.mMediaPlayer == null) {
            this.setVolumeControlStream(3);
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnCompletionListener(this.mBeepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mMediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mMediaPlayer.setVolume(0.1f, 0.1f);
                this.mMediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mMediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.mPlayBeep && this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
        }
        if (this.mVibrate) {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.qr_code_iv_flash_light) {
            if (this.mNeedFlashLightOpen) {
                this.turnFlashlightOn();
            } else {
                this.turnFlashLightOff();
            }
        } else if (v.getId() == R.id.qr_code_header_black_pic) {
            if (!this.hasCameraPermission()) {
                this.mDecodeManager.showPermissionDeniedDialog((Context)this);
            } else {
                this.openSystemAlbum();
            }
        }
    }

    private void openSystemAlbum() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        this.startActivityForResult(intent, 0);
    }

    private void turnFlashlightOn() {
        this.mNeedFlashLightOpen = false;
        this.mTvFlashLightText.setText((CharSequence)this.getString(R.string.qr_code_close_flash_light));
        this.mIvFlashLight.setBackgroundResource(R.drawable.flashlight_turn_off);
        CameraManager.get().setFlashLight(true);
    }

    private void turnFlashLightOff() {
        this.mNeedFlashLightOpen = true;
        this.mTvFlashLightText.setText((CharSequence)this.getString(R.string.qr_code_open_flash_light));
        this.mIvFlashLight.setBackgroundResource(R.drawable.flashlight_turn_on);
        CameraManager.get().setFlashLight(false);
    }

    private void handleResult(String resultString) {
        if (TextUtils.isEmpty((CharSequence)resultString)) {
            this.mDecodeManager.showCouldNotReadQrCodeFromScanner((Context)this, new DecodeManager.OnRefreshCameraListener(){

                @Override
                public void refresh() {
                    QrCodeActivity.this.restartPreview();
                }
            });
        } else {
            Log.d((String)"QRScannerQRCodeActivity", (String)("Got scan result from user loaded image :" + resultString));
            Intent data = new Intent();
            data.putExtra("com.blikoon.qrcodescanner.got_qr_scan_relult", resultString);
            this.setResult(-1, data);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 1: {
                this.finish();
                break;
            }
            case 0: {
                Uri uri = data.getData();
                String imgPath = this.getPathFromUri(uri);
                if (imgPath == null || TextUtils.isEmpty((CharSequence)imgPath) || null == this.mQrCodeExecutor) break;
                this.mQrCodeExecutor.execute(new DecodeImageThread(imgPath, this.mDecodeImageCallback));
            }
        }
    }

    public String getPathFromUri(Uri uri) {
        Cursor cursor = this.getContentResolver().query(uri, null, null, null, null);
        cursor.moveToFirst();
        String document_id = cursor.getString(0);
        document_id = document_id.substring(document_id.lastIndexOf(":") + 1);
        cursor.close();
        cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, "_id = ? ", new String[]{document_id}, null);
        cursor.moveToFirst();
        String path = cursor.getString(cursor.getColumnIndex("_data"));
        cursor.close();
        return path;
    }

    private static class WeakHandler
    extends Handler {
        private WeakReference<QrCodeActivity> mWeakQrCodeActivity;
        private DecodeManager mDecodeManager = new DecodeManager();

        public WeakHandler(QrCodeActivity imagePickerActivity) {
            this.mWeakQrCodeActivity = new WeakReference<QrCodeActivity>(imagePickerActivity);
        }

        public void handleMessage(Message msg) {
            QrCodeActivity qrCodeActivity = (QrCodeActivity)((Object)this.mWeakQrCodeActivity.get());
            switch (msg.what) {
                case 1: {
                    Result result = (Result)msg.obj;
                    if (null == result) {
                        this.mDecodeManager.showCouldNotReadQrCodeFromPicture((Context)qrCodeActivity);
                        break;
                    }
                    String resultString = result.getText();
                    this.handleResult(resultString);
                    break;
                }
                case 2: {
                    this.mDecodeManager.showCouldNotReadQrCodeFromPicture((Context)qrCodeActivity);
                }
            }
            super.handleMessage(msg);
        }

        private void handleResult(String resultString) {
            QrCodeActivity imagePickerActivity = (QrCodeActivity)((Object)this.mWeakQrCodeActivity.get());
            this.mDecodeManager.showResultDialog(imagePickerActivity, resultString, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
        }
    }
}

