/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.decode;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.blikoon.qrcodescanner.decode.DecodeImageCallback;
import com.blikoon.qrcodescanner.utils.QrUtils;
import com.google.zxing.Result;

public class DecodeImageThread
implements Runnable {
    private static final int MAX_PICTURE_PIXEL = 256;
    private byte[] mData;
    private int mWidth;
    private int mHeight;
    private String mImgPath;
    private DecodeImageCallback mCallback;

    public DecodeImageThread(String imgPath, DecodeImageCallback callback) {
        this.mImgPath = imgPath;
        this.mCallback = callback;
    }

    @Override
    public void run() {
        if (null == this.mData && !TextUtils.isEmpty((CharSequence)this.mImgPath)) {
            Bitmap bitmap = QrUtils.decodeSampledBitmapFromFile(this.mImgPath, 256, 256);
            this.mData = QrUtils.getYUV420sp(bitmap.getWidth(), bitmap.getHeight(), bitmap);
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
        }
        if (this.mData == null || this.mData.length == 0 || this.mWidth == 0 || this.mHeight == 0) {
            if (null != this.mCallback) {
                this.mCallback.decodeFail(0, "No image data");
            }
            return;
        }
        Result result = QrUtils.decodeImage(this.mData, this.mWidth, this.mHeight);
        if (null != this.mCallback) {
            if (null != result) {
                this.mCallback.decodeSucceed(result);
            } else {
                this.mCallback.decodeFail(0, "Decode image failed.");
            }
        }
    }
}

