/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

final class AutoFocusCallback
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusCallback.class.getName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 1500L;
    private Handler mAutoFocusHandler;
    private int mAutoFocusMessage;

    AutoFocusCallback() {
    }

    void setHandler(Handler autoFocusHandler, int autoFocusMessage) {
        this.mAutoFocusHandler = autoFocusHandler;
        this.mAutoFocusMessage = autoFocusMessage;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        if (this.mAutoFocusHandler != null) {
            Message message = this.mAutoFocusHandler.obtainMessage(this.mAutoFocusMessage, (Object)success);
            this.mAutoFocusHandler.sendMessageDelayed(message, 1500L);
            this.mAutoFocusHandler = null;
        } else {
            Log.v((String)TAG, (String)"Got auto-focus callback, but no handler for it");
        }
    }
}

